/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.utils.bst_reader;

import com.linkedin.databus.bootstrap.utils.bst_reader.MetaDataFilters;

public class MetaDataFiltersBuilder {
    private String _minKey;
    private String _maxKey;
    private long _minScn = -1L;
    private long _maxScn = -1L;

    public MetaDataFilters build() {
        if (this._minKey != null && this._maxKey != null && this._maxKey.compareTo(this._minKey) < 0) {
            throw new IllegalArgumentException("minimum key " + this._minKey + " > maximum key " + this._maxKey);
        }
        if (this._minScn > 0L && this._maxScn > 0L && this._maxScn > this._minScn) {
            throw new IllegalArgumentException("minimum scn " + this._minScn + " > maximum scn " + this._maxScn);
        }
        return new MetaDataFilters(this._minKey, this._maxKey, this._minScn, this._maxScn);
    }

    public String minKey() {
        return this._minKey;
    }

    public MetaDataFiltersBuilder minKey(String minKey) {
        this._minKey = minKey;
        return this;
    }

    public String maxKey() {
        return this._maxKey;
    }

    public MetaDataFiltersBuilder maxKey(String maxKey) {
        this._maxKey = maxKey;
        return this;
    }

    public long minScn() {
        return this._minScn;
    }

    public MetaDataFiltersBuilder minScn(long minScn) {
        this._minScn = minScn;
        return this;
    }

    public long maxScn() {
        return this._maxScn;
    }

    public MetaDataFiltersBuilder maxScn(long maxScn) {
        this._maxScn = maxScn;
        return this;
    }
}

