/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.utils.bst_reader;

import com.linkedin.databus.bootstrap.common.BootstrapConn;
import com.linkedin.databus.bootstrap.common.BootstrapReadOnlyConfig;
import com.linkedin.databus.bootstrap.utils.BootstrapReaderEventHandler;
import com.linkedin.databus.bootstrap.utils.bst_reader.MetaDataFilters;
import com.linkedin.databus.bootstrap.utils.bst_reader.filter.BootstrapReaderFilter;
import com.linkedin.databus.client.DbusEventAvroDecoder;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusEventFactory;
import com.linkedin.databus.core.DbusEventInternalReadable;
import com.linkedin.databus.core.DbusEventV1Factory;
import com.linkedin.databus2.schemas.VersionedSchemaSet;
import com.linkedin.databus2.util.DBHelper;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.log4j.Logger;

public class BootstrapTableReaderV2 {
    private static final int MAX_EVENT_SIZE = 0x1400000;
    private final String _tableName;
    private final DbusEventAvroDecoder _decoder;
    private final DbusEventFactory _eventFactory;
    private final BootstrapReaderEventHandler _eventHandler;
    private final List<BootstrapReaderFilter> _eventFilters;
    private final BootstrapReadOnlyConfig _bstConfig;
    private final Logger _log;
    private final BootstrapConn _bootstrapConn;
    private final Connection _jdbcConn;
    private final MetaDataFilters _metadataFilters;
    private final String _queryString;
    private final PreparedStatement _query;

    public BootstrapTableReaderV2(String tableName, MetaDataFilters metadataFilters, VersionedSchemaSet schemaSet, BootstrapReaderEventHandler eventHandler, List<BootstrapReaderFilter> eventFilters, BootstrapReadOnlyConfig bstConfig, Logger log) throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        this._log = null != log ? log : Logger.getLogger(BootstrapTableReaderV2.class);
        this._metadataFilters = metadataFilters;
        this._tableName = tableName;
        this._decoder = new DbusEventAvroDecoder(schemaSet);
        this._eventFactory = new DbusEventV1Factory();
        this._eventHandler = eventHandler;
        this._eventFilters = new ArrayList<BootstrapReaderFilter>(eventFilters);
        this._bstConfig = bstConfig;
        this._bootstrapConn = this.createBstConnection();
        this._jdbcConn = this._bootstrapConn.getDBConn();
        this._queryString = this.createQueryString();
        this._query = this._jdbcConn.prepareStatement(this._queryString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws SQLException {
        ResultSet rs = null;
        boolean hasMore = true;
        long curId = -1L;
        try {
            this._log.info((Object)("Executing query : " + this._queryString));
            ByteBuffer buffer = ByteBuffer.allocateDirect(0x1400000);
            int count = 0;
            DbusEventInternalReadable event = this._eventFactory.createReadOnlyDbusEventFromBuffer(buffer, 0);
            this._eventHandler.onStart(this._queryString);
            while (hasMore) {
                this._log.debug((Object)("currentId=" + curId));
                this._query.setLong(1, curId);
                rs = this._query.executeQuery();
                hasMore = false;
                while (rs.next()) {
                    hasMore = true;
                    buffer.clear();
                    buffer.put(rs.getBytes("val"));
                    curId = rs.getLong("id");
                    event = event.reset(buffer, 0);
                    GenericRecord record = this._decoder.getGenericRecord((DbusEvent)event);
                    if (this.checkFilters(event, record)) {
                        this._eventHandler.onRecord((DbusEvent)event, record);
                    }
                    ++count;
                }
                rs.close();
            }
            this._eventHandler.onEnd(count);
        }
        finally {
            DBHelper.close(rs, (Statement)this._query, (Connection)this._jdbcConn);
        }
    }

    private boolean checkFilters(DbusEventInternalReadable event, GenericRecord payload) {
        for (BootstrapReaderFilter filter : this._eventFilters) {
            if (filter.matches((DbusEvent)event, payload)) continue;
            return false;
        }
        return true;
    }

    private BootstrapConn createBstConnection() throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        this._log.info((Object)"<<<< Creating Bootstrap Connection >>>>");
        BootstrapConn bstConn = new BootstrapConn();
        bstConn.initBootstrapConn(true, this._bstConfig.getBootstrapDBUsername(), this._bstConfig.getBootstrapDBPassword(), this._bstConfig.getBootstrapDBHostname(), this._bstConfig.getBootstrapDBName());
        return bstConn;
    }

    private String createQueryString() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT id,val FROM ").append(this._tableName).append(" WHERE id > ?");
        if (null != this._metadataFilters.getMinKey()) {
            sql.append(" AND srckey >= '" + this._metadataFilters.getMinKey() + "'");
        }
        if (null != this._metadataFilters.getMaxKey()) {
            sql.append(" AND srckey <= '" + this._metadataFilters.getMaxKey() + "'");
        }
        if (0L < this._metadataFilters.getMinScn()) {
            sql.append(" AND scn >= " + this._metadataFilters.getMinScn());
        }
        if (0L < this._metadataFilters.getMaxScn()) {
            sql.append(" AND scn <= " + this._metadataFilters.getMaxScn());
        }
        sql.append(" ORDER BY id LIMIT " + this._bstConfig.getBootstrapBatchSize());
        return sql.toString();
    }
}

