/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.utils.bst_reader;

import com.linkedin.databus.bootstrap.common.BootstrapConfig;
import com.linkedin.databus.bootstrap.common.BootstrapReadOnlyConfig;
import com.linkedin.databus.bootstrap.utils.BootstrapDBReader;
import com.linkedin.databus.bootstrap.utils.bst_reader.BootstrapTableReaderV2;
import com.linkedin.databus.bootstrap.utils.bst_reader.MetaDataFilters;
import com.linkedin.databus.bootstrap.utils.bst_reader.MetaDataFiltersBuilder;
import com.linkedin.databus.bootstrap.utils.bst_reader.filter.BootstrapReaderFilter;
import com.linkedin.databus.bootstrap.utils.bst_reader.filter.PayloadFieldEqFilter;
import com.linkedin.databus.bootstrap.utils.bst_reader.filter.PayloadFieldGtFilter;
import com.linkedin.databus.bootstrap.utils.bst_reader.filter.PayloadFieldLtFilter;
import com.linkedin.databus.core.BaseCli;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.schemas.FileSystemVersionedSchemaSetProvider;
import com.linkedin.databus2.schemas.ResourceVersionedSchemaSetProvider;
import com.linkedin.databus2.schemas.VersionedSchemaSet;
import com.linkedin.databus2.schemas.VersionedSchemaSetProvider;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.OptionBuilder;
import org.apache.log4j.Logger;

public class BootstrapReaderV2Main {
    public static final Logger LOG = Logger.getLogger(BootstrapReaderV2Main.class);

    public static void main(String[] args) throws Exception {
        Cli cli = new Cli(null);
        if (!cli.processCommandLineArgs(args)) {
            System.exit(1);
        }
        BootstrapDBReader.DumpEventHandler eventHandler = new BootstrapDBReader.DumpEventHandler();
        for (String table : cli.getTableNames()) {
            LOG.info((Object)("scanning table " + table));
            BootstrapTableReaderV2 reader = new BootstrapTableReaderV2(table, cli.getMetadataFilters(), cli.getSchemaSet(), eventHandler, cli.getEventFilters(), cli.getBstCfg(), null);
            reader.execute();
        }
    }

    public static class Cli
    extends BaseCli {
        private static final int QUERY_BATCH_SIZE = 50;
        public static final String BST_DBNAME_OPT_NAME = "db";
        public static final char BST_DBNAME_OPT_CHAR = 'D';
        public static final String MYSQL_HOST_OPT_NAME = "mysql_host";
        public static final char MYSQL_HOST_OPT_CHAR = 'H';
        public static final String BST_USER_OPT_NAME = "user";
        public static final char BST_USER_OPT_CHAR = 'u';
        public static final String BST_PASSWORD_OPT_NAME = "password";
        public static final char BST_PASSWORD_OPT_CHAR = 'p';
        public static final String WITH_SNAPSHOT_OPT_NAME = "with-snapshot-table";
        public static final char WITH_SNAPSHOT_OPT_CHAR = 'S';
        public static final String WITH_LOG_OPT_NAME = "with-log-tables";
        public static final char WITH_LOG_OPT_CHAR = 'L';
        public static final String SCNS_OPT_NAME = "scns";
        public static final String KEYS_OPT_NAME = "keys";
        public static final String SRCID_OPT_NAME = "srcid";
        public static final String SRCNAME_OPT_NAME = "srcname";
        public static final String SCHEMAS_PATH_OPT_NAME = "schemas_registry";
        public static final String PAYLOAD_COND_OPT_NAME = "payload_matches";
        private static final Pattern PAYLOAD_COND_REGEX = Pattern.compile("(\\w+)(<=|<|>|>=|==|!=|~)(.+)");
        private final BootstrapConfig _bstCfg;
        private short _srcId = (short)-1;
        private final MetaDataFiltersBuilder _metaBuilder = new MetaDataFiltersBuilder();
        private final List<String> _tableNames = new ArrayList<String>();
        private final List<BootstrapReaderFilter> _eventFilters = new ArrayList<BootstrapReaderFilter>();
        private VersionedSchemaSetProvider _schemaSetProvider = new ResourceVersionedSchemaSetProvider(((Object)((Object)this)).getClass().getClassLoader());

        public Cli(Logger log) throws IOException {
            super(Cli.constructCliHelp(), log);
            this._bstCfg = new BootstrapConfig();
            this._bstCfg.setBootstrapBatchSize(50L);
        }

        private static BaseCli.CliHelp constructCliHelp() {
            return new BaseCli.CliHelpBuilder().className(BootstrapReaderV2Main.class).startHeader().addSection("Description").addLine("A simple tool to inspect the contents for MySQL bootstrap database").addSection("Options").finish().startFooter().addSection("Examples").addLine("* Find records in tab_201 with key 12345").addLine().add("java ").add(BootstrapReaderV2Main.class.getName()).addLine("-H example.host.com --with-snaptshot-table --keys 12345,12345 --srcid 201").addLine().addLine("* Find records in tab_201 with key from \"abc\" to \"abd\" and scn <= 1000 (key range works as expected only for true string keys)").addLine().add("java ").add(BootstrapReaderV2Main.class.getName()).addLine("-H example.host.com --with-snaptshot-table --keys abc,abd --scn ,1000 --srcid 201").addLine().addLine("* Find records in tab_201, log_201_100, ..., log_201_200 with key > 123  which are not deleted (works for number keys but requires a full table scan)").addLine().add("java ").add(BootstrapReaderV2Main.class.getName()).addLine("-H example.host.com --with-snaptshot-table --with-log-tables 100,200  --srcid 201 --payload_matches key>123 --payload_matches isDeleted==N").addLine().finish().build();
        }

        protected void constructCommandLineOptions() {
            super.constructCommandLineOptions();
            OptionBuilder.withLongOpt((String)BST_DBNAME_OPT_NAME);
            OptionBuilder.withDescription((String)"bootstrap database name; default is bootstrap");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"db_name");
            this._cliOptions.addOption(OptionBuilder.create((char)'D'));
            OptionBuilder.withLongOpt((String)MYSQL_HOST_OPT_NAME);
            OptionBuilder.withDescription((String)"bootstrap MySQL host; default is localhost");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"host_name");
            this._cliOptions.addOption(OptionBuilder.create((char)'H'));
            OptionBuilder.withLongOpt((String)BST_USER_OPT_NAME);
            OptionBuilder.withDescription((String)"bootstrap user name; default is bootstrap");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"user_name");
            this._cliOptions.addOption(OptionBuilder.create((char)'u'));
            OptionBuilder.withLongOpt((String)BST_PASSWORD_OPT_NAME);
            OptionBuilder.withDescription((String)"bootstrap user password; default is bootstrap");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withArgName((String)BST_PASSWORD_OPT_NAME);
            this._cliOptions.addOption(OptionBuilder.create((char)'p'));
            OptionBuilder.withLongOpt((String)WITH_SNAPSHOT_OPT_NAME);
            OptionBuilder.withDescription((String)"scan snapshot table");
            this._cliOptions.addOption(OptionBuilder.create((char)'S'));
            OptionBuilder.withLongOpt((String)WITH_LOG_OPT_NAME);
            OptionBuilder.withDescription((String)"scan log tables. If min_log_id is not specified, the first available log will be used. if max_log_id is not specified, the last available log table will be used.");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withArgName((String)"[[min_log_id],[max_log_id]]");
            this._cliOptions.addOption(OptionBuilder.create((char)'L'));
            OptionBuilder.withDescription((String)"scn range to return");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"[min_scn],[max_scn]");
            this._cliOptions.addOption(OptionBuilder.create((String)SCNS_OPT_NAME));
            OptionBuilder.withDescription((String)"key range to return");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"[min_key],[max_key]");
            this._cliOptions.addOption(OptionBuilder.create((String)KEYS_OPT_NAME));
            OptionBuilder.withDescription((String)"logical source id to scan; exactly one of --srcid and --srcname should be specified");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)SRCID_OPT_NAME);
            this._cliOptions.addOption(OptionBuilder.create((String)SRCID_OPT_NAME));
            OptionBuilder.withDescription((String)"logical source name to scan; exactly one of --srcid and --srcname should be specified");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"source_name");
            this._cliOptions.addOption(OptionBuilder.create((String)SRCNAME_OPT_NAME));
            OptionBuilder.withDescription((String)"path to the schemas registry with the Avro schemas to use for decoding");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"schemas_path");
            this._cliOptions.addOption(OptionBuilder.create((String)SCHEMAS_PATH_OPT_NAME));
            OptionBuilder.withDescription((String)"payload predicate: <OP> can be <=,<,>,>=,==,!=,~");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"field_name<OP>constant");
            this._cliOptions.addOption(OptionBuilder.create((String)PAYLOAD_COND_OPT_NAME));
        }

        public boolean processCommandLineArgs(String[] cliArgs) {
            if (!super.processCommandLineArgs(cliArgs)) {
                return false;
            }
            if (!this.processBootstrapOptions()) {
                return false;
            }
            if (!this.processTables()) {
                return false;
            }
            if (!this.processMetadataFilters()) {
                return false;
            }
            if (!this.processEventFilters()) {
                return false;
            }
            return this.processSchemasPath();
        }

        private boolean processTables() {
            if (this._cmd.hasOption(SRCID_OPT_NAME)) {
                try {
                    this._srcId = Short.parseShort(this._cmd.getOptionValue(SRCID_OPT_NAME));
                }
                catch (NumberFormatException e) {
                    this.printError("invalid logical source id: " + this._cmd.getOptionValue(SRCID_OPT_NAME), false);
                    return false;
                }
            }
            if (this._cmd.hasOption(SRCNAME_OPT_NAME)) {
                this.printError("option not supported yet: srcname", false);
                return false;
            }
            if (this._srcId <= 0) {
                this.printError("no logical source specified", true);
                return false;
            }
            if (this._cmd.hasOption('S')) {
                this._tableNames.add("tab_" + this._srcId);
            }
            if (this._cmd.hasOption('L')) {
                int minLogId = -1;
                int maxLogId = -1;
                String logOpt = this._cmd.getOptionValue('L');
                if (null != logOpt) {
                    int commaPos = logOpt.indexOf(44);
                    try {
                        if (-1 == commaPos) {
                            maxLogId = minLogId = Integer.parseInt(logOpt);
                        } else {
                            if (commaPos > 0) {
                                minLogId = Integer.parseInt(logOpt.substring(0, commaPos));
                            }
                            if (commaPos < logOpt.length() - 1) {
                                maxLogId = Integer.parseInt(logOpt.substring(commaPos + 1));
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        this.printError("invalid log table number(s): " + logOpt, true);
                        return false;
                    }
                }
                if (0 > minLogId || 0 > maxLogId) {
                    this.printError("log table number wildcards are not supported yet", false);
                    return false;
                }
                for (int lid = minLogId; lid <= maxLogId; ++lid) {
                    this._tableNames.add("log_" + this._srcId + "_" + lid);
                }
            }
            if (0 == this._tableNames.size()) {
                this.printError("At least one of --with-snapshot-table or --with-log-tables is required.", true);
                return false;
            }
            return true;
        }

        private boolean processEventFilters() {
            if (this._cmd.hasOption(PAYLOAD_COND_OPT_NAME)) {
                for (String cond : this._cmd.getOptionValues(PAYLOAD_COND_OPT_NAME)) {
                    if (this.processEventFilter(cond)) continue;
                    return false;
                }
            }
            return true;
        }

        private boolean processEventFilter(String cond) {
            String oper;
            Matcher m = PAYLOAD_COND_REGEX.matcher(cond);
            if (!m.matches()) {
                this.printError("invalid payload predicate: " + cond, true);
                return false;
            }
            String constStr = m.group(3);
            Object constArg = constStr;
            Long constLong = null;
            Double constDouble = null;
            try {
                constLong = Long.parseLong(constStr);
                constArg = constLong;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (null == constLong) {
                try {
                    constDouble = Double.parseDouble(constStr);
                    constArg = constDouble;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if ("<".equals(oper = m.group(2))) {
                PayloadFieldLtFilter f = new PayloadFieldLtFilter(m.group(1), constArg);
                this._eventFilters.add(f);
            } else if (">".equals(oper)) {
                PayloadFieldGtFilter f = new PayloadFieldGtFilter(m.group(1), constArg);
                this._eventFilters.add(f);
            } else if ("==".equals(oper)) {
                PayloadFieldEqFilter f = new PayloadFieldEqFilter(m.group(1), constArg);
                this._eventFilters.add(f);
            } else {
                this.printError("unsupported relationship: " + oper, false);
                return false;
            }
            return true;
        }

        private boolean processMetadataFilters() {
            String[] optParts;
            if (this._cmd.hasOption(KEYS_OPT_NAME)) {
                String keysOpt = this._cmd.getOptionValue(KEYS_OPT_NAME);
                optParts = keysOpt.split(",");
                if (optParts.length > 2) {
                    this.printError("invalid key range specifier:" + keysOpt, true);
                    return false;
                }
                if (optParts[0].length() > 0) {
                    this._metaBuilder.minKey(optParts[0]);
                }
                if (2 == optParts.length && optParts[1].length() > 0) {
                    this._metaBuilder.maxKey(optParts[1]);
                }
            }
            if (this._cmd.hasOption(SCNS_OPT_NAME)) {
                String scnsOpt = this._cmd.getOptionValue(SCNS_OPT_NAME);
                optParts = scnsOpt.split(",");
                if (optParts.length > 2) {
                    this.printError("invalid SCN range specifier:" + scnsOpt, true);
                    return false;
                }
                try {
                    if (optParts[0].length() > 0) {
                        this._metaBuilder.minScn(Long.parseLong(optParts[0]));
                    }
                    if (2 == optParts.length && optParts[1].length() > 0) {
                        this._metaBuilder.maxScn(Long.parseLong(optParts[1]));
                    }
                }
                catch (NumberFormatException e) {
                    this.printError("invalid SCN range specifier:" + scnsOpt, true);
                    return false;
                }
            }
            return true;
        }

        private boolean processBootstrapOptions() {
            if (this._cmd.hasOption('D')) {
                this._bstCfg.setBootstrapDBName(this._cmd.getOptionValue('D'));
            }
            if (this._cmd.hasOption('H')) {
                this._bstCfg.setBootstrapDBHostname(this._cmd.getOptionValue('H'));
            }
            if (this._cmd.hasOption('u')) {
                this._bstCfg.setBootstrapDBUsername(this._cmd.getOptionValue('u'));
            }
            if (this._cmd.hasOption('p')) {
                String pwd = this._cmd.getOptionValue('p');
                if (null == pwd) {
                    Console console = System.console();
                    if (null == console) {
                        this.printError("no password specified", true);
                        return false;
                    }
                    char[] pwdChars = console.readPassword("Enter bootstrap MySQL password:", new Object[0]);
                    if (null == pwdChars) {
                        this.printError("no password specified", true);
                        return false;
                    }
                    pwd = new String(pwdChars);
                }
                this._bstCfg.setBootstrapDBPassword(pwd);
            }
            return true;
        }

        public boolean processSchemasPath() {
            if (this._cmd.hasOption(SCHEMAS_PATH_OPT_NAME)) {
                this._schemaSetProvider = new FileSystemVersionedSchemaSetProvider(new File[]{new File(this._cmd.getOptionValue(SCHEMAS_PATH_OPT_NAME))});
            }
            return true;
        }

        public BootstrapReadOnlyConfig getBstCfg() throws InvalidConfigException {
            return this._bstCfg.build();
        }

        public MetaDataFilters getMetadataFilters() {
            return this._metaBuilder.build();
        }

        public List<String> getTableNames() {
            return Collections.unmodifiableList(this._tableNames);
        }

        public List<BootstrapReaderFilter> getEventFilters() {
            return this._eventFilters;
        }

        public VersionedSchemaSet getSchemaSet() {
            return this._schemaSetProvider.loadSchemas();
        }
    }
}

