/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.utils;

import com.linkedin.databus.bootstrap.common.BootstrapConn;
import com.linkedin.databus.bootstrap.utils.BootstrapDBReader;
import com.linkedin.databus.bootstrap.utils.BootstrapReaderEventHandler;
import com.linkedin.databus.bootstrap.utils.BootstrapSeederMain;
import com.linkedin.databus.client.DbusEventAvroDecoder;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusEventFactory;
import com.linkedin.databus.core.DbusEventInternalReadable;
import com.linkedin.databus.core.DbusEventV1Factory;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.ConfigLoader;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.schemas.FileSystemSchemaRegistryService;
import com.linkedin.databus2.schemas.VersionedSchema;
import com.linkedin.databus2.schemas.VersionedSchemaSet;
import com.linkedin.databus2.util.DBHelper;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;

public class BootstrapTableReader {
    public static final String MODULE = BootstrapDBReader.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String HELP_OPT_LONG_NAME = "help";
    public static final String BOOTSTRAP_DB_PROPS_OPT_LONG_NAME = "bootstrap_db_props";
    public static final String QUERY_CONFIG_OPT_LONG_NAME = "query_config";
    public static final String SOURCE_ID_PARAM = "source_id";
    public static final String LOG4J_PROPS_OPT_LONG_NAME = "log_props";
    public static final char HELP_OPT_CHAR = 'h';
    public static final char BOOTSTRAP_DB_PROP_OPT_CHAR = 'p';
    public static final char QUERY_CONFIG_OPT_CHAR = 'q';
    public static final char LOG4J_PROPS_OPT_CHAR = 'l';
    private static Properties _sBootstrapConfigProps = null;
    private static Properties _sQueryConfigProps = null;
    private static BootstrapSeederMain.StaticConfig _bsStaticConfig;
    private static StaticConfig _queryStaticConfig;
    private static DbusEventAvroDecoder _decoder;
    private static Schema _schema;
    private final DbusEventFactory _eventFactory = new DbusEventV1Factory();
    private BootstrapReaderEventHandler _eventHandler;
    private BootstrapConn _bootstrapConn = null;

    public BootstrapTableReader(BootstrapReaderEventHandler eventHandler) {
        this._eventHandler = eventHandler;
    }

    private String getTableName() {
        String table = null;
        table = _queryStaticConfig.getTablePrefix().equalsIgnoreCase("tab_") ? "tab_" + _queryStaticConfig.getSourceId() : "log_" + _queryStaticConfig.getSourceId() + "_" + _queryStaticConfig.getLogId();
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        String query = this.getQuery();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            stmt = conn.createStatement();
            LOG.info((Object)("Executing query : " + query));
            rs = stmt.executeQuery(query);
            byte[] b1 = new byte[0x100000];
            ByteBuffer buffer = ByteBuffer.wrap(b1);
            DbusEventInternalReadable event = this._eventFactory.createReadOnlyDbusEventFromBuffer(buffer, 0);
            int count = 0;
            this._eventHandler.onStart(query);
            while (rs.next()) {
                buffer.clear();
                buffer.put(rs.getBytes("val"));
                event = event.reset(buffer, 0);
                GenericRecord record = _decoder.getGenericRecord((DbusEvent)event);
                this._eventHandler.onRecord((DbusEvent)event, record);
                ++count;
            }
            this._eventHandler.onEnd(count);
        }
        catch (Throwable throwable) {
            DBHelper.close(rs, (Statement)stmt, (Connection)conn);
            throw throwable;
        }
        DBHelper.close((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    public Connection getConnection() {
        Connection conn = null;
        if (this._bootstrapConn == null) {
            LOG.info((Object)"<<<< Creating Bootstrap Connection!! >>>>");
            this._bootstrapConn = new BootstrapConn();
            try {
                this._bootstrapConn.initBootstrapConn(false, _bsStaticConfig.getBootstrap().getBootstrapDBUsername(), _bsStaticConfig.getBootstrap().getBootstrapDBPassword(), _bsStaticConfig.getBootstrap().getBootstrapDBHostname(), _bsStaticConfig.getBootstrap().getBootstrapDBName());
            }
            catch (Exception e) {
                LOG.fatal((Object)"Unable to open BootstrapDB Connection !!", (Throwable)e);
                throw new RuntimeException("Got exception when getting bootstrap DB Connection.", e);
            }
        }
        try {
            conn = this._bootstrapConn.getDBConn();
        }
        catch (SQLException e) {
            LOG.fatal((Object)"Not able to open BootstrapDB Connection !!", (Throwable)e);
            throw new RuntimeException("Got exception when getting bootstrap DB Connection.", e);
        }
        return conn;
    }

    public String getQuery() {
        String table = this.getTableName();
        StringBuilder sql = new StringBuilder();
        sql.append("select val from ").append(table).append(" where ").append(_queryStaticConfig.getQueryKey());
        if (_queryStaticConfig.isRangeQuery()) {
            sql.append(" >= ").append(_queryStaticConfig.getMinKey()).append(" and ").append(_queryStaticConfig.getQueryKey()).append(" <= ").append(_queryStaticConfig.getMaxKey());
        } else {
            sql.append(" = ").append(_queryStaticConfig.getValue());
        }
        return sql.toString();
    }

    public static void init(String[] args) throws Exception {
        BootstrapTableReader.parseArgs(args);
        BootstrapSeederMain.Config bsConf = new BootstrapSeederMain.Config();
        ConfigLoader configLoader = new ConfigLoader("databus.reader.", (ConfigBuilder)bsConf);
        _bsStaticConfig = (BootstrapSeederMain.StaticConfig)configLoader.loadConfig((Map)_sBootstrapConfigProps);
        Config qConf = new Config();
        ConfigLoader configLoader2 = new ConfigLoader("databus.query.", (ConfigBuilder)qConf);
        _queryStaticConfig = (StaticConfig)configLoader2.loadConfig((Map)_sQueryConfigProps);
        FileSystemSchemaRegistryService schemaRegistry = FileSystemSchemaRegistryService.build((FileSystemSchemaRegistryService.StaticConfig)_bsStaticConfig.getSchemaRegistry().getFileSystem());
        LOG.info((Object)("Schema = " + schemaRegistry.fetchLatestSchemaBySourceName(_queryStaticConfig.getSourceName())));
        _schema = Schema.parse((String)schemaRegistry.fetchLatestSchemaBySourceName(_queryStaticConfig.getSourceName()));
        VersionedSchema vs = new VersionedSchema(_schema.getFullName(), 1, _schema, null);
        VersionedSchemaSet schemaSet = new VersionedSchemaSet();
        schemaSet.add(vs);
        _decoder = new DbusEventAvroDecoder(schemaSet);
    }

    public static Schema getSchema() {
        return _schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseArgs(String[] args) throws IOException {
        GnuParser cliParser = new GnuParser();
        OptionBuilder.withLongOpt((String)HELP_OPT_LONG_NAME);
        OptionBuilder.withDescription((String)"Help screen");
        Option helpOption = OptionBuilder.create((char)'h');
        OptionBuilder.withLongOpt((String)QUERY_CONFIG_OPT_LONG_NAME);
        OptionBuilder.withDescription((String)"Query Config");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"property_file");
        Option sourcesOption = OptionBuilder.create((char)'q');
        OptionBuilder.withLongOpt((String)BOOTSTRAP_DB_PROPS_OPT_LONG_NAME);
        OptionBuilder.withDescription((String)"Bootstrap DB properties to use");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"property_file");
        Option dbOption = OptionBuilder.create((char)'p');
        OptionBuilder.withLongOpt((String)LOG4J_PROPS_OPT_LONG_NAME);
        OptionBuilder.withDescription((String)"Log4j properties to use");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"property_file");
        Option log4jPropsOption = OptionBuilder.create((char)'l');
        Options options = new Options();
        options.addOption(helpOption);
        options.addOption(sourcesOption);
        options.addOption(dbOption);
        options.addOption(log4jPropsOption);
        CommandLine cmd = null;
        try {
            cmd = cliParser.parse(options, args);
        }
        catch (ParseException pe) {
            LOG.fatal((Object)"Bootstrap Physical Config: failed to parse command-line options.", (Throwable)pe);
            throw new RuntimeException("Bootstrap Physical Config: failed to parse command-line options.", pe);
        }
        if (cmd.hasOption('l')) {
            String log4jPropFile = cmd.getOptionValue('l');
            PropertyConfigurator.configure((String)log4jPropFile);
            LOG.info((Object)("Using custom logging settings from file " + log4jPropFile));
        } else {
            PatternLayout defaultLayout = new PatternLayout("%d{ISO8601} +%r [%t] (%p) {%c} %m%n");
            ConsoleAppender defaultAppender = new ConsoleAppender((Layout)defaultLayout);
            Logger.getRootLogger().removeAllAppenders();
            Logger.getRootLogger().addAppender((Appender)defaultAppender);
            LOG.info((Object)"Using default logging settings");
        }
        if (cmd.hasOption('h')) {
            BootstrapTableReader.printCliHelp(options);
            System.exit(0);
        }
        if (!cmd.hasOption('q')) {
            throw new RuntimeException("Query Config is not provided; use --help for usage");
        }
        if (!cmd.hasOption('p')) {
            throw new RuntimeException("Bootstrap config is not provided; use --help for usage");
        }
        String propFile1 = cmd.getOptionValue('q');
        String propFile2 = cmd.getOptionValue('p');
        LOG.info((Object)("Loading bootstrap DB config from properties file " + propFile2));
        _sQueryConfigProps = new Properties();
        FileInputStream f1 = new FileInputStream(propFile1);
        try {
            _sQueryConfigProps.load(f1);
        }
        finally {
            f1.close();
        }
        _sBootstrapConfigProps = new Properties();
        FileInputStream f2 = new FileInputStream(propFile2);
        try {
            _sBootstrapConfigProps.load(f2);
        }
        finally {
            f2.close();
        }
    }

    private static void printCliHelp(Options cliOptions) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("java " + BootstrapSeederMain.class.getName(), cliOptions);
    }

    public static class Config
    implements ConfigBuilder<StaticConfig> {
        private Integer sourceId;
        private String sourceName;
        private String tablePrefix;
        private String field;
        private boolean isRangeQuery;
        private Long value;
        private Long minValue;
        private Long maxValue;
        private Long logId;

        public Long getLogId() {
            return this.logId;
        }

        public void setLogId(Long logId) {
            this.logId = logId;
        }

        public String getSourceName() {
            return this.sourceName;
        }

        public void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        public Integer getSourceId() {
            return this.sourceId;
        }

        public void setSourceId(Integer sourceId) {
            this.sourceId = sourceId;
        }

        public String getTablePrefix() {
            return this.tablePrefix;
        }

        public void setTablePrefix(String tablePrefix) {
            this.tablePrefix = tablePrefix;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String queryKey) {
            this.field = queryKey;
        }

        public boolean isRangeQuery() {
            return this.isRangeQuery;
        }

        public void setRangeQuery(boolean isRangeQuery) {
            this.isRangeQuery = isRangeQuery;
        }

        public Long getValue() {
            return this.value;
        }

        public void setValue(Long value) {
            this.value = value;
        }

        public Long getMinValue() {
            return this.minValue;
        }

        public void setMinValue(Long minKey) {
            this.minValue = minKey;
        }

        public Long getMaxValue() {
            return this.maxValue;
        }

        public void setMaxValue(Long maxKey) {
            this.maxValue = maxKey;
        }

        public StaticConfig build() throws InvalidConfigException {
            return new StaticConfig(this.sourceId, this.sourceName, this.tablePrefix, this.field, this.isRangeQuery, this.value, this.minValue, this.maxValue, this.logId);
        }
    }

    public static class StaticConfig {
        private final Integer sourceId;
        private final String sourceName;
        private final String tablePrefix;
        private final String queryKey;
        private final boolean isRangeQuery;
        private final Long value;
        private final Long minKey;
        private final Long maxKey;
        private final Long logId;

        public Long getLogId() {
            return this.logId;
        }

        public Integer getSourceId() {
            return this.sourceId;
        }

        public String getSourceName() {
            return this.sourceName;
        }

        public String getTablePrefix() {
            return this.tablePrefix;
        }

        public String getQueryKey() {
            return this.queryKey;
        }

        public boolean isRangeQuery() {
            return this.isRangeQuery;
        }

        public Long getValue() {
            return this.value;
        }

        public Long getMinKey() {
            return this.minKey;
        }

        public Long getMaxKey() {
            return this.maxKey;
        }

        public StaticConfig(Integer sourceId, String sourceName, String tablePrefix, String queryKey, boolean isRangeQuery, Long value, Long minKey, Long maxKey, Long logId) {
            this.sourceId = sourceId;
            this.sourceName = sourceName;
            this.tablePrefix = tablePrefix;
            this.queryKey = queryKey;
            this.isRangeQuery = isRangeQuery;
            this.value = value;
            this.minKey = minKey;
            this.maxKey = maxKey;
            this.logId = logId;
        }

        public String toString() {
            return "StaticConfig [sourceId=" + this.sourceId + ", sourceName=" + this.sourceName + ", tablePrefix=" + this.tablePrefix + ", queryKey=" + this.queryKey + ", isRangeQuery=" + this.isRangeQuery + ", value=" + this.value + ", minKey=" + this.minKey + ", maxKey=" + this.maxKey + "]";
        }
    }
}

