/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.utils;

import com.linkedin.databus.bootstrap.utils.BootstrapEventBuffer;
import com.linkedin.databus.core.DbusEventBufferAppendable;
import com.linkedin.databus.core.DbusEventKey;
import com.linkedin.databus.core.UnsupportedKeyException;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollector;
import com.linkedin.databus2.producers.EventCreationException;
import com.linkedin.databus2.producers.PartitionFunction;
import com.linkedin.databus2.producers.db.OracleAvroGenericEventFactory;
import com.linkedin.databus2.relay.config.ReplicationBitSetterStaticConfig;
import com.linkedin.databus2.schemas.utils.SchemaHelper;
import java.sql.ResultSet;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.log4j.Logger;

public class BootstrapSeederOracleAvroGenericEventFactory
extends OracleAvroGenericEventFactory {
    private final Logger _log = Logger.getLogger(((Object)((Object)this)).getClass());
    private String _seederChunkKeyName = null;

    public BootstrapSeederOracleAvroGenericEventFactory(short sourceId, short pSourceId, String eventSchema, PartitionFunction partitionFunction, String seederChunkKeyColumnName, ReplicationBitSetterStaticConfig replSetterConfig) throws EventCreationException, UnsupportedKeyException {
        super(sourceId, pSourceId, eventSchema, partitionFunction, replSetterConfig);
        List fields = this._eventSchema.getFields();
        Object avroFieldName = null;
        for (Schema.Field f : fields) {
            String databaseFieldName = SchemaHelper.getMetaField((Schema.Field)f, (String)"dbFieldName");
            if (null == databaseFieldName || !databaseFieldName.equalsIgnoreCase(seederChunkKeyColumnName)) continue;
            this._seederChunkKeyName = f.name();
            break;
        }
        this._log.info((Object)("SeederChunkKey Field is :" + this._seederChunkKeyName));
    }

    public long createAndAppendEvent(long scn, long timestamp, GenericRecord record, ResultSet row, DbusEventBufferAppendable eventBuffer, boolean enableTracing, boolean isReplicated, DbusEventsStatisticsCollector dbusEventsStatisticsCollector) throws EventCreationException, UnsupportedKeyException {
        if (!(eventBuffer instanceof BootstrapEventBuffer)) {
            throw new RuntimeException("Expected BootstrapEventBuffer instance to be passed but received:" + eventBuffer);
        }
        BootstrapEventBuffer bEvb = (BootstrapEventBuffer)eventBuffer;
        byte[] serializedValue = this.serializeEvent(record, scn, timestamp, row, eventBuffer, enableTracing, dbusEventsStatisticsCollector);
        DbusEventKey eventKey = new DbusEventKey(record.get(this.keyColumnName));
        DbusEventKey seederChunkKey = new DbusEventKey(record.get(this._seederChunkKeyName));
        short lPartitionId = this._partitionFunction.getPartition(eventKey);
        bEvb.appendEvent(eventKey, seederChunkKey, this._pSourceId, lPartitionId, timestamp * 1000000L, this._sourceId, this._schemaId, serializedValue, enableTracing, isReplicated, dbusEventsStatisticsCollector);
        return serializedValue.length;
    }
}

