/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.utils;

import com.linkedin.databus.bootstrap.common.BootstrapConn;
import com.linkedin.databus.bootstrap.common.BootstrapDBMetaDataDAO;
import com.linkedin.databus2.util.DBHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class BootstrapMetadata {
    public static final String DEFAULT_BOOTSTRAP_HOST = "localhost";
    public static final String DEFAULT_BOOTSTRAP_DATABASE = "bootstrap";
    public static final String DEFAULT_BOOTSTRAP_USER = "bootstrap";
    public static final String DEFAULT_BOOTSTRAP_PASSWORD = "bootstrap";
    public static final String DEFAULT_MINSCN_TYPE = "catchup-purged";
    private static BootstrapConn _bsConn = null;
    private static BootstrapDBMetaDataDAO _dbao = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int exitStatus = 0;
        GnuParser cmdLineParser = new GnuParser();
        Options options = new Options();
        options.addOption("d", "dbname", true, "database name : [bootstrap]").addOption("s", "dbhost", true, "database hostname: [localhost]").addOption("p", "dbpassword", true, "database password: [bootstrap]").addOption("u", "dbuser", true, "database user: [bootstrap] ").addOption("S", "sources", true, " <srcid,..>|<srcName substring,..,>  [all]").addOption("m", "minScnType", true, "type of minScn algorithm: [catchup-forever] catchup-forever|catchup-purged|snapshot. 'snapshot':        use when snapshot table has been purged and the size of snapshot is not large.Times-out in 5 minutes if query cannot complete. 'catchup-purged':  use when snapshot table has been purged and a conservative value of minScn is acceptable or when 'snapshot' isn't feasible. 'catchup-forever': use when snapshot table has *never* been purged . Note: If a source has been seeded, regardless of the minScnType, the value returned is 0.").addOption("h", "help", false, "help");
        String[] functionNames = new String[]{"getSources", "get sourceName, sourceId, sourceStatus from bootstrap db", "createMinScnTable", "create metadata required for minScn feature in bootstrap db if none exists", "createAllTables", "create all metadata in bootstrap db if they don't exist", "getMinScn", "[--sources <>] return minScn as seen by bootstrap service for specified sources", "computeMinScn", "[--sources <>] [--minScnType <>] return minScn using one of the algorithms specified. INIT could mean failure to find a minSCN ", "computeAndSetMinScn", "[--sources <>] [--minScnType<>] set minScn using one of the algorithms specified. ", "setMinScn", "[--sources <>] INFINITY|INIT|<scn> set minScn to a desired value. "};
        try {
            String arg1;
            String[] fns;
            CommandLine cmdLineArgs = cmdLineParser.parse(options, args, false);
            if (cmdLineArgs.hasOption('h')) {
                BootstrapMetadata.usage(options, functionNames);
                System.exit(0);
            }
            if ((fns = cmdLineArgs.getArgs()).length < 1) {
                BootstrapMetadata.usage(options, functionNames);
                throw new Exception("Missing argument");
            }
            String function = fns[0];
            String string = arg1 = fns.length > 1 ? fns[1] : null;
            if (!BootstrapMetadata.legitFunction(functionNames, function)) {
                BootstrapMetadata.usage(options, functionNames);
                throw new Exception("Unknown function");
            }
            String bootstrapHost = cmdLineArgs.getOptionValue("dbhost", DEFAULT_BOOTSTRAP_HOST);
            String bootstrapDbName = cmdLineArgs.getOptionValue("dbname", "bootstrap");
            String bootstrapPassword = cmdLineArgs.getOptionValue("dbpassword", "bootstrap");
            String bootstrapUser = cmdLineArgs.getOptionValue("dbuser", "bootstrap");
            _bsConn = new BootstrapConn();
            _bsConn.initBootstrapConn(false, bootstrapUser, bootstrapPassword, bootstrapHost, bootstrapDbName);
            _dbao = new BootstrapDBMetaDataDAO(_bsConn, bootstrapHost, bootstrapUser, bootstrapPassword, bootstrapDbName, false);
            String minScnType = cmdLineArgs.getOptionValue("minScnType", DEFAULT_MINSCN_TYPE);
            if (function.equals("createMinScnTable")) {
                BootstrapMetadata.createBootstrapMinScn();
                return;
            }
            if (function.equals("createAllTables")) {
                _dbao.setupDB();
                return;
            }
            List<BootstrapDBMetaDataDAO.SourceStatusInfo> sourceInfoList = _dbao.getSrcStatusInfoFromDB();
            if (function.equalsIgnoreCase("getSources")) {
                for (BootstrapDBMetaDataDAO.SourceStatusInfo s : sourceInfoList) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(s.getSrcName()).append('\t').append(s.getSrcId()).append('\t').append(s.getStatus());
                    System.out.println(sb.toString());
                }
            } else {
                List<BootstrapDBMetaDataDAO.SourceStatusInfo> finalSrcIdList;
                String mySources = cmdLineArgs.getOptionValue("sources");
                String[] mySrcList = null;
                if (mySources != null) {
                    mySrcList = mySources.split(",");
                }
                List<BootstrapDBMetaDataDAO.SourceStatusInfo> list = finalSrcIdList = mySrcList != null ? BootstrapMetadata.getFinalSrcIdList(sourceInfoList, mySrcList) : sourceInfoList;
                if (function.equalsIgnoreCase("getMinScn")) {
                    BootstrapMetadata.createBootstrapMinScn();
                    for (BootstrapDBMetaDataDAO.SourceStatusInfo sInfo : finalSrcIdList) {
                        long minScn = _dbao.getMinScnOfSnapshots(new int[]{sInfo.getSrcId()});
                        DBHelper.commit((Connection)_bsConn.getDBConn());
                        if (minScn == Long.MIN_VALUE) {
                            System.err.println("Error: Cannot get minScn for " + sInfo.getSrcId());
                            continue;
                        }
                        BootstrapMetadata.printScn(minScn, sInfo, '\t');
                    }
                } else if (function.equalsIgnoreCase("computeMinScn")) {
                    for (BootstrapDBMetaDataDAO.SourceStatusInfo sInfo : finalSrcIdList) {
                        long minScn = BootstrapMetadata.computeMinScn(minScnType, sInfo.getSrcId());
                        DBHelper.commit((Connection)_bsConn.getDBConn());
                        if (minScn == Long.MIN_VALUE) {
                            System.err.println("Error: Cannot get minScn for " + sInfo.getSrcId());
                            continue;
                        }
                        BootstrapMetadata.printScn(minScn, sInfo, '\t');
                    }
                } else if (function.equalsIgnoreCase("setMinScn")) {
                    if (arg1 == null) {
                        throw new Exception("Missing argument for setMinScn: <scn>, INFINITY or INIT");
                    }
                    BootstrapMetadata.createBootstrapMinScn();
                    long scn = arg1.equalsIgnoreCase("INFINITY") ? Long.MAX_VALUE : (arg1.equalsIgnoreCase("INIT") ? -1L : Long.parseLong(arg1));
                    for (BootstrapDBMetaDataDAO.SourceStatusInfo sInfo : finalSrcIdList) {
                        _dbao.updateMinScnOfSnapshot(sInfo.getSrcId(), scn);
                    }
                } else if (function.equalsIgnoreCase("computeAndSetMinScn")) {
                    BootstrapMetadata.createBootstrapMinScn();
                    for (BootstrapDBMetaDataDAO.SourceStatusInfo sInfo : finalSrcIdList) {
                        long minScn = BootstrapMetadata.computeMinScn(minScnType, sInfo.getSrcId());
                        if (minScn != Long.MIN_VALUE) {
                            _dbao.updateMinScnOfSnapshot(sInfo.getSrcId(), minScn);
                        }
                        DBHelper.commit((Connection)_bsConn.getDBConn());
                    }
                }
            }
        }
        catch (ParseException e) {
            BootstrapMetadata.usage(options, functionNames);
            exitStatus = 1;
        }
        catch (Exception e) {
            System.err.println("Error: " + e);
            exitStatus = 1;
        }
        finally {
            if (_dbao != null) {
                _dbao.close();
            }
            System.exit(exitStatus);
        }
    }

    private static boolean legitFunction(String[] functionNames, String fn) {
        for (String f : functionNames) {
            if (!fn.equalsIgnoreCase(f)) continue;
            return true;
        }
        return false;
    }

    private static void printScn(long scn, BootstrapDBMetaDataDAO.SourceStatusInfo s, char delim) {
        StringBuilder sb = new StringBuilder();
        if (scn == Long.MAX_VALUE) {
            sb.append("INFINITY");
        } else if (scn == -1L) {
            sb.append("INIT");
        } else {
            sb.append(scn);
        }
        sb.append(delim).append(s.getSrcId()).append(delim).append(s.getSrcName());
        System.out.println(sb.toString());
    }

    private static long computeMinScn(String minScnType, int sourceId) {
        long minScn = Long.MIN_VALUE;
        try {
            if (_dbao.isSeeded(sourceId)) {
                return 0L;
            }
            if (minScnType.equalsIgnoreCase("snapshot")) {
                minScn = _dbao.getMinWindowScnFromSnapshot(sourceId, Integer.MAX_VALUE, 300);
            } else if (minScnType.equalsIgnoreCase("catchup-forever")) {
                minScn = _dbao.getMinScnFromLogTable(sourceId, false);
            } else if (minScnType.equalsIgnoreCase(DEFAULT_MINSCN_TYPE)) {
                minScn = _dbao.getMinScnFromLogTable(sourceId, true);
            } else {
                System.err.println("Error: unknown minScnType: " + minScnType);
            }
        }
        catch (SQLException e) {
            System.err.println("Error in computeMinScn" + e);
        }
        return minScn;
    }

    private static List<BootstrapDBMetaDataDAO.SourceStatusInfo> getFinalSrcIdList(List<BootstrapDBMetaDataDAO.SourceStatusInfo> sourceInfoList, String[] mySrcList) {
        ArrayList<BootstrapDBMetaDataDAO.SourceStatusInfo> srcList = new ArrayList<BootstrapDBMetaDataDAO.SourceStatusInfo>();
        for (String mysrc : mySrcList) {
            int srcid = -1;
            try {
                srcid = Integer.parseInt(mysrc);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            for (BootstrapDBMetaDataDAO.SourceStatusInfo s : sourceInfoList) {
                if (s.getSrcId() != srcid && (srcid >= 0 || !s.getSrcName().contains(mysrc))) continue;
                srcList.add(s);
            }
        }
        return srcList;
    }

    static void createBootstrapMinScn() throws SQLException {
        if (!_dbao.doesMinScnTableExist()) {
            _dbao.setupMinScnTable();
        }
    }

    public static void usage(Options options, String[] functionNames) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("java " + BootstrapMetadata.class.getName(), options);
        System.out.println("");
        for (int i = 0; i < functionNames.length; i += 2) {
            String s = String.format("%-25s%s", functionNames[i], functionNames[i + 1]);
            System.out.println(s);
        }
    }
}

