/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.utils;

import com.linkedin.databus.bootstrap.utils.BootstrapSeederMain;
import com.linkedin.databus.client.DbusEventAvroDecoder;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusEventInternalReadable;
import com.linkedin.databus.core.DbusEventV1Factory;
import com.linkedin.databus2.producers.EventCreationException;
import com.linkedin.databus2.producers.db.OracleAvroGenericEventFactory;
import com.linkedin.databus2.relay.OracleJarUtils;
import com.linkedin.databus2.schemas.utils.SchemaHelper;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Timestamp;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.log4j.Logger;

public class BootstrapAuditTester {
    public static final String MODULE = BootstrapAuditTester.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final boolean _sDebug = LOG.isDebugEnabled();
    private Schema _schema;
    private final String _tableName;
    private final ByteBuffer _buffer;
    private DbusEventInternalReadable _event;

    public BootstrapAuditTester(Schema schema, String tableName) {
        this._schema = schema;
        this._tableName = tableName;
        byte[] b = new byte[0x100000];
        this._buffer = ByteBuffer.wrap(b);
        DbusEventV1Factory eventFactory = new DbusEventV1Factory();
        this._event = eventFactory.createReadOnlyDbusEventFromBuffer(this._buffer, 0);
    }

    private boolean compareField(Schema.Field f, Object databaseFieldValue, Object avroField) {
        if (databaseFieldValue == avroField) {
            return true;
        }
        if (databaseFieldValue == null) {
            LOG.error((Object)("compareField error:  field=" + f.name() + " null databaseFieldValue but non-null avroField "));
            return false;
        }
        if (avroField == null) {
            LOG.error((Object)("compareField error:  field=" + f.name() + " non-null databaseFieldValue but null avroField "));
            return false;
        }
        try {
            Schema fieldSchema = SchemaHelper.unwindUnionSchema((Schema.Field)f);
            Schema.Type avroFieldType = fieldSchema.getType();
            if (_sDebug) {
                LOG.debug((Object)("Checking for type:" + avroFieldType + ", Field:" + f.name() + ", Exp:" + databaseFieldValue + ", Got:" + avroField));
            }
            switch (avroFieldType) {
                case BOOLEAN: {
                    BootstrapAuditTester.assertEquals(f.name(), databaseFieldValue, avroField);
                    break;
                }
                case BYTES: {
                    byte[] byteArr = null;
                    if (databaseFieldValue instanceof Blob) {
                        Blob b = (Blob)databaseFieldValue;
                        byteArr = b.getBytes(1L, (int)b.length());
                    } else {
                        byteArr = (byte[])databaseFieldValue;
                    }
                    BootstrapAuditTester.assertEquals(f.name(), byteArr, avroField);
                    break;
                }
                case DOUBLE: {
                    BootstrapAuditTester.assertEquals(f.name(), new Double(((Number)databaseFieldValue).doubleValue()), avroField);
                    break;
                }
                case FLOAT: {
                    BootstrapAuditTester.assertEquals(f.name(), new Float(((Number)databaseFieldValue).floatValue()), avroField);
                    break;
                }
                case INT: {
                    BootstrapAuditTester.assertEquals(f.name(), ((Number)databaseFieldValue).intValue(), avroField);
                    break;
                }
                case LONG: {
                    if (databaseFieldValue instanceof Number) {
                        long lvalue = ((Number)databaseFieldValue).longValue();
                        BootstrapAuditTester.assertEquals(f.name(), lvalue, (long)((Long)avroField));
                        break;
                    }
                    if (databaseFieldValue instanceof Timestamp) {
                        long time = ((Timestamp)databaseFieldValue).getTime();
                        BootstrapAuditTester.assertEquals(f.name(), time, (long)((Long)avroField));
                        break;
                    }
                    if (databaseFieldValue instanceof Date) {
                        long time = ((Date)databaseFieldValue).getTime();
                        BootstrapAuditTester.assertEquals(f.name(), time, (long)((Long)avroField));
                        break;
                    }
                    Class timestampClass = null;
                    Class dateClass = null;
                    try {
                        timestampClass = OracleJarUtils.loadClass((String)"oracle.sql.TIMESTAMP");
                        dateClass = OracleJarUtils.loadClass((String)"oracle.sql.DATE");
                    }
                    catch (Exception e) {
                        String errMsg = "Cannot convert " + databaseFieldValue.getClass() + " to long. Unable to get Oracle datatypes " + e.getMessage();
                        LOG.error((Object)errMsg);
                        throw new EventCreationException(errMsg);
                    }
                    if (timestampClass.isInstance(databaseFieldValue)) {
                        try {
                            Object tsc = timestampClass.cast(databaseFieldValue);
                            Method dateValueMethod = timestampClass.getMethod("dateValue", new Class[0]);
                            Date dateValue = (Date)dateValueMethod.invoke(tsc, new Object[0]);
                            long time = dateValue.getTime();
                            BootstrapAuditTester.assertEquals(f.name(), time, (long)((Long)avroField));
                            break;
                        }
                        catch (Exception ex) {
                            String errMsg = "SQLException reading oracle.sql.TIMESTAMP value for field " + f.name();
                            LOG.error((Object)errMsg);
                            throw new RuntimeException(errMsg, ex);
                        }
                    }
                    if (dateClass.isInstance(databaseFieldValue)) {
                        try {
                            Object dsc = dateClass.cast(databaseFieldValue);
                            Method dateValueMethod = dateClass.getMethod("dateValue", new Class[0]);
                            Date dateValue = (Date)dateValueMethod.invoke(dsc, new Object[0]);
                            long time = dateValue.getTime();
                            BootstrapAuditTester.assertEquals(f.name(), time, (long)((Long)avroField));
                            break;
                        }
                        catch (Exception ex) {
                            String errMsg = "SQLException reading oracle.sql.DATE value for field " + f.name();
                            LOG.error((Object)errMsg);
                            throw new RuntimeException(errMsg, ex);
                        }
                    }
                    String errMsg = "Cannot convert " + databaseFieldValue.getClass() + " to long for field " + f.name();
                    LOG.error((Object)errMsg);
                    throw new RuntimeException();
                }
                case STRING: {
                    if (databaseFieldValue instanceof Clob) {
                        String text = null;
                        try {
                            text = OracleAvroGenericEventFactory.extractClobText((Clob)((Clob)databaseFieldValue), (String)f.name());
                        }
                        catch (EventCreationException ex) {
                            LOG.error((Object)("compareField error: " + ex.getMessage()), (Throwable)ex);
                        }
                        BootstrapAuditTester.assertEquals(f.name(), text, ((Utf8)avroField).toString());
                        break;
                    }
                    String text = databaseFieldValue.toString();
                    BootstrapAuditTester.assertEquals(f.name(), text, ((Utf8)avroField).toString());
                    break;
                }
                case NULL: {
                    BootstrapAuditTester.assertNull(f.name(), databaseFieldValue);
                    BootstrapAuditTester.assertNull(f.name(), avroField);
                    break;
                }
                case ARRAY: {
                    GenericArray avroArray = (GenericArray)avroField;
                    Schema elementSchema = fieldSchema.getElementType();
                    Array array = (Array)databaseFieldValue;
                    ResultSet arrayResultSet = array.getResultSet();
                    int i = 0;
                    while (arrayResultSet.next()) {
                        Struct struct = (Struct)arrayResultSet.getObject(2);
                        Object[] attributes = struct.getAttributes();
                        GenericRecord avroElement = (GenericRecord)avroArray.get(i++);
                        for (Schema.Field field : elementSchema.getFields()) {
                            int dbFieldPosition = Integer.valueOf(SchemaHelper.getMetaField((Schema.Field)field, (String)"dbFieldPosition"));
                            Object dbFieldValue = attributes[dbFieldPosition];
                            Object avroFieldValue = avroElement.get(field.name());
                            this.compareField(field, dbFieldValue, avroFieldValue);
                        }
                    }
                    break;
                }
                case RECORD: {
                    assert (this.compareRecord(fieldSchema, (Struct)databaseFieldValue, (GenericRecord)avroField)) : "comparison of Avro 'record' type failed";
                    break;
                }
                default: {
                    String msg = "Audit for these fields not yet implemented for: " + fieldSchema.getName() + ", Avro type: " + avroFieldType;
                    LOG.error((Object)msg);
                    throw new RuntimeException(msg);
                }
            }
        }
        catch (AssertionError err) {
            LOG.error((Object)("compareField error: " + ((Throwable)((Object)err)).getMessage() + " field= " + f.name()));
            return false;
        }
        catch (ClassCastException ce) {
            LOG.error((Object)("compareField error: " + ce.getMessage() + " field=" + f.name()), (Throwable)ce);
            return false;
        }
        catch (Exception ex) {
            LOG.error((Object)("compareField error: " + ex.getMessage() + " field=" + f.name()), (Throwable)ex);
            return false;
        }
        return true;
    }

    static void assertTrue(String msg, boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)msg);
        }
    }

    static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError();
        }
    }

    static void assertNotNull(Object ptr) {
        if (null == ptr) {
            throw new AssertionError((Object)"!= null expected");
        }
    }

    static void assertNull(Object ptr) {
        BootstrapAuditTester.assertNull("", ptr);
    }

    static void assertNull(String msg, Object ptr) {
        if (null == msg) {
            msg = "";
        }
        if (null != ptr) {
            throw new AssertionError((Object)(msg + ": == null expected"));
        }
    }

    static void assertEquals(Object expected, Object found) {
        BootstrapAuditTester.assertEquals("", expected, found);
    }

    static void assertEquals(String msg, Object expected, Object found) {
        if (null == msg) {
            msg = "";
        }
        if (null == expected) {
            if (null != found) {
                throw new AssertionError((Object)(msg + ": expected: null; found: " + found));
            }
        } else {
            if (null == found) {
                throw new AssertionError((Object)(msg + " expected: " + expected + "; found: null"));
            }
            if (!expected.equals(found)) {
                throw new AssertionError((Object)(msg + " expected: " + expected + "; found: " + found));
            }
        }
    }

    public boolean compareRecord(Schema schema, Struct oracleRecord, GenericRecord avroRecord) throws SQLException {
        List fields = schema.getFields();
        Object[] structAttribs = oracleRecord.getAttributes();
        if (structAttribs.length != fields.size() || fields.size() == 0) {
            LOG.error((Object)("Num fields do not match: " + structAttribs.length + " : " + fields.size()));
            return false;
        }
        for (Schema.Field avroField : fields) {
            String dbFieldPositionStr = SchemaHelper.getMetaField((Schema.Field)avroField, (String)"dbFieldPosition");
            int dbFieldPosition = 0;
            if (null == dbFieldPositionStr || dbFieldPositionStr.isEmpty()) {
                LOG.error((Object)("Could not find dbFieldPosition for " + avroField.name()));
                return false;
            }
            dbFieldPosition = Integer.valueOf(dbFieldPositionStr) + 3;
            Object expObj = structAttribs[dbFieldPosition];
            Object gotObj = avroRecord.get(avroField.name());
            if (_sDebug) {
                LOG.debug((Object)("Key:" + avroField.name() + ",Got Object:" + gotObj));
            }
            if (this.compareField(avroField, expObj, gotObj)) continue;
            return false;
        }
        return true;
    }

    public boolean compareRecord(Schema schema, ResultSet oracleRecord, GenericRecord avroRecord) throws SQLException {
        List fields = schema.getFields();
        boolean result = true;
        for (Schema.Field avroField : fields) {
            int dbFieldPosition = 0;
            Schema fieldSchema = SchemaHelper.unwindUnionSchema((Schema.Field)avroField);
            Schema.Type avroFieldType = fieldSchema.getType();
            String dbFieldPositionStr = SchemaHelper.getMetaField((Schema.Field)avroField, (String)"dbFieldPosition");
            if (avroFieldType == Schema.Type.ARRAY && (null == dbFieldPositionStr || dbFieldPositionStr.isEmpty())) {
                Schema elementSchema = fieldSchema.getElementType();
                dbFieldPositionStr = SchemaHelper.getMetaField((Schema)elementSchema, (String)"dbFieldPosition");
            }
            if (null == dbFieldPositionStr || dbFieldPositionStr.isEmpty()) {
                LOG.error((Object)("compareRecord: Could not find dbFieldPosition for " + avroField.name()));
                return false;
            }
            dbFieldPosition = Integer.valueOf(dbFieldPositionStr) + 3;
            Object expObj = null;
            try {
                expObj = oracleRecord.getObject(dbFieldPosition);
            }
            catch (SQLException sx) {
                String errMsg = "SQLException reading object for avroField " + avroField.name() + " at dbFieldPosition " + dbFieldPositionStr + "+3: maybe view " + this._tableName + " used in " + BootstrapSeederMain.getSourcesConfigFile() + " doesn't match that in schema " + this._schema.getName() + "?";
                LOG.error((Object)errMsg);
                throw new RuntimeException(errMsg, sx);
            }
            Object gotObj = avroRecord.get(avroField.name());
            if (_sDebug) {
                LOG.debug((Object)("Key:" + avroField.name() + ", got object:" + gotObj));
            }
            if (this.compareField(avroField, expObj, gotObj)) continue;
            result = false;
        }
        return result;
    }

    public boolean compareRecord(ResultSet expRs, GenericRecord avroRec) throws SQLException {
        return this.compareRecord(this._schema, expRs, avroRec);
    }

    public boolean compareRecord(ResultSet expRs, ResultSet avroFormattedRs, DbusEventAvroDecoder decoder) throws SQLException {
        if (_sDebug) {
            LOG.debug((Object)"Compare Record:");
        }
        GenericRecord record = this.getGenericRecord(avroFormattedRs, decoder);
        return this.compareRecord(this._schema, expRs, record);
    }

    public GenericRecord getGenericRecord(ResultSet avroFormattedRs, DbusEventAvroDecoder decoder) throws SQLException {
        this._buffer.clear();
        this._buffer.put(avroFormattedRs.getBytes("val"));
        this._event = this._event.reset(this._buffer, 0);
        GenericRecord record = decoder.getGenericRecord((DbusEvent)this._event);
        return record;
    }
}

