/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.utils;

import com.linkedin.databus2.util.DBHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.log4j.Logger;

public abstract class BootstrapAuditTableReader {
    public static final String MODULE = BootstrapAuditTableReader.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final boolean _sDebug = LOG.isDebugEnabled();
    protected final Connection _conn;
    protected final String _tableName;
    protected final Schema.Field _srcPkeyField;
    protected final Schema.Type _pkeyType;
    protected final String _pkeyName;
    protected final int _interval;

    public BootstrapAuditTableReader(Connection conn, String tableName, Schema.Field pkeyField, String pkeyName, Schema.Type pkeyType, int interval) {
        this._conn = conn;
        this._tableName = tableName;
        this._srcPkeyField = pkeyField;
        this._pkeyType = pkeyType;
        this._pkeyName = pkeyName;
        this._interval = interval;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumRecords(String key) {
        long numRecords;
        ResultSet rs;
        PreparedStatement stmt;
        block4: {
            String sql = this.getNumRecordsStmt(key);
            stmt = null;
            rs = null;
            numRecords = -1L;
            try {
                stmt = this._conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                numRecords = rs.getLong(1);
            }
            catch (SQLException sqlEx) {
                try {
                    LOG.error((Object)("getNumRecords() error: " + sqlEx.getMessage()), (Throwable)sqlEx);
                }
                catch (Throwable throwable) {
                    DBHelper.close(rs, (Statement)stmt, null);
                    throw throwable;
                }
                DBHelper.close((ResultSet)rs, (Statement)stmt, null);
            }
        }
        DBHelper.close((ResultSet)rs, (Statement)stmt, null);
        return numRecords;
    }

    public ResultSet getRecords(String from) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getFetchStmt(from);
            rs = stmt.executeQuery();
        }
        catch (SQLException sqlEx) {
            DBHelper.close(rs, null, null);
            throw sqlEx;
        }
        return rs;
    }

    private String getNumRecordsStmt(String key) {
        StringBuilder sql = new StringBuilder();
        sql.append("select count(" + key + ") from ");
        sql.append(this._tableName);
        return sql.toString();
    }

    public abstract PreparedStatement getFetchStmt(String var1) throws SQLException;

    public static class ResultSetEntry {
        private Long _id;
        private byte[] _avroRecord;
        private Map<String, Object> _sourceRecord;

        public Long getId() {
            return this._id;
        }

        public void setId(Long id) {
            this._id = id;
        }

        public byte[] getAvroRecord() {
            return this._avroRecord;
        }

        public void setAvroRecord(byte[] avroRecord) {
            this._avroRecord = avroRecord;
        }

        public Map<String, Object> getSourceRecord() {
            return this._sourceRecord;
        }

        public void setSourceRecord(Map<String, Object> sourceRecord) {
            this._sourceRecord = sourceRecord;
        }

        public ResultSetEntry(long id) {
            this._id = id;
            this._sourceRecord = new HashMap<String, Object>();
        }
    }
}

