/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.utils;

import com.linkedin.databus.bootstrap.utils.BootstrapAuditTableReader;
import com.linkedin.databus.bootstrap.utils.BootstrapAuditTester;
import com.linkedin.databus.bootstrap.utils.BootstrapDBSeeder;
import com.linkedin.databus.bootstrap.utils.BootstrapSeederMain;
import com.linkedin.databus.bootstrap.utils.BootstrapSrcDBEventReader;
import com.linkedin.databus.client.DbusEventAvroDecoder;
import com.linkedin.databus.core.DbusEventKey;
import com.linkedin.databus.core.util.StringUtils;
import com.linkedin.databus2.producers.db.OracleTriggerMonitoredSourceInfo;
import com.linkedin.databus2.relay.OracleJarUtils;
import com.linkedin.databus2.schemas.FileSystemSchemaRegistryService;
import com.linkedin.databus2.schemas.VersionedSchema;
import com.linkedin.databus2.schemas.VersionedSchemaSet;
import com.linkedin.databus2.schemas.utils.SchemaHelper;
import com.linkedin.databus2.util.DBHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class BootstrapAuditMain {
    public static final String MODULE = BootstrapAuditMain.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);

    public static void main(String[] args) throws Exception {
        BootstrapSeederMain.init(args);
        BootstrapSeederMain.StaticConfig staticConfig = BootstrapSeederMain.getStaticConfig();
        int interval = staticConfig.getController().getCommitInterval();
        int sourceChunkSize = staticConfig.getController().getNumRowsPerQuery();
        List<OracleTriggerMonitoredSourceInfo> sources = BootstrapSeederMain.getSources();
        BootstrapDBSeeder seeder = BootstrapSeederMain.getSeeder();
        BootstrapSrcDBEventReader seedController = BootstrapSeederMain.getReader();
        Map<String, String> pKeyNameMap = seedController.getpKeyNameMap();
        Map<String, DbusEventKey.KeyType> pKeyTypeMap = seedController.getpKeyTypeMap();
        for (OracleTriggerMonitoredSourceInfo source : sources) {
            short srcId = source.getSourceId();
            new ConcurrentHashMap();
            OracleTableReader oracleReader = null;
            MySQLTableReader mySQLReader = null;
            try {
                Schema.Field pkeyField;
                FileSystemSchemaRegistryService schemaRegistry = FileSystemSchemaRegistryService.build((FileSystemSchemaRegistryService.StaticConfig)staticConfig.getSchemaRegistry().getFileSystem());
                Map schemaSet = schemaRegistry.fetchAllSchemaVersionsBySourceName(source.getSourceName());
                VersionedSchemaSet vSchemaSet = new VersionedSchemaSet();
                for (Map.Entry pairs : schemaSet.entrySet()) {
                    Schema s = Schema.parse((String)((String)pairs.getValue()));
                    VersionedSchema vs = new VersionedSchema(s.getFullName(), ((Short)pairs.getKey()).shortValue(), s, null);
                    vSchemaSet.add(vs);
                }
                VersionedSchema vschema = schemaRegistry.fetchLatestVersionedSchemaBySourceName(source.getSourceName());
                Schema schema = Schema.parse((String)vschema.getSchema().toString());
                LOG.info((Object)("Schema =" + vschema.getSchema() + "version=" + vschema.getVersion() + " name=" + vschema.getSchemaBaseName()));
                Schema.Field txnFieldType = schema.getField("txn");
                if (txnFieldType == null) {
                    throw new Exception("Unable to find field called 'txn'. Cannot proceeed\n");
                }
                Schema.Type txnType = SchemaHelper.getAnyType((Schema.Field)txnFieldType);
                String keyOverrideName = SchemaHelper.getMetaField((Schema)schema, (String)"pk");
                String keyColumnName = "key";
                if (null != keyOverrideName) {
                    keyColumnName = keyOverrideName;
                }
                if (null == (pkeyField = schema.getField(keyColumnName))) {
                    keyColumnName = "id";
                    pkeyField = schema.getField("id");
                }
                if (null == pkeyField) {
                    throw new Exception("Unable to get the primary key for schema. Schema is :" + schema);
                }
                DbusEventAvroDecoder decoder = new DbusEventAvroDecoder(vSchemaSet);
                BootstrapAuditTester auditor = new BootstrapAuditTester(schema, BootstrapSrcDBEventReader.getTableName(source));
                ArrayList<BootstrapAuditTester> auditors = new ArrayList<BootstrapAuditTester>();
                auditors.add(auditor);
                oracleReader = new OracleTableReader(BootstrapSeederMain.getDataStore().getConnection(), BootstrapSrcDBEventReader.getTableName(source), pkeyField, SchemaHelper.getMetaField((Schema.Field)pkeyField, (String)"dbFieldName"), SchemaHelper.getAnyType((Schema.Field)pkeyField), sourceChunkSize, seedController.getPKIndex(source), seedController.getQueryHint(source));
                mySQLReader = new MySQLTableReader(seeder.getConnection(), seeder.getTableName(srcId), pkeyField, "id", SchemaHelper.getAnyType((Schema.Field)pkeyField), interval);
                double samplePct = BootstrapSeederMain.getValidationSamplePct();
                TableComparator comparator = new TableComparator(oracleReader, mySQLReader, auditor, decoder, interval, pKeyNameMap.get(source.getEventView()), pKeyTypeMap.get(source.getEventView()), txnType, samplePct);
                boolean success = false;
                success = BootstrapSeederMain.getValidationType().equals("point") ? comparator.compareRecordsPoint() : (BootstrapSeederMain.getValidationType().equals("pointBs") ? comparator.compareRecordsPointBs() : comparator.compareRecordsNew());
                if (success) {
                    LOG.info((Object)"Audit completed successfully");
                    continue;
                }
                LOG.error((Object)"Audit FAILED !!! ");
            }
            catch (Exception ex) {
                LOG.error((Object)"Caught an exception ex", (Throwable)ex);
                throw ex;
            }
            finally {
                if (null == oracleReader) continue;
                oracleReader.close();
            }
        }
        DBHelper.close((Connection)seeder.getConnection());
    }

    static {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.INFO);
    }

    public static class KeyTxnReader {
        private final BufferedReader _reader;

        public KeyTxnReader(File file) {
            try {
                this._reader = new BufferedReader(StringUtils.createFileReader((File)file));
            }
            catch (IOException ioe) {
                LOG.error((Object)("KeyTxnReader error: " + ioe.getMessage()), (Throwable)ioe);
                throw new RuntimeException(ioe);
            }
        }

        public boolean readNextEntry(BootstrapSrcDBEventReader.PrimaryKeyTxn entry) throws IOException {
            String line = this._reader.readLine();
            if (null == line) {
                return false;
            }
            entry.readFrom(line);
            return true;
        }

        public void close() {
            try {
                this._reader.close();
            }
            catch (IOException ioe) {
                LOG.error((Object)("KeyTxnReader error: " + ioe.getMessage()), (Throwable)ioe);
            }
        }
    }

    public static class OracleTableReader
    extends BootstrapAuditTableReader {
        private final DbusEventKey.KeyType _dbusKeyType;
        private final String _pkIndex;
        private final String _queryHint;
        private PreparedStatement _pointRecordStmt = null;
        private PreparedStatement _rangeRecordStmt = null;
        Method _setLobPrefetchSizeMethod = null;
        Class<?> _oraclePreparedStatementClass = null;

        public OracleTableReader(Connection conn, String tableName, Schema.Field pkeyField, String pkeyName, Schema.Type pkeyType, int interval, String pkIndex, String queryHint) throws SQLException {
            super(conn, tableName, pkeyField, pkeyName, pkeyType, interval);
            this._dbusKeyType = pkeyType == Schema.Type.INT || pkeyType == Schema.Type.LONG ? DbusEventKey.KeyType.LONG : DbusEventKey.KeyType.STRING;
            this._pkIndex = pkIndex;
            this._queryHint = queryHint;
            String pointRecordsql = this.generatePointQuery(this._tableName, this._pkeyName, this._pkIndex, this._queryHint);
            this._pointRecordStmt = this._conn.prepareStatement(pointRecordsql);
            LOG.info((Object)("Tablename=" + tableName));
            LOG.info((Object)("Point Oracle Query =" + pointRecordsql));
            try {
                this._oraclePreparedStatementClass = OracleJarUtils.loadClass((String)"oracle.jdbc.OraclePreparedStatement");
                this._setLobPrefetchSizeMethod = this._oraclePreparedStatementClass.getMethod("setLobPrefetchSize", Integer.TYPE);
            }
            catch (Exception e) {
                LOG.error((Object)"Exception raised while trying to get oracle methods", (Throwable)e);
                throw new SQLException(e.getMessage());
            }
        }

        public String generatePointQuery(String table, String keyName, String pkIndex, String queryHint) {
            StringBuilder sql = new StringBuilder();
            if (null == queryHint || queryHint.isEmpty()) {
                sql.append("select /*+ INDEX(src ").append(pkIndex).append(") */ ");
            } else {
                sql.append("select /*+ " + queryHint + " */ ");
            }
            sql.append(keyName).append(" keyn,");
            sql.append(" txn txnid, src.* ").append(" from ");
            sql.append(table);
            sql.append(" src");
            sql.append(" where src." + keyName + " = ?");
            return sql.toString();
        }

        @Override
        public void close() {
            DBHelper.close((Statement)this._pointRecordStmt);
            DBHelper.close((Statement)this._rangeRecordStmt);
            super.close();
        }

        public ResultSet getRecord(String destKey) throws SQLException {
            ResultSet rs = null;
            try {
                this._pointRecordStmt.setString(1, destKey);
                rs = this._pointRecordStmt.executeQuery();
            }
            catch (SQLException sqlEx) {
                DBHelper.close(rs, (Statement)this._pointRecordStmt, null);
                throw sqlEx;
            }
            return rs;
        }

        @Override
        public PreparedStatement getFetchStmt(String from) throws SQLException {
            try {
                if (this._rangeRecordStmt == null || this._rangeRecordStmt.isClosed()) {
                    String sql = BootstrapSrcDBEventReader.generateEventQueryAudit(this._tableName, this._pkeyName, this._dbusKeyType, this._pkIndex, this._queryHint);
                    LOG.info((Object)("Oracle Query =" + sql));
                    this._rangeRecordStmt = this._conn.prepareStatement(sql);
                    Object ds = this._oraclePreparedStatementClass.cast(this._rangeRecordStmt);
                    try {
                        this._setLobPrefetchSizeMethod.invoke(ds, 1000);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Could not set LobPreFetchSize: " + e));
                        throw new SQLException(e.getMessage());
                    }
                }
                LOG.info((Object)("Oracle Query: From=" + from + " interval=" + this._interval));
                this._rangeRecordStmt.setString(1, from);
                this._rangeRecordStmt.setLong(2, this._interval);
                return this._rangeRecordStmt;
            }
            catch (SQLException e) {
                DBHelper.close((Statement)this._rangeRecordStmt);
                throw e;
            }
        }
    }

    public static class MySQLTableReader
    extends BootstrapAuditTableReader {
        private PreparedStatement _pointRecordStmt = null;
        private PreparedStatement _rangeRecordStmt = null;
        private PreparedStatement _sequentialRangeRecordStmt = null;

        public MySQLTableReader(Connection conn, String tableName, Schema.Field pkeyField, String pkeyName, Schema.Type pkeyType, int interval) throws SQLException {
            super(conn, tableName, pkeyField, pkeyName, pkeyType, interval);
            StringBuilder sql = new StringBuilder();
            sql.append("select id,scn,srckey,val from ").append(this._tableName);
            sql.append(" where srckey= ?");
            this._pointRecordStmt = this._conn.prepareStatement(sql.toString());
            StringBuilder sqlSequence = new StringBuilder();
            sqlSequence.append("select id,scn,srckey,val from ").append(this._tableName);
            sqlSequence.append(" where id > ? limit ? ");
            this._sequentialRangeRecordStmt = this._conn.prepareStatement(sqlSequence.toString());
        }

        public ResultSet getRecordsSequential(long lastDestId) throws SQLException {
            ResultSet rs = null;
            try {
                this._sequentialRangeRecordStmt.setLong(1, lastDestId);
                this._sequentialRangeRecordStmt.setLong(2, this._interval);
                rs = this._sequentialRangeRecordStmt.executeQuery();
            }
            catch (SQLException sqlEx) {
                DBHelper.close(rs, (Statement)this._sequentialRangeRecordStmt, null);
                throw sqlEx;
            }
            return rs;
        }

        @Override
        public void close() {
            DBHelper.close((Statement)this._pointRecordStmt);
            DBHelper.close((Statement)this._rangeRecordStmt);
            DBHelper.close((Statement)this._sequentialRangeRecordStmt);
            super.close();
        }

        public ResultSet getRecord(String lastSrcKey) throws SQLException {
            ResultSet rs = null;
            try {
                this._pointRecordStmt.setString(1, lastSrcKey);
                rs = this._pointRecordStmt.executeQuery();
            }
            catch (SQLException sqlEx) {
                DBHelper.close(rs, (Statement)this._pointRecordStmt, null);
                throw sqlEx;
            }
            return rs;
        }

        @Override
        public PreparedStatement getFetchStmt(String from) throws SQLException {
            try {
                if (this._rangeRecordStmt == null || this._rangeRecordStmt.isClosed()) {
                    StringBuilder sql = new StringBuilder();
                    sql.append(" select id, scn, srckey, val from ").append(this._tableName);
                    if (this._pkeyType == Schema.Type.LONG || this._pkeyType == Schema.Type.INT) {
                        sql.append(" where cast(srckey as decimal(40)) > ?  order by ");
                        sql.append(" cast(srckey as decimal(40)) asc");
                    } else {
                        sql.append(" where srckey > ?  order by ");
                        sql.append(" srckey asc");
                    }
                    sql.append(" limit ? ");
                    String stmtStr = sql.toString();
                    LOG.info((Object)("MySQL Query=" + stmtStr));
                    this._rangeRecordStmt = this._conn.prepareStatement(stmtStr);
                }
                LOG.info((Object)("MySQL Query params: FromSrcKey= " + from + ",Limit=" + this._interval));
                this._rangeRecordStmt.setString(1, from);
                this._rangeRecordStmt.setLong(2, this._interval);
                return this._rangeRecordStmt;
            }
            catch (SQLException e) {
                DBHelper.close(null, (Statement)this._rangeRecordStmt, null);
                this._rangeRecordStmt = null;
                throw e;
            }
        }
    }

    public static class TableComparator {
        private final OracleTableReader _srcReader;
        private final MySQLTableReader _destReader;
        private final DbusEventAvroDecoder _decoder;
        private final BootstrapAuditTester _auditor;
        private final int _interval;
        private final String _pKey;
        private final DbusEventKey.KeyType _pKeyType;
        private final Schema.Type _txnType;
        private final double _samplePct;
        private final Random _rand = new Random();

        public TableComparator(OracleTableReader srcReader, MySQLTableReader destReader, BootstrapAuditTester auditor, DbusEventAvroDecoder decoder, int interval, String pKey, DbusEventKey.KeyType pKeyType, Schema.Type txnType, double samplePct) {
            this._srcReader = srcReader;
            this._destReader = destReader;
            this._decoder = decoder;
            this._interval = interval;
            this._auditor = auditor;
            this._pKey = pKey;
            this._pKeyType = pKeyType;
            this._txnType = txnType;
            this._samplePct = samplePct;
            LOG.info((Object)("Comparator: interval=" + this._interval + " samplePct=" + this._samplePct));
        }

        private boolean shouldCompare() {
            if (this._samplePct == 0.0) {
                return false;
            }
            if (this._samplePct == 100.0) {
                return true;
            }
            return this._samplePct > this._rand.nextDouble() * 100.0;
        }

        public boolean compareRecordsPointBs() throws SQLException {
            AuditStats stats = new AuditStats();
            Thread statsThread = new Thread(stats);
            try {
                ResultSet srcRs = null;
                ResultSet destRs = null;
                statsThread.start();
                String lastSrcKey = "0";
                boolean oracleDone = true;
                boolean done = false;
                while (!done) {
                    if (oracleDone) {
                        done = true;
                        DBHelper.close((ResultSet)srcRs);
                        srcRs = this._srcReader.getRecords(lastSrcKey);
                    }
                    oracleDone = !srcRs.next();
                    boolean bl = done = done && oracleDone;
                    if (oracleDone) continue;
                    lastSrcKey = this.getKey(srcRs);
                    if (!this.shouldCompare()) continue;
                    stats.incNumProcessed();
                    DBHelper.close(destRs);
                    destRs = this._destReader.getRecord(lastSrcKey);
                    boolean found = destRs.next();
                    if (found) {
                        stats.incNumKeyEqual();
                        long srcTxnId = srcRs.getLong(2);
                        long dstTxnId = this.getDestTxnId(destRs);
                        if (srcTxnId == dstTxnId) {
                            boolean result = this._auditor.compareRecord(srcRs, destRs, this._decoder);
                            if (result) {
                                stats.incNumDataEqual();
                                continue;
                            }
                            LOG.error((Object)("Compare error: Key=" + lastSrcKey));
                            continue;
                        }
                        if (srcTxnId < dstTxnId) {
                            stats.incNumOlderTxnInOracle();
                            continue;
                        }
                        stats.incNumOlderTxnInBootstrap();
                        continue;
                    }
                    LOG.info((Object)("Absent in bootstrap: " + lastSrcKey));
                    stats.incNumKeyAbsentInBootstrap();
                }
                LOG.info((Object)"Done with audit- end of stream reached\n");
                stats.shutdown();
                statsThread.interrupt();
                statsThread.join();
                return stats.getNumProcessed() == stats.getNumDataEqual();
            }
            catch (SQLException e) {
                stats.shutdown();
                statsThread.interrupt();
                throw e;
            }
            catch (InterruptedException interruptedException) {
                LOG.info((Object)"Done with audit- end of stream reached\n");
                return stats.getNumProcessed() == stats.getNumDataEqual();
            }
        }

        public boolean compareRecordsPoint() throws SQLException {
            AuditStats stats = new AuditStats();
            Thread statsThread = new Thread(stats);
            try {
                ResultSet srcRs = null;
                ResultSet destRs = null;
                statsThread.start();
                long lastDestId = 0L;
                boolean bootstrapDone = true;
                boolean done = false;
                while (!done) {
                    if (bootstrapDone) {
                        done = true;
                        if (this.shouldCompare()) {
                            DBHelper.close((ResultSet)destRs);
                            destRs = this._destReader.getRecordsSequential(lastDestId);
                        } else {
                            done = false;
                            lastDestId += (long)this._interval;
                            continue;
                        }
                    }
                    bootstrapDone = !destRs.next();
                    boolean bl = done = done && bootstrapDone;
                    if (bootstrapDone) continue;
                    lastDestId = destRs.getLong(1);
                    String lastDestKey = destRs.getString(3);
                    stats.incNumProcessed();
                    DBHelper.close(srcRs);
                    srcRs = this._srcReader.getRecord(lastDestKey);
                    boolean found = srcRs.next();
                    if (found) {
                        stats.incNumKeyEqual();
                        long srcTxnId = srcRs.getLong(2);
                        long dstTxnId = this.getDestTxnId(destRs);
                        if (dstTxnId != 0L) {
                            if (srcTxnId == dstTxnId) {
                                boolean result = this._auditor.compareRecord(srcRs, destRs, this._decoder);
                                if (result) {
                                    stats.incNumDataEqual();
                                    continue;
                                }
                                LOG.error((Object)("Compare error: Key=" + lastDestKey));
                                continue;
                            }
                            if (srcTxnId < dstTxnId) {
                                stats.incNumOlderTxnInOracle();
                                continue;
                            }
                            stats.incNumOlderTxnInBootstrap();
                            continue;
                        }
                        stats.incNumError();
                        continue;
                    }
                    stats.incNumnKeyAbsentInOracle();
                }
                LOG.info((Object)"Done with audit- end of stream reached\n");
                stats.shutdown();
                statsThread.interrupt();
                statsThread.join();
                return stats.getNumProcessed() == stats.getNumDataEqual();
            }
            catch (SQLException e) {
                stats.shutdown();
                statsThread.interrupt();
                throw e;
            }
            catch (InterruptedException interruptedException) {
                LOG.info((Object)"Done with audit- end of stream reached\n");
                return stats.getNumProcessed() == stats.getNumDataEqual();
            }
        }

        public boolean compareRecordsNew() throws SQLException {
            AuditStats stats = new AuditStats();
            Thread statsThread = new Thread(stats);
            try {
                ResultSet srcRs = null;
                ResultSet destRs = null;
                statsThread.start();
                String lastSrcKey = "0";
                String lastDestKey = "0";
                int compareResult = 0;
                boolean oracleDone = true;
                boolean bootstrapDone = true;
                boolean done = false;
                while (!done) {
                    if (oracleDone) {
                        done = true;
                        DBHelper.close(srcRs);
                        srcRs = this._srcReader.getRecords(lastSrcKey);
                    }
                    if (bootstrapDone) {
                        done = true;
                        DBHelper.close(destRs);
                        destRs = this._destReader.getRecords(lastDestKey);
                    }
                    if (compareResult <= 0) {
                        boolean bl = oracleDone = !srcRs.next();
                    }
                    if (compareResult >= 0) {
                        bootstrapDone = !destRs.next();
                    }
                    boolean bl = done = done && (bootstrapDone || oracleDone);
                    if (!bootstrapDone && !oracleDone) {
                        stats.incNumProcessed();
                        lastSrcKey = this.getKey(srcRs);
                        lastDestKey = destRs.getString(3);
                        compareResult = this.keyCompare(lastSrcKey, lastDestKey);
                        if (compareResult == 0) {
                            stats.incNumKeyEqual();
                            long srcTxnId = srcRs.getLong(2);
                            long dstTxnId = this.getDestTxnId(destRs);
                            if (srcTxnId == dstTxnId) {
                                boolean result = this._auditor.compareRecord(srcRs, destRs, this._decoder);
                                if (result) {
                                    stats.incNumDataEqual();
                                    continue;
                                }
                                LOG.error((Object)("Compare error: Key=" + lastSrcKey));
                                continue;
                            }
                            if (srcTxnId < dstTxnId) {
                                stats.incNumOlderTxnInOracle();
                                continue;
                            }
                            stats.incNumOlderTxnInBootstrap();
                            continue;
                        }
                        if (compareResult < 0) {
                            LOG.info((Object)("Absent in bootstrap: " + lastSrcKey));
                            stats.incNumKeyAbsentInBootstrap();
                            continue;
                        }
                        LOG.info((Object)("Absent in oracle: " + lastDestKey));
                        stats.incNumnKeyAbsentInOracle();
                        continue;
                    }
                    if (!bootstrapDone && oracleDone) {
                        compareResult = -1;
                        continue;
                    }
                    if (!oracleDone && bootstrapDone) {
                        compareResult = 1;
                        continue;
                    }
                    compareResult = 0;
                }
                LOG.info((Object)"Done with audit- end of stream reached\n");
                stats.shutdown();
                statsThread.interrupt();
                statsThread.join();
                return stats.getNumProcessed() == stats.getNumDataEqual();
            }
            catch (SQLException e) {
                stats.shutdown();
                statsThread.interrupt();
                throw e;
            }
            catch (InterruptedException interruptedException) {
                LOG.info((Object)"Done with audit- end of stream reached\n");
                return stats.getNumProcessed() == stats.getNumDataEqual();
            }
        }

        protected String getKey(ResultSet srcRs) throws SQLException {
            if (this._pKeyType == DbusEventKey.KeyType.LONG) {
                Long key = srcRs.getLong(this._pKey);
                return key.toString();
            }
            return srcRs.getString(this._pKey);
        }

        protected int keyCompare(String keySrc, String keyDst) {
            if (this._pKeyType == DbusEventKey.KeyType.LONG) {
                long destKeyLong;
                long srcKeyLong = Long.parseLong(keySrc);
                if (srcKeyLong == (destKeyLong = Long.parseLong(keyDst))) {
                    return 0;
                }
                return srcKeyLong < destKeyLong ? -1 : 1;
            }
            return keySrc.compareTo(keyDst);
        }

        private long getDestTxnId(ResultSet bsRes) throws SQLException {
            GenericRecord avroRec = this._auditor.getGenericRecord(bsRes, this._decoder);
            if (avroRec == null) {
                LOG.error((Object)"No avro record skipping");
                return 0L;
            }
            Object txnId = avroRec.get("txn");
            if (txnId == null) {
                LOG.error((Object)"Could not find a field called 'txn' in avro event in bootstrap db");
                return 0L;
            }
            switch (this._txnType) {
                case LONG: {
                    if (txnId instanceof Integer) {
                        Integer i = (Integer)txnId;
                        return i.longValue();
                    }
                    if (txnId instanceof Long) {
                        return (Long)txnId;
                    }
                }
                case INT: {
                    Integer i = (Integer)txnId;
                    return i.longValue();
                }
            }
            return 0L;
        }
    }

    public static class AuditStats
    implements Runnable {
        private long _numProcessed = 0L;
        private long _numKeyEqual = 0L;
        private long _numKeyAbsentInBootstrap = 0L;
        private long _numKeyAbsentInOracle = 0L;
        private long _numDataEqual = 0L;
        private long _numOlderTxnInOracle = 0L;
        private long _numOlderTxnInBootstrap = 0L;
        private boolean _shutdown = false;
        private final int _intervalInSec;
        private long _numError = 0L;

        public AuditStats() {
            this(30);
        }

        public AuditStats(int intervalSec) {
            this._intervalInSec = intervalSec;
        }

        @Override
        public void run() {
            while (!this._shutdown) {
                this.print();
                try {
                    Thread.sleep(this._intervalInSec * 1000);
                }
                catch (InterruptedException e) {
                    this._shutdown = true;
                }
            }
            this.print();
        }

        public void print() {
            LOG.info((Object)("AuditStats\n" + this));
        }

        public String toString() {
            StringBuilder s = new StringBuilder(512);
            s.append(" numProcessed=").append(this._numProcessed).append(" numKeyEqual=").append(this._numKeyEqual).append(" numDataEqual=").append(this._numDataEqual).append(" numKeyAbsentInOracle=").append(this._numKeyAbsentInOracle).append(" numKeyAbsentInBootstrap=").append(this._numKeyAbsentInBootstrap).append(" numOlderTxnInOracle=").append(this._numOlderTxnInOracle).append(" numOlderTxnInBootstrap=").append(this._numOlderTxnInBootstrap).append(" numError=").append(this._numError);
            return s.toString();
        }

        public synchronized void shutdown() {
            this._shutdown = true;
        }

        public long getNumProcessed() {
            return this._numProcessed;
        }

        public long getNumKeyEqual() {
            return this._numKeyEqual;
        }

        public long getNumKeyAbsentInBootstrap() {
            return this._numKeyAbsentInBootstrap;
        }

        public long getNumKeyAbsentInOracle() {
            return this._numKeyAbsentInOracle;
        }

        public long getNumDataEqual() {
            return this._numDataEqual;
        }

        public long getNumOlderTxnInOracle() {
            return this._numOlderTxnInOracle;
        }

        public long getNumOlderTxnInBootstrap() {
            return this._numOlderTxnInBootstrap;
        }

        public boolean isShutdown() {
            return this._shutdown;
        }

        public int getIntervalInSec() {
            return this._intervalInSec;
        }

        public long getNumError() {
            return this._numError;
        }

        public synchronized void incNumProcessed() {
            ++this._numProcessed;
        }

        public synchronized void incNumnKeyAbsentInOracle() {
            ++this._numKeyAbsentInOracle;
        }

        public synchronized void incNumKeyAbsentInBootstrap() {
            ++this._numKeyAbsentInBootstrap;
        }

        public synchronized void incNumOlderTxnInBootstrap() {
            ++this._numOlderTxnInBootstrap;
        }

        public synchronized void incNumOlderTxnInOracle() {
            ++this._numOlderTxnInOracle;
        }

        public synchronized void incNumDataEqual() {
            ++this._numDataEqual;
        }

        public synchronized void incNumKeyEqual() {
            ++this._numKeyEqual;
        }

        public synchronized void incNumError() {
            ++this._numError;
        }
    }
}

