/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.server;

import com.linkedin.databus.bootstrap.api.BootstrapProcessingException;
import com.linkedin.databus.bootstrap.common.BootstrapHttpStatsCollector;
import com.linkedin.databus.bootstrap.server.BootstrapEventWriter;
import com.linkedin.databus.bootstrap.server.BootstrapHttpServer;
import com.linkedin.databus.bootstrap.server.BootstrapProcessor;
import com.linkedin.databus.bootstrap.server.BootstrapRequestProcessorBase;
import com.linkedin.databus.bootstrap.server.BootstrapServerStaticConfig;
import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus.core.DatabusComponentStatus;
import com.linkedin.databus.core.DbusClientMode;
import com.linkedin.databus.core.Encoding;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollector;
import com.linkedin.databus.core.monitoring.mbean.StatsCollectorMergeable;
import com.linkedin.databus.core.monitoring.mbean.StatsCollectors;
import com.linkedin.databus2.core.container.request.BootstrapDBException;
import com.linkedin.databus2.core.container.request.BootstrapDatabaseTooOldException;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import com.linkedin.databus2.core.filter.DbusFilter;
import com.linkedin.databus2.core.filter.DbusKeyFilter;
import com.linkedin.databus2.core.filter.KeyFilterConfigJSONFactory;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.sql.SQLException;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;

public class BootstrapRequestProcessor
extends BootstrapRequestProcessorBase {
    public static final String MODULE = BootstrapRequestProcessor.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String COMMAND_NAME = "bootstrap";
    public static final String ACTION_PARAM = "action";
    public static final String CHECKPOINT_PARAM = "checkPoint";
    public static final String BATCHSIZE_PARAM = "batchSize";
    public static final String PARTITION_INFO_PARAM = "filter";
    public static final String OUTPUT_PARAM = "output";
    public static final int DEFAULT_BUFFER_MARGIN_SPACE = 900;
    public static final int DEFAULT_JSON_OVERHEAD_BYTES = 10;
    private final DatabusComponentStatus _componentStatus;

    public BootstrapRequestProcessor(ExecutorService executorService, BootstrapServerStaticConfig config, BootstrapHttpServer bootstrapServer) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        super(executorService, config, bootstrapServer);
        this._componentStatus = bootstrapServer.getComponentStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DatabusRequest doProcess(DatabusRequest request) throws IOException, RequestProcessingException {
        BootstrapProcessor processor = null;
        BootstrapHttpStatsCollector bootstrapStatsCollector = this._bootstrapServer.getBootstrapStatsCollector();
        long startTime = System.currentTimeMillis();
        boolean isDebug = LOG.isDebugEnabled();
        try {
            try {
                String threadName = Thread.currentThread().getName();
                DbusEventsStatisticsCollector threadCollector = (DbusEventsStatisticsCollector)this._bootstrapServer.getOutBoundStatsCollectors().getStatsCollector(threadName);
                if (null == threadCollector) {
                    threadCollector = new DbusEventsStatisticsCollector(this._bootstrapServer.getContainerStaticConfig().getId(), threadName, true, false, this._bootstrapServer.getMbeanServer());
                    StatsCollectors ds = this._bootstrapServer.getOutBoundStatsCollectors();
                    ds.addStatsCollector(threadName, (StatsCollectorMergeable)threadCollector);
                }
                processor = new BootstrapProcessor(this._config, threadCollector);
            }
            catch (Exception e) {
                if (null != bootstrapStatsCollector) {
                    bootstrapStatsCollector.registerErrBootstrap();
                }
                throw new RequestProcessingException((Throwable)e);
            }
            DatabusComponentStatus componentStatus = this._componentStatus.getStatusSnapshot();
            if (!componentStatus.isRunningStatus()) {
                if (null != bootstrapStatsCollector) {
                    bootstrapStatsCollector.registerErrBootstrap();
                }
                throw new RequestProcessingException(componentStatus.getMessage());
            }
            String partitionInfoString = request.getParams().getProperty(PARTITION_INFO_PARAM);
            DbusKeyFilter keyFilter = null;
            if (null != partitionInfoString && !partitionInfoString.isEmpty()) {
                try {
                    keyFilter = KeyFilterConfigJSONFactory.parseDbusKeyFilter((String)partitionInfoString);
                    if (isDebug) {
                        LOG.debug((Object)("ServerSideFilter is :" + keyFilter));
                    }
                }
                catch (Exception ex) {
                    String msg = "Unable to parse partitionInfo from request. PartitionInfo was :" + partitionInfoString;
                    LOG.error((Object)msg, (Throwable)ex);
                    throw new RequestProcessingException(msg, (Throwable)ex);
                }
            }
            String outputFormat = request.getParams().getProperty(OUTPUT_PARAM);
            Encoding enc = Encoding.BINARY;
            if (null != outputFormat) {
                try {
                    enc = Encoding.valueOf((String)outputFormat.toUpperCase());
                }
                catch (Exception ex) {
                    LOG.error((Object)("Unable to find the output format for bootstrap request for " + outputFormat + ". Using Binary!!"), (Throwable)ex);
                }
            }
            processor.setKeyFilter(keyFilter);
            String checkpointString = request.getRequiredStringParam(CHECKPOINT_PARAM);
            int bufferMarginSpace = 900;
            if (null != this._serverHostPort) {
                bufferMarginSpace = Math.max(bufferMarginSpace, this._serverHostPort.length() + "bootstrap_server_info".length() + 10);
            }
            int clientFreeBufferSize = request.getRequiredIntParam(BATCHSIZE_PARAM) - checkpointString.length() - bufferMarginSpace;
            BootstrapEventWriter writer = null;
            writer = this._config.getPredicatePushDown() ? this.createEventWriter(request, clientFreeBufferSize, null, enc) : this.createEventWriter(request, clientFreeBufferSize, (DbusFilter)keyFilter, enc);
            Checkpoint cp = new Checkpoint(checkpointString);
            DbusClientMode consumptionMode = cp.getConsumptionMode();
            LOG.info((Object)("Bootstrap request received: fetchSize=" + clientFreeBufferSize + ", consumptionMode=" + consumptionMode + ", checkpoint=" + checkpointString + ", predicatePushDown=" + this._config.getPredicatePushDown()));
            try {
                boolean phaseCompleted = false;
                switch (consumptionMode) {
                    case BOOTSTRAP_SNAPSHOT: {
                        phaseCompleted = processor.streamSnapShotRows(new Checkpoint(checkpointString), writer);
                        break;
                    }
                    case BOOTSTRAP_CATCHUP: {
                        phaseCompleted = processor.streamCatchupRows(new Checkpoint(checkpointString), writer);
                        break;
                    }
                    default: {
                        if (null != bootstrapStatsCollector) {
                            bootstrapStatsCollector.registerErrBootstrap();
                        }
                        throw new RequestProcessingException("Unexpected mode: " + consumptionMode);
                    }
                }
                if (null != bootstrapStatsCollector) {
                    bootstrapStatsCollector.registerBootStrapReq(cp, System.currentTimeMillis() - startTime, (long)clientFreeBufferSize);
                }
                if (writer.getNumRowsWritten() == 0L && writer.getSizeOfPendingEvent() > 0) {
                    request.getResponseContent().addMetadata("x-dbus-pending-event-size", (Object)writer.getSizeOfPendingEvent());
                    if (isDebug) {
                        LOG.debug((Object)("Returning 0 events but have pending event of size " + writer.getSizeOfPendingEvent()));
                    }
                }
                if (phaseCompleted) {
                    request.getResponseContent().setMetadata("PhaseCompleted", (Object)"TRUE");
                }
            }
            catch (BootstrapDatabaseTooOldException e) {
                if (null != bootstrapStatsCollector) {
                    bootstrapStatsCollector.registerErrDatabaseTooOld();
                }
                LOG.error((Object)"Bootstrap database is too old!", (Throwable)e);
                throw new RequestProcessingException((Throwable)e);
            }
            catch (BootstrapDBException e) {
                if (null != bootstrapStatsCollector) {
                    bootstrapStatsCollector.registerErrBootstrap();
                }
                throw new RequestProcessingException((Throwable)e);
            }
            catch (SQLException e) {
                if (null != bootstrapStatsCollector) {
                    bootstrapStatsCollector.registerErrSqlException();
                }
                throw new RequestProcessingException((Throwable)e);
            }
            catch (BootstrapProcessingException e) {
                if (null != bootstrapStatsCollector) {
                    bootstrapStatsCollector.registerErrBootstrap();
                }
                throw new RequestProcessingException((Throwable)e);
            }
        }
        finally {
            if (null != processor) {
                processor.shutdown();
            }
        }
        return request;
    }

    protected BootstrapEventWriter createEventWriter(DatabusRequest request, long clientFreeBufferSize, DbusFilter keyFilter, Encoding enc) {
        BootstrapEventWriter writer = new BootstrapEventWriter((WritableByteChannel)request.getResponseContent(), clientFreeBufferSize, keyFilter, enc);
        return writer;
    }
}

