/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.producer;

import com.linkedin.databus.bootstrap.common.BootstrapCleanerStaticConfig;
import com.linkedin.databus.bootstrap.common.BootstrapDBCleaner;
import com.linkedin.databus.core.DatabusThreadBase;
import org.apache.log4j.Logger;

public class BootstrapDBPeriodicTriggerThread
extends DatabusThreadBase {
    public static final String MODULE = BootstrapDBPeriodicTriggerThread.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final long MILLISEC_IN_SECONDS = 1000L;
    private final BootstrapDBCleaner _cleaner;
    private final BootstrapCleanerStaticConfig.PeriodicTriggerConfig _config;

    public BootstrapDBPeriodicTriggerThread(BootstrapDBCleaner cleaner, BootstrapCleanerStaticConfig.PeriodicTriggerConfig config) {
        super("BootstrapDBPeriodicTriggerThread");
        this._cleaner = cleaner;
        this._config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long roundBeginTime;
        LOG.info((Object)("PeriodicTrigger Config :" + this._config));
        long runNumber = 0L;
        long roundEndTime = roundBeginTime = System.currentTimeMillis();
        long timeToSleep = this._config.getRunIntervalSeconds() * 1000L;
        if (!this._config.isRunOnStart()) {
            LOG.info((Object)("Sleeping for :" + timeToSleep / 1000L + " seconds !!"));
            try {
                Thread.sleep(timeToSleep);
            }
            catch (InterruptedException ie) {
                LOG.info((Object)("Got interrupted while sleeping for :" + timeToSleep));
            }
        }
        while (!this.isShutdownRequested()) {
            LOG.info((Object)("Run : " + ++runNumber));
            BootstrapDBCleaner ie = this._cleaner;
            synchronized (ie) {
                roundBeginTime = System.currentTimeMillis();
                this._cleaner.doClean();
                roundEndTime = System.currentTimeMillis();
            }
            long timeTakenMs = roundEndTime - roundBeginTime;
            LOG.info((Object)("Round (" + runNumber + ") complete. Took around " + timeTakenMs / 1000L + " seconds !!"));
            timeToSleep = this._config.getRunIntervalSeconds() * 1000L - timeTakenMs;
            LOG.info((Object)("Sleeping for :" + timeToSleep / 1000L + " seconds !!"));
            try {
                Thread.sleep(timeToSleep);
            }
            catch (InterruptedException ie2) {
                LOG.info((Object)("Got interrupted while sleeping for :" + timeToSleep + " ms"));
            }
        }
        this.doShutdownNotify();
    }
}

