/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.producer;

import com.linkedin.databus.bootstrap.common.BootstrapCleanerStaticConfig;
import com.linkedin.databus.bootstrap.common.BootstrapDBCleaner;
import com.linkedin.databus.core.DatabusThreadBase;
import java.io.File;
import org.apache.log4j.Logger;

public class BootstrapDBDiskSpaceTriggerThread
extends DatabusThreadBase {
    public static final String MODULE = BootstrapDBDiskSpaceTriggerThread.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private final BootstrapDBCleaner _cleaner;
    private final BootstrapCleanerStaticConfig.DiskSpaceTriggerConfig _config;

    public BootstrapDBDiskSpaceTriggerThread(BootstrapDBCleaner cleaner, BootstrapCleanerStaticConfig.DiskSpaceTriggerConfig config) {
        super("DiskSpaceTrigger");
        this._cleaner = cleaner;
        this._config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LOG.info((Object)("DiskSpaceTrigger Config :" + this._config));
        File bootstrapDBDrive = new File(this._config.getBootstrapDBDrive());
        if (!bootstrapDBDrive.exists()) {
            LOG.error((Object)("Bootstrap Drive (" + bootstrapDBDrive.getAbsolutePath() + ") not found. Disabling DiskSpaceTrigger !!"));
            return;
        }
        long run = 0L;
        while (!this.isShutdownRequested()) {
            LOG.info((Object)("DiskSpace Trigger run :" + ++run));
            long total = bootstrapDBDrive.getTotalSpace();
            long available = bootstrapDBDrive.getUsableSpace();
            double percentAvailable = (double)available * 100.0 / (double)total;
            LOG.info((Object)("BootstrapDB Drive(" + bootstrapDBDrive.getAbsolutePath() + ") : Total bytes :" + total + ", Avalable bytes :" + available + ", Percent Available :" + percentAvailable));
            if (percentAvailable < this._config.getAvailableThresholdPercent()) {
                LOG.info((Object)("Available Space (" + percentAvailable + ") less than threshold (" + this._config.getAvailableThresholdPercent() + "). Triggering cleaner !!"));
                BootstrapDBCleaner bootstrapDBCleaner = this._cleaner;
                synchronized (bootstrapDBCleaner) {
                    this._cleaner.doClean();
                }
            }
            LOG.info((Object)("Sleeping for :" + this._config.getRunIntervalSeconds() + " seconds !!"));
            try {
                Thread.sleep(this._config.getRunIntervalSeconds() * 1000L);
            }
            catch (InterruptedException ie) {
                LOG.info((Object)("Got interrupted while sleeping for :" + this._config.getRunIntervalSeconds() + " seconds !!"));
            }
        }
        this.doShutdownNotify();
    }
}

