/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.monitoring.server.mbean;

import com.linkedin.databus.bootstrap.monitoring.server.events.DbusBootstrapHttpStatsEvent;
import com.linkedin.databus.bootstrap.monitoring.server.mbean.DbusBootstrapHttpStatsMBean;
import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus.core.DbusClientMode;
import com.linkedin.databus.core.monitoring.mbean.AbstractMonitoringMBean;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.concurrent.locks.Lock;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificDatumWriter;

public class DbusBootstrapHttpStats
extends AbstractMonitoringMBean<DbusBootstrapHttpStatsEvent>
implements DbusBootstrapHttpStatsMBean {
    public DbusBootstrapHttpStats(int id, String dimension, boolean enabled, boolean threadSafe, DbusBootstrapHttpStatsEvent initData) {
        super(enabled, threadSafe, (Object)initData);
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).ownerId = id;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).dimension = dimension;
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumReqBootstrap() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numErrReqBootstrap;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumReqSnapshot() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numReqSnapshot;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumReqCatchup() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numReqCatchup;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumErrReqBootstrap() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numErrReqBootstrap;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumErrReqDatabaseTooOld() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numErrReqDatabaseTooOld;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumErrSqlException() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numErrSqlException;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumReqStartSCN() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numReqStartSCN;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumReqTargetSCN() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numReqTargetSCN;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumErrStartSCN() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numErrTargetSCN;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumErrTargetSCN() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numErrTargetSCN;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLatencySnapshot() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).latencySnapshot;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLatencyCatchup() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).latencyCatchup;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLatencyStartSCN() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).latencyStartSCN;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLatencyTargetSCN() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).latencyTargetSCN;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSizeBatch() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).sizeBatch;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMinBootstrapSCN() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).minBootstrapSCN;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaxBootstrapSCN() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).maxBootstrapSCN;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerBootStrapReq(Checkpoint cp, long latency, long size) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((DbusBootstrapHttpStatsEvent)((Object)this._event)).numReqBootstrap;
            DbusClientMode mode = cp.getConsumptionMode();
            if (mode == DbusClientMode.BOOTSTRAP_CATCHUP) {
                ((DbusBootstrapHttpStatsEvent)((Object)this._event)).latencyCatchup += latency;
                ++((DbusBootstrapHttpStatsEvent)((Object)this._event)).numReqCatchup;
            } else if (mode == DbusClientMode.BOOTSTRAP_SNAPSHOT) {
                ++((DbusBootstrapHttpStatsEvent)((Object)this._event)).numReqSnapshot;
                ((DbusBootstrapHttpStatsEvent)((Object)this._event)).latencySnapshot += latency;
            }
            ((DbusBootstrapHttpStatsEvent)((Object)this._event)).maxBootstrapSCN = this.maxValue(cp.getWindowScn(), ((DbusBootstrapHttpStatsEvent)((Object)this._event)).maxBootstrapSCN);
            ((DbusBootstrapHttpStatsEvent)((Object)this._event)).minBootstrapSCN = this.minValue(cp.getWindowScn(), ((DbusBootstrapHttpStatsEvent)((Object)this._event)).minBootstrapSCN);
            ((DbusBootstrapHttpStatsEvent)((Object)this._event)).sizeBatch += size;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerStartSCNReq(long latency) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((DbusBootstrapHttpStatsEvent)((Object)this._event)).numReqStartSCN;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerTargetSCNReq(long latency) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((DbusBootstrapHttpStatsEvent)((Object)this._event)).numReqTargetSCN;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerErrBootstrap() {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((DbusBootstrapHttpStatsEvent)((Object)this._event)).numErrReqBootstrap;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerErrStartSCN() {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((DbusBootstrapHttpStatsEvent)((Object)this._event)).numErrStartSCN;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerErrTargetSCN() {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((DbusBootstrapHttpStatsEvent)((Object)this._event)).numErrTargetSCN;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerErrSqlException() {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((DbusBootstrapHttpStatsEvent)((Object)this._event)).numErrSqlException;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerErrDatabaseTooOld() {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((DbusBootstrapHttpStatsEvent)((Object)this._event)).numErrReqDatabaseTooOld;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimestampLastResetMs() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).timestampLastResetMs;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeSinceLastResetMs() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).timeSinceLastResetMs;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    public JsonEncoder createJsonEncoder(OutputStream out) throws IOException {
        return new JsonEncoder(((DbusBootstrapHttpStatsEvent)((Object)this._event)).getSchema(), out);
    }

    public ObjectName generateObjectName() throws MalformedObjectNameException {
        Hashtable mbeanProps = this.generateBaseMBeanProps();
        mbeanProps.put("ownerId", Integer.toString(((DbusBootstrapHttpStatsEvent)((Object)this._event)).ownerId));
        mbeanProps.put("dimension", ((Object)((DbusBootstrapHttpStatsEvent)((Object)this._event)).dimension).toString());
        return new ObjectName("com.linkedin.databus2", mbeanProps);
    }

    protected void resetData() {
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).timestampLastResetMs = System.currentTimeMillis();
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).timeSinceLastResetMs = 0L;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numReqBootstrap = 0L;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numReqSnapshot = 0L;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numReqCatchup = 0L;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numErrReqBootstrap = 0L;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numErrReqDatabaseTooOld = 0L;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numErrSqlException = 0L;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numReqStartSCN = 0L;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numReqTargetSCN = 0L;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numErrStartSCN = 0L;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numErrTargetSCN = 0L;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).latencySnapshot = 0L;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).latencyCatchup = 0L;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).latencyStartSCN = 0L;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).latencyTargetSCN = 0L;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).sizeBatch = 0L;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).minBootstrapSCN = -1L;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).maxBootstrapSCN = -1L;
    }

    protected void cloneData(DbusBootstrapHttpStatsEvent eventData) {
        eventData.timestampLastResetMs = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).timestampLastResetMs;
        eventData.timeSinceLastResetMs = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).timeSinceLastResetMs;
        eventData.numReqBootstrap = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numReqBootstrap;
        eventData.numReqSnapshot = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numReqSnapshot;
        eventData.numReqCatchup = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numReqCatchup;
        eventData.numErrReqBootstrap = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numErrReqBootstrap;
        eventData.numErrReqDatabaseTooOld = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numErrReqDatabaseTooOld;
        eventData.numErrSqlException = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numErrSqlException;
        eventData.numReqStartSCN = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numReqStartSCN;
        eventData.numReqTargetSCN = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numReqTargetSCN;
        eventData.numErrStartSCN = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numErrStartSCN;
        eventData.numErrTargetSCN = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numErrTargetSCN;
        eventData.latencySnapshot = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).latencySnapshot;
        eventData.latencyCatchup = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).latencyCatchup;
        eventData.latencyStartSCN = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).latencyStartSCN;
        eventData.latencyTargetSCN = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).latencyTargetSCN;
        eventData.sizeBatch = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).sizeBatch;
        eventData.minBootstrapSCN = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).minBootstrapSCN;
        eventData.maxBootstrapSCN = ((DbusBootstrapHttpStatsEvent)((Object)this._event)).maxBootstrapSCN;
    }

    protected DbusBootstrapHttpStatsEvent newDataEvent() {
        return new DbusBootstrapHttpStatsEvent();
    }

    protected SpecificDatumWriter<DbusBootstrapHttpStatsEvent> getAvroWriter() {
        return new SpecificDatumWriter(DbusBootstrapHttpStatsEvent.class);
    }

    protected void doMergeStats(Object eventData) {
        if (!(eventData instanceof DbusBootstrapHttpStatsEvent)) {
            LOG.warn((Object)("Attempt to merge unknown event class" + eventData.getClass().getName()));
            return;
        }
        DbusBootstrapHttpStatsEvent e = (DbusBootstrapHttpStatsEvent)((Object)eventData);
        if (((DbusBootstrapHttpStatsEvent)((Object)this._event)).ownerId > 0 && e.ownerId != ((DbusBootstrapHttpStatsEvent)((Object)this._event)).ownerId) {
            LOG.warn((Object)("Attempt to data for a different relay " + e.ownerId));
            return;
        }
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numReqBootstrap += e.numReqBootstrap;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numReqSnapshot += e.numReqSnapshot;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numReqCatchup += e.numReqCatchup;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numErrReqBootstrap += e.numErrReqBootstrap;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numErrReqDatabaseTooOld += e.numErrReqDatabaseTooOld;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numErrSqlException += e.numErrSqlException;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numReqStartSCN += e.numReqStartSCN;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numReqTargetSCN += e.numReqTargetSCN;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numErrStartSCN += e.numErrStartSCN;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).numErrTargetSCN += e.numErrTargetSCN;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).latencySnapshot += e.latencySnapshot;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).latencyCatchup += e.latencyCatchup;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).latencyStartSCN += e.latencyStartSCN;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).latencyTargetSCN += e.latencyTargetSCN;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).sizeBatch += e.sizeBatch;
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).minBootstrapSCN = this.minValue(((DbusBootstrapHttpStatsEvent)((Object)this._event)).minBootstrapSCN, e.minBootstrapSCN);
        ((DbusBootstrapHttpStatsEvent)((Object)this._event)).maxBootstrapSCN = this.maxValue(((DbusBootstrapHttpStatsEvent)((Object)this._event)).maxBootstrapSCN, e.maxBootstrapSCN);
    }
}

