/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.common;

import com.linkedin.databus.bootstrap.common.BootstrapCleanerStaticConfig;
import com.linkedin.databus.bootstrap.common.BootstrapConn;
import com.linkedin.databus.bootstrap.common.BootstrapDBCleanerQueryExecutor;
import com.linkedin.databus.bootstrap.common.BootstrapDBCleanerQueryHelper;
import com.linkedin.databus.bootstrap.common.BootstrapDBMetaDataDAO;
import com.linkedin.databus.bootstrap.common.BootstrapLogInfo;
import com.linkedin.databus.bootstrap.common.BootstrapReadOnlyConfig;
import com.linkedin.databus.core.DatabusThreadBase;
import com.linkedin.databus.core.DbusEventFactory;
import com.linkedin.databus.core.DbusEventV1Factory;
import com.linkedin.databus2.core.container.request.BootstrapDatabaseTooOldException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class BootstrapDBSingleSourceCleaner
implements Runnable {
    public static final String MODULE = BootstrapDBSingleSourceCleaner.class.getName();
    public final Logger LOG;
    private final String _name;
    private final String _source;
    private final DatabusThreadBase _applier;
    private final BootstrapCleanerStaticConfig _bootstrapCleanerStaticConfig;
    private final BootstrapReadOnlyConfig _bootstrapReadOnlyConfig;
    private BootstrapDBMetaDataDAO _bootstrapDao = null;
    private BootstrapDBMetaDataDAO.SourceStatusInfo _sourceStatusInfo = null;
    private final BootstrapDBCleanerQueryHelper _bootstrapDBCleanerQueryHelper;
    private final BootstrapDBCleanerQueryExecutor _bootstrapDBCleanerQueryExecutor;
    private final DbusEventFactory _eventFactory;
    private BootstrapLogInfo _lastValidLog;
    private volatile boolean _isCleaning = false;
    private static final AtomicInteger _numCleanersRunning = new AtomicInteger(0);
    private static final AtomicInteger _numCleanersRunningHWM = new AtomicInteger(0);

    public BootstrapDBSingleSourceCleaner(String name, String source, DatabusThreadBase applier, BootstrapCleanerStaticConfig bootstrapCleanerStaticConfig, BootstrapReadOnlyConfig bootstrapReadOnlyConfig) throws SQLException {
        this._name = name;
        this._source = source;
        this._applier = applier;
        this._bootstrapCleanerStaticConfig = bootstrapCleanerStaticConfig;
        this._bootstrapReadOnlyConfig = bootstrapReadOnlyConfig;
        this.LOG = Logger.getLogger((String)name);
        Connection conn = this.getOrCreateConnection();
        if (null != source) {
            try {
                List<BootstrapDBMetaDataDAO.SourceStatusInfo> ssil = this._bootstrapDao.getSourceIdAndStatusFromName(Arrays.asList(source), false);
                assert (ssil.size() == 1);
                this._sourceStatusInfo = ssil.get(0);
            }
            catch (BootstrapDatabaseTooOldException bto) {
                this.LOG.error((Object)"Not expected to receive this exception as activeCheck is turned-off", (Throwable)bto);
                throw new RuntimeException(bto);
            }
        }
        this._bootstrapDBCleanerQueryHelper = BootstrapDBCleanerQueryHelper.getInstance();
        this._bootstrapDBCleanerQueryExecutor = new BootstrapDBCleanerQueryExecutor(this._name, conn, this._bootstrapDBCleanerQueryHelper);
        this._eventFactory = new DbusEventV1Factory();
    }

    private Connection getOrCreateConnection() throws SQLException {
        Connection conn = null;
        if (this._bootstrapDao == null) {
            this.LOG.info((Object)"<<<< Creating Bootstrap Connection!! >>>>");
            BootstrapConn dbConn = new BootstrapConn();
            boolean autoCommit = true;
            try {
                this._bootstrapDao = new BootstrapDBMetaDataDAO(dbConn, this._bootstrapReadOnlyConfig.getBootstrapDBHostname(), this._bootstrapReadOnlyConfig.getBootstrapDBUsername(), this._bootstrapReadOnlyConfig.getBootstrapDBPassword(), this._bootstrapReadOnlyConfig.getBootstrapDBName(), true);
                dbConn.initBootstrapConn(true, this._bootstrapReadOnlyConfig.getBootstrapDBUsername(), this._bootstrapReadOnlyConfig.getBootstrapDBPassword(), this._bootstrapReadOnlyConfig.getBootstrapDBHostname(), this._bootstrapReadOnlyConfig.getBootstrapDBName());
            }
            catch (Exception e) {
                this.LOG.fatal((Object)"Unable to open BootstrapDB Connection !!", (Throwable)e);
                throw new RuntimeException("Got exception when getting bootstrap DB Connection.", e);
            }
        }
        try {
            conn = this._bootstrapDao.getBootstrapConn().getDBConn();
        }
        catch (SQLException e) {
            this.LOG.fatal((Object)"Not able to open BootstrapDB Connection !!", (Throwable)e);
            throw new RuntimeException("Got exception when getting bootstrap DB Connection.", e);
        }
        return conn;
    }

    @Override
    public void run() {
        this.doClean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClean() {
        try {
            this.incCleanerStats();
            BootstrapDBMetaDataDAO.SourceStatusInfo s = this._sourceStatusInfo;
            assert (s.getSrcName().equals(this._source));
            BootstrapCleanerStaticConfig.BootstrapDBType type = this._bootstrapCleanerStaticConfig.getBootstrapType(s.getSrcName());
            this.LOG.info((Object)("Cleaner running for source :" + s.getSrcName() + "(" + s.getSrcId() + ") with bootstrapDB type :" + (Object)((Object)type)));
            BootstrapLogInfo logInfo = this._bootstrapDBCleanerQueryExecutor.getThresholdWindowSCN(type, s.getSrcId());
            if (null == logInfo) {
                this.LOG.info((Object)("No WindowSCN. Nothing to cleanup for source : " + s.getSrcName()));
                return;
            }
            this.LOG.info((Object)("LOG info with lowest windowSCN :" + logInfo));
            this.LOG.info((Object)"Begin phase 1 : Gather candidate loginfo :");
            List<BootstrapLogInfo> candidateLogsInfo = this._bootstrapDBCleanerQueryExecutor.getCandidateLogsInfo(logInfo.getMinWindowSCN(), (short)s.getSrcId());
            if (null == candidateLogsInfo || candidateLogsInfo.isEmpty()) {
                this.LOG.info((Object)("No logs to cleanup for source :" + s.getSrcName() + "(" + s.getSrcId() + ")"));
                return;
            }
            this.LOG.info((Object)"End phase 1 : Gather candidate loginfo :");
            this.LOG.info((Object)("Initial Candidate Set for Source :" + s.getSrcName() + " is :" + candidateLogsInfo));
            BootstrapCleanerStaticConfig.RetentionStaticConfig rConf = this._bootstrapCleanerStaticConfig.getRetentionConfig(s.getSrcName());
            this.LOG.info((Object)("Retention Config for source :" + s.getSrcName() + " is :" + rConf));
            this.LOG.info((Object)"Begin phase 2 : Filter based on retention config :");
            long scn = this.filterCandidateLogInfo((short)s.getSrcId(), candidateLogsInfo, this._bootstrapCleanerStaticConfig.getRetentionConfig(s.getSrcName()));
            this.LOG.info((Object)("Log tables to be deleted for source :" + s.getSrcName() + "(" + s.getSrcId() + ") are :" + candidateLogsInfo + ", Max SCN of deleted logs:" + scn));
            this.LOG.info((Object)"End phase 2 : Filter based on retention config :");
            if (scn <= 0L || candidateLogsInfo.isEmpty()) {
                this.LOG.info((Object)("Source :" + s.getSrcName() + "(" + s.getSrcId() + ") No log tables to be deleted !! MaxSCN : " + scn + ", candidateLogs :" + candidateLogsInfo));
                return;
            }
            this.LOG.info((Object)"Begin phase 3 : Updating Meta Info :");
            BootstrapLogInfo firstValidLog = this._bootstrapDBCleanerQueryExecutor.getFirstLogTableWithGreaterSCN((short)s.getSrcId(), scn);
            this._bootstrapDBCleanerQueryExecutor.updateSource(firstValidLog);
            this.LOG.info((Object)"End phase 3 : Updating Meta Info :");
            this.LOG.info((Object)"Begin phase 4 : Deleting Log tables :");
            this._bootstrapDBCleanerQueryExecutor.markDeleted(candidateLogsInfo);
            this._bootstrapDBCleanerQueryExecutor.dropTables(candidateLogsInfo);
            this.LOG.info((Object)"End phase 4 : Deleting Log tables :");
            if (this._bootstrapCleanerStaticConfig.getBootstrapType(s.getSrcName()) == BootstrapCleanerStaticConfig.BootstrapDBType.BOOTSTRAP_CATCHUP_APPLIER_RUNNING && (this._applier != null || this._bootstrapCleanerStaticConfig.forceTabTableCleanup(s.getSrcName()).booleanValue())) {
                this.LOG.info((Object)("Source :" + s.getSrcName() + "(" + s.getSrcId() + ") is running in catchup_applier_running mode. " + "Will delete all rows whose scn is less than or equal to " + scn));
                if (null != this._applier && this._applier.isAlive()) {
                    this.LOG.info((Object)"Begin phase 5 : Pausing Applier and deleting Rows from tab table :");
                    this.LOG.info((Object)"Requesting applier to pause !!");
                    this._applier.pause();
                    this.LOG.info((Object)"Applier paused !!");
                }
                try {
                    this._bootstrapDao.updateMinScnOfSnapshot(s.getSrcId(), scn);
                    String srcTable = this._bootstrapDBCleanerQueryHelper.getSrcTable(s.getSrcId());
                    int numRowsDeleted = this._bootstrapDBCleanerQueryExecutor.deleteTable(srcTable, scn);
                    this.LOG.info((Object)("Number of Rows deleted for source  :" + s.getSrcName() + "(" + s.getSrcId() + ") :" + numRowsDeleted));
                    if (numRowsDeleted > 0 && this._bootstrapCleanerStaticConfig.isOptimizeTableEnabled(s.getSrcName()).booleanValue()) {
                        this.LOG.info((Object)("Optimizing table to reclaim space for source :" + s.getSrcName() + "(" + s.getSrcId() + ")"));
                        this._bootstrapDBCleanerQueryExecutor.optimizeTable(srcTable);
                    }
                }
                finally {
                    if (null != this._applier && this._applier.isAlive()) {
                        this.LOG.info((Object)"Requesting applier to resume !!");
                        this._applier.unpause();
                        this.LOG.info((Object)"Applier resumed !!");
                    }
                }
                this.LOG.info((Object)"End phase 5 : Deleting Rows from tab table :");
            }
            this.LOG.info((Object)("Cleaner done for source :" + s.getSrcName() + "(" + s.getSrcId() + ")"));
        }
        catch (SQLException ex) {
            this.LOG.error((Object)"Got SQL exception while cleaning bootstrapDB !!", (Throwable)ex);
        }
        catch (InterruptedException ie) {
            this.LOG.error((Object)"Got interrupted exception while cleaning bootstrapDB !!", (Throwable)ie);
        }
        finally {
            this.decCleanerStats();
        }
    }

    public BootstrapDBMetaDataDAO getBootstrapDao() {
        return this._bootstrapDao;
    }

    public boolean isCleanerRunning() {
        return this._isCleaning;
    }

    public String getName() {
        return this._name;
    }

    public void close() {
        if (this._bootstrapDao != null) {
            this._bootstrapDao.close();
            this._bootstrapDao = null;
        }
    }

    public static int getNumCleanersRunningHWM() {
        return _numCleanersRunningHWM.get();
    }

    private long getMilliSecTime(BootstrapCleanerStaticConfig.RetentionStaticConfig config) {
        long qty = config.getRetentionQuantity();
        long milliSecQty = -1L;
        switch (config.getRetentiontype()) {
            case RETENTION_SECONDS: {
                milliSecQty = qty * 1000L;
                break;
            }
            default: {
                throw new RuntimeException("Retention Config (" + config + ") expected to be time based but is not !!");
            }
        }
        return milliSecQty;
    }

    private long filterCandidateLogInfo(short srcId, List<BootstrapLogInfo> candidateLogsInfo, BootstrapCleanerStaticConfig.RetentionStaticConfig config) throws SQLException {
        switch (config.getRetentiontype()) {
            case NO_CLEANUP: {
                return -1L;
            }
            case RETENTION_LOGS: {
                Iterator<BootstrapLogInfo> itr = candidateLogsInfo.iterator();
                BootstrapLogInfo lastValidLog = null;
                int i = 0;
                while ((long)i < config.getRetentionQuantity() && itr.hasNext()) {
                    BootstrapLogInfo log = itr.next();
                    this.LOG.info((Object)("Removing the log table :" + log.getLogTable() + " from the delete List as it is too recent. Retaining :" + config.getRetentionQuantity() + " logs"));
                    itr.remove();
                    lastValidLog = log;
                    ++i;
                }
                this._lastValidLog = lastValidLog;
                break;
            }
            case RETENTION_SECONDS: {
                long quantity = config.getRetentionQuantity();
                this.LOG.info((Object)("Retaining tables which could contain events which is less than " + quantity + " seconds old !!"));
                long currTs = System.currentTimeMillis() * 1000000L;
                long nanoSecQty = this.getMilliSecTime(config) * 1000000L;
                long threshold = currTs - nanoSecQty;
                this.LOG.info((Object)("Removing tables from the delete-list whose last row has timestamp newer than :" + threshold + " nanosecs"));
                Iterator<BootstrapLogInfo> itr = candidateLogsInfo.iterator();
                BootstrapLogInfo lastValidLog = null;
                this.LOG.info((Object)("Timestamp Threshold for src id :" + srcId + " is :" + threshold + ", Retention Config " + config + "(" + nanoSecQty + " nanosecs)"));
                while (itr.hasNext()) {
                    BootstrapLogInfo log = itr.next();
                    long timestamp = this._bootstrapDBCleanerQueryExecutor.getNanoTimestampOfLastEventinLog(log, this._eventFactory);
                    if (timestamp < threshold) {
                        this.LOG.info((Object)("Reached the log table whose timestamp (" + timestamp + ") is less than the threshold (" + threshold + ")."));
                        break;
                    }
                    this.LOG.info((Object)("Removing the log table :" + log.getLogTable() + " from the delete List as it is too recent. Last Event Timestamp :" + timestamp + ", threshold :" + threshold));
                    lastValidLog = log;
                    itr.remove();
                }
                this._lastValidLog = lastValidLog;
            }
        }
        long scn = -1L;
        if (!candidateLogsInfo.isEmpty()) {
            scn = this._bootstrapDBCleanerQueryExecutor.getSCNOfLastEventinLog(candidateLogsInfo.get(0), this._eventFactory);
        }
        return scn;
    }

    private void incCleanerStats() {
        int curCleaners;
        this._isCleaning = true;
        int curCleanersHwm = _numCleanersRunningHWM.get();
        if (curCleanersHwm < (curCleaners = _numCleanersRunning.incrementAndGet())) {
            _numCleanersRunningHWM.set(curCleaners);
        }
    }

    private void decCleanerStats() {
        this._isCleaning = false;
        _numCleanersRunning.decrementAndGet();
    }
}

