/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.common;

import com.linkedin.databus.bootstrap.api.BootstrapProcessingException;
import com.linkedin.databus.bootstrap.common.BootstrapConn;
import com.linkedin.databus.bootstrap.common.SourceInfo;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.core.container.request.BootstrapDBException;
import com.linkedin.databus2.core.container.request.BootstrapDatabaseTooOldException;
import com.linkedin.databus2.util.DBHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BootstrapDBMetaDataDAO {
    public static final String MODULE = BootstrapDBMetaDataDAO.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final int NO_SOURCE_ID = -1;
    public static final long DEFAULT_WINDOWSCN = -1L;
    public static final long INFINITY_WINDOWSCN = Long.MAX_VALUE;
    public static final String MIN_SCN_TABLE_NAME = "bootstrap_tab_minscn";
    public static final String CREATE_MINSCN_TABLE = "bootstrap_tab_minscn (srcid int(11) NOT NULL,minscn bigint(20) NOT NULL default -1, PRIMARY KEY  (srcid)) ENGINE=InnoDB;";
    private final BootstrapConn _bootstrapConn;
    private final String _dbHostname;
    private final String _dbUsername;
    private final String _dbPassword;
    private final String _dbName;

    public void reinitDB() throws SQLException {
        this.dropDB();
        BootstrapDBMetaDataDAO.createDB(this._dbName, this._dbUsername, this._dbPassword, this._dbHostname);
        this._bootstrapConn.close();
        this._bootstrapConn.recreateConnection();
        this.setupDB();
    }

    public void dropDB() throws SQLException {
        String sql = "drop database if exists " + this._dbName;
        this._bootstrapConn.executeDDL(sql);
    }

    public void setupDB() throws SQLException {
        LOG.info((Object)"Setting up Bootstrap DB");
        String[] sql = new String[]{"CREATE TABLE if not exists " + this._dbName + ".bootstrap_sources (id int(11) NOT NULL auto_increment,src varchar(255) NOT NULL,status TINYINT default 1,logstartscn bigint(20) default 0, PRIMARY KEY  (id),UNIQUE KEY src (src)) ENGINE=InnoDB;", "CREATE TABLE if not exists " + this._dbName + ".bootstrap_loginfo (srcid int(11) NOT NULL,logid int(11) NOT NULL default 0,minwindowscn bigint(20) NOT NULL default -1,maxwindowscn bigint(20) NOT NULL default -1,maxrid bigint(20) NOT NULL default 0,deleted TINYINT default 0,PRIMARY KEY (srcid, logid)) ENGINE=InnoDB;", "CREATE TABLE if not exists " + this._dbName + ".bootstrap_producer_state (srcid int(11) NOT NULL,logid int(11) NOT NULL default 0,windowscn bigint(20) NOT NULL default 0,rid bigint(20) NOT NULL default 0,PRIMARY KEY  (srcid)) ENGINE=InnoDB;", "CREATE TABLE if not exists " + this._dbName + ".bootstrap_applier_state (srcid int(11) NOT NULL,logid int(11) NOT NULL default 0,windowscn bigint(20) NOT NULL default 0,rid bigint(20) NOT NULL default 0,PRIMARY KEY  (srcid)) ENGINE=InnoDB;", "CREATE TABLE if not exists " + this._dbName + ".bootstrap_seeder_state (srcid int(11) NOT NULL,startscn bigint(20) NOT NULL default -1,endscn bigint(20) NOT NULL default -1,rid bigint(20) NOT NULL default 0,srckey varchar(255) NOT NULL default '',PRIMARY KEY  (srcid)) ENGINE=InnoDB;", "CREATE TABLE if not exists " + this._dbName + "." + CREATE_MINSCN_TABLE};
        for (int i = 0; i < sql.length; ++i) {
            this._bootstrapConn.executeDDL(sql[i]);
        }
    }

    public void setupMinScnTable() throws SQLException {
        String sql = "CREATE TABLE if not exists " + this._dbName + "." + CREATE_MINSCN_TABLE;
        this._bootstrapConn.executeDDL(sql);
    }

    public static void createDB(String dbName, String dbUsername, String dbPassword, String dbHostname) throws SQLException {
        String dbSql = "CREATE DATABASE if not exists " + dbName;
        BootstrapConn bConn = new BootstrapConn();
        Statement stmt = null;
        try {
            LOG.info((Object)("Creating new db using SQL :" + dbSql));
            try {
                bConn.initBootstrapConn(false, dbUsername, dbPassword, dbHostname, null);
            }
            catch (InstantiationException e) {
                LOG.error((Object)"Got instantiation error while creating new bootstrapDB :", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)"Got illegal access error while creating new bootstrapDB :", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)"Got class-not-found error while creating new bootstrapDB :", (Throwable)e);
                throw new RuntimeException(e);
            }
            stmt = bConn.getDBConn().createStatement();
            int ret = stmt.executeUpdate(dbSql);
            LOG.info((Object)("Create DB returned :" + ret));
        }
        catch (SQLException sqlEx) {
            try {
                LOG.error((Object)"Got error while creating new bootstrapDB :", (Throwable)sqlEx);
                throw sqlEx;
            }
            catch (Throwable throwable) {
                DBHelper.close(stmt);
                bConn.close();
                throw throwable;
            }
        }
        DBHelper.close((Statement)stmt);
        bConn.close();
    }

    public BootstrapDBMetaDataDAO(BootstrapConn bootstrapConn, String hostname, String dbUsername, String dbPassword, String dbName, boolean autoCommit) throws SQLException, DatabusException {
        this._dbHostname = hostname;
        this._dbUsername = dbUsername;
        this._dbPassword = dbPassword;
        this._dbName = dbName;
        this._bootstrapConn = bootstrapConn;
    }

    public void addNewSourceInDB(String source, int state) throws SQLException, BootstrapDatabaseTooOldException {
        this.addNewSourceInDB(-1, source, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewSourceInDB(int srcid, String source, int state) throws SQLException, BootstrapDatabaseTooOldException {
        Connection conn = this._bootstrapConn.getDBConn();
        PreparedStatement addSrcStmt = null;
        try {
            int i = 1;
            try {
                if (srcid == -1) {
                    addSrcStmt = conn.prepareStatement("insert into bootstrap_sources (src, status) values(?, ?) ");
                } else {
                    addSrcStmt = conn.prepareStatement("insert into bootstrap_sources (id, src, status) values(?, ?, ?) ");
                    addSrcStmt.setInt(i++, srcid);
                }
                addSrcStmt.setString(i++, source);
                addSrcStmt.setInt(i++, state);
                addSrcStmt.executeUpdate();
            }
            catch (Throwable throwable) {
                DBHelper.close(addSrcStmt);
                throw throwable;
            }
            DBHelper.close((Statement)addSrcStmt);
            addSrcStmt = null;
            try {
                if (srcid == -1) {
                    SourceStatusInfo srcIdStatus = this.getSrcIdStatusFromDB(source, false);
                    srcid = srcIdStatus.getSrcId();
                }
                addSrcStmt = conn.prepareStatement("insert into bootstrap_loginfo (srcid) values(?)");
                addSrcStmt.setInt(1, srcid);
                addSrcStmt.executeUpdate();
                addSrcStmt.close();
            }
            finally {
                DBHelper.close((Statement)addSrcStmt);
            }
            addSrcStmt = null;
            try {
                addSrcStmt = conn.prepareStatement("insert into bootstrap_producer_state (srcid,windowscn) values(?, ?)");
                addSrcStmt.setInt(1, srcid);
                addSrcStmt.setLong(2, -1L);
                addSrcStmt.executeUpdate();
                addSrcStmt.close();
                addSrcStmt = null;
                addSrcStmt = conn.prepareStatement("insert into bootstrap_applier_state (srcid,windowscn) values(?,?)");
                addSrcStmt.setInt(1, srcid);
                addSrcStmt.setLong(2, -1L);
                addSrcStmt.executeUpdate();
                addSrcStmt.close();
            }
            finally {
                DBHelper.close((Statement)addSrcStmt);
            }
            addSrcStmt = null;
            DBHelper.commit((Connection)conn);
            this.createNewSrcTable(srcid);
            this.createNewLogTable(srcid);
        }
        catch (SQLException e) {
            DBHelper.rollback((Connection)conn);
            DBHelper.close(addSrcStmt);
            LOG.error((Object)"Exception encountered while adding a new source for bootstrap tracking", (Throwable)e);
            throw e;
        }
    }

    public void createNewLogTable(int srcid) throws SQLException {
        Statement addLogTabStmt = null;
        Connection conn = this._bootstrapConn.getDBConn();
        try {
            String logTab = this._bootstrapConn.getLogTableNameToProduce(srcid);
            StringBuilder logTabSql = new StringBuilder();
            logTabSql.append("create table if not exists ");
            logTabSql.append(logTab);
            logTabSql.append(" ( id bigint NOT NULL auto_increment,");
            logTabSql.append(" scn bigint NOT NULL, ");
            logTabSql.append(" windowscn bigint NOT NULL, ");
            logTabSql.append(" srckey varchar(255) NOT NULL,");
            logTabSql.append(" val longblob, ");
            logTabSql.append(" PRIMARY KEY (id)) ENGINE=innodb");
            String sql = logTabSql.toString();
            addLogTabStmt = conn.prepareStatement(sql);
            addLogTabStmt.executeUpdate();
            LOG.info((Object)("Added a new log table for source : " + srcid));
        }
        catch (SQLException e) {
            LOG.error((Object)"Exception encountered while adding a new log table for source", (Throwable)e);
            throw e;
        }
        finally {
            if (null != addLogTabStmt) {
                addLogTabStmt.close();
                addLogTabStmt = null;
            }
        }
    }

    public void createNewSrcTable(int srcId) throws SQLException {
        Statement addSrcTabStmt = null;
        Connection conn = this._bootstrapConn.getDBConn();
        try {
            String srcTab = this._bootstrapConn.getSrcTableName(srcId);
            StringBuilder srcTabSql = new StringBuilder();
            srcTabSql.append("create table if not exists ");
            srcTabSql.append(srcTab);
            srcTabSql.append(" ( id bigint NOT NULL auto_increment,");
            srcTabSql.append(" scn bigint NOT NULL, ");
            srcTabSql.append(" srckey varchar(255) NOT NULL,");
            srcTabSql.append(" val longblob, ");
            srcTabSql.append(" PRIMARY KEY (id), UNIQUE KEY(srckey)) ENGINE=innodb");
            String sql = srcTabSql.toString();
            LOG.info((Object)("Table Creation Command :" + sql));
            addSrcTabStmt = conn.prepareStatement(sql);
            addSrcTabStmt.executeUpdate();
        }
        catch (SQLException e) {
            LOG.error((Object)("Exception encountered while adding a new Source table for source: " + e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            if (null != addSrcTabStmt) {
                addSrcTabStmt.close();
                addSrcTabStmt = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSourceInDB(String sourceName) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "select id from bootstrap_sources where src=?";
        int id = -1;
        try {
            stmt = this._bootstrapConn.getDBConn().prepareStatement("select id from bootstrap_sources where src=?");
            stmt.setString(1, sourceName);
            rs = stmt.executeQuery();
            if (rs.next()) {
                id = rs.getInt(1);
                this.dropSourceInDB(id);
            }
        }
        catch (Throwable throwable) {
            DBHelper.close(rs, (Statement)stmt, null);
            throw throwable;
        }
        DBHelper.close((ResultSet)rs, (Statement)stmt, null);
    }

    public void dropSourceInDB(int srcId) throws SQLException {
        String DELETE_SOURCES_ENTRY_PREFIX = "delete from bootstrap_sources where id = ";
        String DELETE_SEEDER_STATE_ENTRY_PREFIX = "delete from bootstrap_seeder_state where srcid = ";
        String DELETE_APPLIER_STATE_ENTRY_PREFIX = "delete from bootstrap_applier_state where srcid = ";
        String DELETE_PRODUCER_STATE_ENTRY_PREFIX = "delete from bootstrap_producer_state where srcid = ";
        String DELETE_LOGINFO_ENTRY_PREFIX = "delete from bootstrap_loginfo where srcid = ";
        String DELETE_MINSCN_ENTRY_PREFIX = "delete from bootstrap_tab_minscn where srcid = ";
        String DROP_TAB_TABLE_PREFIX = "drop table if exists tab_";
        String DROP_LOG_TABLE_PREFIX = "drop table if exists log_";
        List<Integer> logIds = this.getAllActiveLogIdsForSource(srcId);
        this._bootstrapConn.executeUpdate("delete from bootstrap_sources where id = " + srcId);
        this._bootstrapConn.executeUpdate("delete from bootstrap_seeder_state where srcid = " + srcId);
        this._bootstrapConn.executeUpdate("delete from bootstrap_applier_state where srcid = " + srcId);
        this._bootstrapConn.executeUpdate("delete from bootstrap_producer_state where srcid = " + srcId);
        this._bootstrapConn.executeUpdate("delete from bootstrap_loginfo where srcid = " + srcId);
        this._bootstrapConn.executeUpdate("delete from bootstrap_tab_minscn where srcid = " + srcId);
        for (Integer logId : logIds) {
            String drop = "drop table if exists log_" + srcId + "_" + logId;
            this._bootstrapConn.executeUpdate(drop);
        }
        this._bootstrapConn.executeUpdate("drop table if exists tab_" + srcId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getAllActiveLogIdsForSource(int srcId) throws SQLException {
        String SELECT_LOGINFO_ENTRY_PREFIX = "select logid from bootstrap_loginfo where deleted = 0 and srcid = ";
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<Integer> result = new ArrayList<Integer>();
        try {
            String sql = "select logid from bootstrap_loginfo where deleted = 0 and srcid = " + srcId;
            stmt = this._bootstrapConn.getDBConn().createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
        }
        catch (Throwable throwable) {
            DBHelper.close(rs, stmt, null);
            throw throwable;
        }
        DBHelper.close((ResultSet)rs, (Statement)stmt, null);
        return result;
    }

    public long getLogRowIdForSCN(long scn, int logid, int srcid) throws SQLException {
        String table = this._bootstrapConn.getLogTableName(logid, srcid);
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("select max(id) from ");
        queryBuilder.append(table);
        queryBuilder.append(" where scn < ");
        queryBuilder.append(scn);
        String sql = queryBuilder.toString();
        long rowId = this._bootstrapConn.executeQueryAndGetLong(sql, -1L);
        return rowId + 1L;
    }

    public List<SourceStatusInfo> getSourceIdAndStatusFromName(List<String> sourceList, boolean activeCheck) throws SQLException, BootstrapDatabaseTooOldException {
        ArrayList<SourceStatusInfo> srcInfo = new ArrayList<SourceStatusInfo>();
        try {
            for (String source : sourceList) {
                SourceStatusInfo pair = this.getSrcIdStatusFromDB(source, activeCheck);
                srcInfo.add(pair);
            }
        }
        catch (SQLException sqlEx) {
            LOG.error((Object)"Got Exception while getting Source Status", (Throwable)sqlEx);
            throw sqlEx;
        }
        return srcInfo;
    }

    int[] getSrcIds(List<SourceStatusInfo> srcList) {
        int[] srcIds = new int[srcList.size()];
        int i = 0;
        for (SourceStatusInfo srcStatus : srcList) {
            srcIds[i++] = srcStatus.getSrcId();
        }
        return srcIds;
    }

    public List<SourceStatusInfo> getSrcStatusInfoFromDB() throws SQLException, BootstrapDatabaseTooOldException {
        int srcid = -1;
        int status = 1;
        ResultSet rs = null;
        Connection conn = this._bootstrapConn.getDBConn();
        Statement stmt = conn.createStatement();
        ArrayList<SourceStatusInfo> srcInfo = new ArrayList<SourceStatusInfo>();
        try {
            String sql = "SELECT id, src, status from bootstrap_sources ";
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                srcid = rs.getInt(1);
                String src = rs.getString(2);
                status = rs.getInt(3);
                srcInfo.add(new SourceStatusInfo(src, srcid, status));
            }
        }
        catch (SQLException e) {
            LOG.error((Object)"Error encountered while selecting source id from bootstrap:", (Throwable)e);
            throw e;
        }
        finally {
            DBHelper.close((ResultSet)rs, (Statement)stmt, null);
        }
        return srcInfo;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SourceStatusInfo getSrcIdStatusFromDB(String source, boolean activeCheck) throws SQLException, BootstrapDatabaseTooOldException {
        int srcid = -1;
        int status = 1;
        PreparedStatement getSrcStmt = null;
        ResultSet rs = null;
        Connection conn = this._bootstrapConn.getDBConn();
        SourceStatusInfo srcIdStatusPair = null;
        try {
            getSrcStmt = conn.prepareStatement("SELECT id, status from bootstrap_sources where src = ?");
            getSrcStmt.setString(1, source);
            rs = getSrcStmt.executeQuery();
            if (rs.next()) {
                srcid = rs.getInt(1);
                status = rs.getInt(2);
            }
            srcIdStatusPair = new SourceStatusInfo(source, srcid, status);
            if (activeCheck) {
                this.validateStatus(source, status);
            }
        }
        catch (SQLException e) {
            try {
                LOG.error((Object)"Error encountered while selecting source id from bootstrap:", (Throwable)e);
                throw e;
                catch (BootstrapDatabaseTooOldException bde) {
                    LOG.error((Object)"Error encountered while selecting source id from bootstrap:", (Throwable)bde);
                    throw bde;
                }
            }
            catch (Throwable throwable) {
                DBHelper.close(rs, (Statement)getSrcStmt, null);
                throw throwable;
            }
        }
        DBHelper.close((ResultSet)rs, (Statement)getSrcStmt, null);
        return srcIdStatusPair;
    }

    private void validateStatus(String source, int status) throws BootstrapDatabaseTooOldException {
        switch (status) {
            case 4: {
                return;
            }
            case 6: {
                throw new BootstrapDatabaseTooOldException("The bootstrap database for source :" + source + " is too old!");
            }
            case 2: {
                throw new BootstrapDatabaseTooOldException("The bootstrap database for source :" + source + " is being seeded!");
            }
            case 3: {
                throw new BootstrapDatabaseTooOldException("The bootstrap database for source :" + source + " is seeded but not yet consistent!");
            }
            case 5: {
                throw new BootstrapDatabaseTooOldException("Bootstrapping for source :" + source + " is disabled");
            }
        }
    }

    public long getMinWindowSCNFromStateTable(List<String> sourceNames, String table) throws SQLException, BootstrapDBException {
        ArrayList<Integer> srcIdList = new ArrayList<Integer>();
        if (null == sourceNames || sourceNames.isEmpty()) {
            String msg = "SourceNames is empty for getMinWindowSCNFromStateTable !!";
            LOG.error((Object)msg);
            throw new BootstrapDBException(msg);
        }
        for (String s : sourceNames) {
            SourceStatusInfo info = this.getSrcIdStatusFromDB(s, false);
            if (info.getSrcId() < 0) {
                String msg = "Unable to determine sourceId for sourceName :" + s + " Source List is :" + sourceNames;
                LOG.error((Object)msg);
                throw new BootstrapDBException(msg);
            }
            srcIdList.add(info.getSrcId());
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select min(windowscn) from ");
        sql.append(table);
        sql.append(" where srcid in (");
        int count = srcIdList.size();
        for (Integer id : srcIdList) {
            sql.append(id);
            if (--count <= 0) continue;
            sql.append(",");
        }
        sql.append(")");
        return this._bootstrapConn.executeQueryAndGetLong(sql.toString(), -1L);
    }

    String arrayToString(int[] ids) {
        StringBuilder idBuilder = new StringBuilder();
        for (int id : ids) {
            if (idBuilder.length() > 0) {
                idBuilder.append(',');
            }
            idBuilder.append(id);
        }
        return idBuilder.toString();
    }

    public long getMinWindowScnFromSnapshot(int srcid, int tabRid, int timeoutInSec) throws SQLException {
        long minScn = -1L;
        if (tabRid >= 0) {
            String sql = "select min(scn) from tab_" + srcid + " where id <= " + tabRid;
            LOG.info((Object)("Executing min scn query from snapshot table : " + sql));
            minScn = this._bootstrapConn.executeQuerySafe(sql, -1L, timeoutInSec);
            LOG.info((Object)("Finished executing min scn query from snapshot table : minScn= " + minScn));
        }
        return minScn;
    }

    public long getMinScnOfSnapshots(List<SourceStatusInfo> srcStatusList) throws SQLException {
        return this.getMinScnOfSnapshots(this.getSrcIds(srcStatusList));
    }

    public long getMinScnOfSnapshots(int ... srcIds) throws SQLException {
        String minScnQuery = "select max(minscn) from bootstrap_tab_minscn where srcid in (" + this.arrayToString(srcIds) + ")";
        long minScn = this._bootstrapConn.executeQuerySafe(minScnQuery, -1L, 0);
        if (minScn == -1L) {
            LOG.warn((Object)("srcid=" + Arrays.toString(srcIds) + " had no entry in bootstrap_tab_minscn. Returning " + -1L));
        }
        return minScn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesMinScnTableExist() throws SQLException {
        Connection conn = this._bootstrapConn.getDBConn();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean exists = false;
        try {
            String query = "select table_name from  information_schema.tables where table_schema=? and table_name=?";
            stmt = conn.prepareStatement("select table_name from  information_schema.tables where table_schema=? and table_name=?");
            stmt.setString(1, this._dbName);
            stmt.setString(2, MIN_SCN_TABLE_NAME);
            rs = stmt.executeQuery();
            exists = rs.next();
        }
        catch (SQLException e) {
            try {
                LOG.warn((Object)("Error! " + e.getMessage()));
            }
            catch (Throwable throwable) {
                DBHelper.close(rs, (Statement)stmt, null);
                throw throwable;
            }
            DBHelper.close((ResultSet)rs, (Statement)stmt, null);
        }
        DBHelper.close((ResultSet)rs, (Statement)stmt, null);
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSeeded(int srcId) throws SQLException {
        Connection conn = this._bootstrapConn.getDBConn();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean seeded = false;
        try {
            String query = "select srcid from bootstrap_seeder_state where srcid=?";
            stmt = conn.prepareStatement(query);
            stmt.setInt(1, srcId);
            rs = stmt.executeQuery();
            seeded = rs.next();
        }
        catch (Throwable throwable) {
            DBHelper.close(rs, (Statement)stmt, null);
            throw throwable;
        }
        DBHelper.close((ResultSet)rs, (Statement)stmt, null);
        return seeded;
    }

    public long getMinScnFromLogTable(int srcId, boolean purged) throws SQLException {
        String minScnQuery = purged ? "select min(minwindowscn) from bootstrap_loginfo where deleted=0 and srcid=" + srcId : "select min(minwindowscn) from bootstrap_loginfo where srcid=" + srcId;
        long minScn = this._bootstrapConn.executeQuerySafe(minScnQuery, -1L, 0);
        if (minScn == -1L) {
            LOG.warn((Object)("srcid=" + srcId + " had no entry in undeleted log tables. Returning " + minScn));
        }
        return minScn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMinScnOfSnapshot(int srcId, long scn) throws SQLException {
        Connection conn = this._bootstrapConn.getDBConn();
        PreparedStatement stmt = null;
        try {
            StringBuilder minScnQuery = new StringBuilder();
            minScnQuery.append("insert into bootstrap_tab_minscn (srcid,minscn) values (?,?) ");
            minScnQuery.append(" on duplicate key update minscn=?");
            stmt = conn.prepareStatement(minScnQuery.toString());
            stmt.setInt(1, srcId);
            stmt.setLong(2, scn);
            stmt.setLong(3, scn);
            stmt.executeUpdate();
            DBHelper.commit((Connection)conn);
            LOG.info((Object)("Set minScn for tab_" + srcId + " to " + scn));
        }
        catch (Throwable throwable) {
            DBHelper.close(stmt);
            throw throwable;
        }
        DBHelper.close((Statement)stmt);
    }

    public void updateRowOfSeederState(String sourceName, long rowId) throws SQLException, BootstrapDatabaseTooOldException {
        SourceStatusInfo srcInfo = this.getSrcIdStatusFromDB(sourceName, false);
        this.updateRowOfSeederState(srcInfo.getSrcId(), rowId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRowOfSeederState(int srcId, long rowId) throws SQLException {
        Connection conn = this._bootstrapConn.getDBConn();
        PreparedStatement stmt = null;
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("insert into bootstrap_seeder_state (srcid,rid,srckey) ");
            sql.append("values (?,?,'')");
            sql.append("on duplicate key update rid = ?");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setInt(1, srcId);
            stmt.setLong(2, rowId);
            stmt.setLong(3, rowId);
            stmt.executeUpdate();
            DBHelper.commit((Connection)conn);
        }
        catch (Throwable throwable) {
            DBHelper.close(stmt);
            throw throwable;
        }
        DBHelper.close((Statement)stmt);
    }

    public int getLogIdToCatchup(int srcId, long sinceScn) throws SQLException, BootstrapProcessingException {
        int logid = -1;
        int deleted = 0;
        Connection conn = this._bootstrapConn.getDBConn();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (0L >= sinceScn) {
                stmt = conn.prepareStatement("select logid, deleted from bootstrap_loginfo where srcid = ? and minwindowscn = (select min(minwindowscn) from bootstrap_loginfo where srcid = ? and deleted != 1 and minwindowscn >= 0)  order by logid asc limit 1");
                stmt.setInt(1, srcId);
                stmt.setInt(2, srcId);
            } else {
                stmt = conn.prepareStatement("SELECT logid, deleted from bootstrap_loginfo where srcid = ? and minwindowscn <= ? and maxwindowscn >= ? order by logid asc limit 1");
                stmt.setInt(1, srcId);
                stmt.setLong(2, sinceScn);
                stmt.setLong(3, sinceScn);
            }
            rs = stmt.executeQuery();
            if (rs.next()) {
                logid = rs.getInt(1);
                deleted = rs.getInt(2);
                LOG.info((Object)("logid for catchup:" + logid + ", Deleted :" + deleted));
            }
            if (0 > logid || 1 == deleted) {
                throw new BootstrapProcessingException("Log file with logid=" + logid + " ,srcid=" + srcId + " is either deleted or not found in bootstrap_loginfo for since scn: " + sinceScn);
            }
        }
        catch (SQLException e) {
            try {
                LOG.error((Object)"Error encountered while selecting logid from bootstrap_loginfo", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                DBHelper.close(rs, stmt, null);
                throw throwable;
            }
        }
        DBHelper.close((ResultSet)rs, (Statement)stmt, null);
        return logid;
    }

    public BootstrapConn getBootstrapConn() {
        return this._bootstrapConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, SourceInfo> getDBTrackedSources(Set<String> configedSources) throws SQLException, DatabusException {
        Map<String, SourceInfo> map;
        StringBuilder sql = new StringBuilder();
        sql.append("select s.src, s.id, p.logid, p.rid, l.minwindowscn, l.maxwindowscn, s.status ");
        sql.append("from bootstrap_sources s, bootstrap_producer_state p, bootstrap_loginfo l ");
        sql.append("where p.srcid = s.id and p.srcid = l.srcid and p.logid = l.logid");
        SourceInfoResultHandler handler = new SourceInfoResultHandler(configedSources);
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        Connection conn = this._bootstrapConn.getDBConn();
        try {
            preparedStatement = conn.prepareStatement(sql.toString());
            rs = preparedStatement.executeQuery();
            if (rs == null) {
                throw new DatabusException("No sources to track in this bootstrap producer. ResultSet is null");
            }
            while (rs.next()) {
                handler.processRow(rs);
            }
            DBHelper.commit((Connection)conn);
            map = handler.getTrackedSources();
        }
        catch (Throwable throwable) {
            DBHelper.close(rs, (Statement)preparedStatement, null);
            throw throwable;
        }
        DBHelper.close((ResultSet)rs, (Statement)preparedStatement, null);
        return map;
    }

    public void initMetadataTables(List<String> registeredSources) throws SQLException {
        this.deleteExistingMetaTables();
        this.insertAllSources(registeredSources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteExistingMetaTables() throws SQLException {
        StringBuilder deleteBootstraSourcesSql = new StringBuilder();
        deleteBootstraSourcesSql.append("delete from bootstrap_sources");
        PreparedStatement preparedStatement = null;
        Connection conn = this._bootstrapConn.getDBConn();
        try {
            preparedStatement = conn.prepareStatement(deleteBootstraSourcesSql.toString());
            preparedStatement.executeUpdate();
            DBHelper.commit((Connection)conn);
        }
        catch (Throwable throwable) {
            DBHelper.close(preparedStatement);
            throw throwable;
        }
        DBHelper.close((Statement)preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertAllSources(List<String> registeredSources) throws SQLException {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("insert into bootstrap_sources (src, status) values (?, 0)");
        PreparedStatement preparedStatement = null;
        Connection conn = this._bootstrapConn.getDBConn();
        try {
            preparedStatement = conn.prepareStatement(insertSql.toString());
            for (int i = 0; i < registeredSources.size(); ++i) {
                preparedStatement.setString(1, registeredSources.get(i));
                preparedStatement.execute();
            }
            DBHelper.commit((Connection)conn);
        }
        catch (Throwable throwable) {
            DBHelper.close(preparedStatement);
            throw throwable;
        }
        DBHelper.close((Statement)preparedStatement);
    }

    public void close() {
        this._bootstrapConn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSourcesStatus(Set<String> registeredSources, int status) throws SQLException {
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update bootstrap_sources set status = ? where src = ?");
        PreparedStatement preparedStatement = null;
        Connection conn = this._bootstrapConn.getDBConn();
        try {
            preparedStatement = conn.prepareStatement(updateSql.toString());
            for (String src : registeredSources) {
                preparedStatement.setInt(1, status);
                preparedStatement.setString(2, src);
                preparedStatement.executeUpdate();
            }
            DBHelper.commit((Connection)conn);
        }
        catch (Throwable throwable) {
            DBHelper.close(preparedStatement);
            throw throwable;
        }
        DBHelper.close((Statement)preparedStatement);
    }

    static class SourceInfoResultHandler {
        private final Set<String> _configedSources;
        private final Map<String, SourceInfo> _trackedSources;

        public SourceInfoResultHandler(Set<String> configedSources) {
            this._configedSources = configedSources;
            this._trackedSources = new HashMap<String, SourceInfo>();
        }

        public void processRow(ResultSet rs) throws SQLException {
            String src = rs.getString(1);
            if (this._configedSources.contains(src)) {
                SourceInfo info = new SourceInfo(rs.getInt(2), rs.getInt(3), rs.getInt(4), rs.getLong(5), rs.getLong(6), rs.getInt(7));
                this._trackedSources.put(src, info);
                LOG.info((Object)("SourceInfo :" + src + " :" + info));
            }
        }

        public Map<String, SourceInfo> getTrackedSources() {
            return this._trackedSources;
        }
    }

    public static class SourceStatusInfo {
        private int srcId;
        private String srcName;
        private int status;

        public String getSrcName() {
            return this.srcName;
        }

        public void setSrcName(String srcName) {
            this.srcName = srcName;
        }

        public int getSrcId() {
            return this.srcId;
        }

        public void setSrcId(int srcId) {
            this.srcId = srcId;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public SourceStatusInfo(String srcName, int srcId, int status) {
            this.srcName = srcName;
            this.srcId = srcId;
            this.status = status;
        }

        public SourceStatusInfo() {
            this.srcName = null;
            this.srcId = -1;
            this.status = -1;
        }

        public boolean isValidSource() {
            return this.srcId >= 0;
        }

        public String toString() {
            return "SourceStatusInfo [srcId=" + this.srcId + ", srcName=" + this.srcName + ", status=" + this.status + "]";
        }
    }
}

