/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.common;

import com.linkedin.databus.bootstrap.common.BootstrapCleanerStaticConfig;
import com.linkedin.databus.bootstrap.common.BootstrapDBCleanerQueryHelper;
import com.linkedin.databus.bootstrap.common.BootstrapDBRow;
import com.linkedin.databus.bootstrap.common.BootstrapLogInfo;
import com.linkedin.databus.core.DatabusRuntimeException;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusEventFactory;
import com.linkedin.databus.core.DbusEventInternalReadable;
import com.linkedin.databus2.util.DBHelper;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class BootstrapDBCleanerQueryExecutor {
    public static final String MODULE = BootstrapDBCleanerQueryExecutor.class.getName();
    public final Logger LOG;
    private final String _name;
    private final Connection _conn;
    private final BootstrapDBCleanerQueryHelper _bootstrapDBCleanerQueryHelper;

    public BootstrapDBCleanerQueryExecutor(String name, Connection conn, BootstrapDBCleanerQueryHelper bootstrapDBCleanerQueryHelper) {
        this._name = name;
        this.LOG = Logger.getLogger((String)(MODULE + "." + name));
        if (null == conn) {
            throw new DatabusRuntimeException("Invalid to pass in a null connection object");
        }
        this._conn = conn;
        if (null == bootstrapDBCleanerQueryHelper) {
            throw new DatabusRuntimeException("Invalid to pass in a null for bootstrapDBCleanerQueryHelper");
        }
        this._bootstrapDBCleanerQueryHelper = bootstrapDBCleanerQueryHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BootstrapLogInfo getThresholdWindowSCN(BootstrapCleanerStaticConfig.BootstrapDBType type, int srcId) throws SQLException {
        PreparedStatement stmt;
        ResultSet rs;
        BootstrapLogInfo logInfo;
        block7: {
            BootstrapLogInfo bootstrapLogInfo;
            String sql = null;
            switch (type) {
                case BOOTSTRAP_CATCHUP_APPLIER_NOT_RUNNING: {
                    sql = this.getMinProducerSCNLogStmt(srcId);
                    break;
                }
                case BOOTSTRAP_CATCHUP_APPLIER_RUNNING: 
                case BOOTSTRAP_FULL: {
                    sql = this.getMinApplierSCNLogStmt(srcId);
                }
            }
            this.LOG.info((Object)("Threshold WindowScn fetch Query :" + sql));
            logInfo = new BootstrapLogInfo();
            rs = null;
            stmt = null;
            try {
                stmt = this._conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                if (rs.next()) break block7;
                this.LOG.error((Object)("SQL :(" + sql + ") returned empty records"));
                bootstrapLogInfo = null;
            }
            catch (Throwable throwable) {
                DBHelper.close(rs, (Statement)stmt, null);
                throw throwable;
            }
            DBHelper.close((ResultSet)rs, (Statement)stmt, null);
            return bootstrapLogInfo;
        }
        logInfo.setLogId(rs.getInt(1));
        logInfo.setSrcId(rs.getShort(2));
        logInfo.setMinWindowSCN(rs.getLong(3));
        logInfo.setMaxWindowSCN(rs.getLong(3));
        DBHelper.close((ResultSet)rs, (Statement)stmt, null);
        return logInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BootstrapLogInfo getFirstLogTableWithGreaterSCN(short srcId, long windowSCN) throws SQLException {
        BootstrapLogInfo logInfo;
        PreparedStatement stmt;
        ResultSet rs;
        block3: {
            BootstrapLogInfo bootstrapLogInfo;
            String sql = this._bootstrapDBCleanerQueryHelper.getFirstLogTableWithGreaterSCNStmt();
            rs = null;
            stmt = null;
            logInfo = new BootstrapLogInfo();
            try {
                stmt = this._conn.prepareStatement(sql);
                stmt.setShort(1, srcId);
                stmt.setLong(2, windowSCN);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    logInfo.setSrcId(srcId);
                    logInfo.setLogId(rs.getInt(1));
                    logInfo.setMinWindowSCN(rs.getLong(2));
                    logInfo.setMaxWindowSCN(rs.getLong(3));
                    break block3;
                }
                bootstrapLogInfo = null;
            }
            catch (Throwable throwable) {
                DBHelper.close(rs, (Statement)stmt, null);
                throw throwable;
            }
            DBHelper.close((ResultSet)rs, (Statement)stmt, null);
            return bootstrapLogInfo;
        }
        DBHelper.close((ResultSet)rs, (Statement)stmt, null);
        return logInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BootstrapLogInfo> getCandidateLogsInfo(long windowSCN, short srcId) throws SQLException {
        ArrayList<BootstrapLogInfo> logsInfo = new ArrayList<BootstrapLogInfo>();
        String sql = this._bootstrapDBCleanerQueryHelper.getCandidateLogIdsForSrcStmt();
        this.LOG.info((Object)("SQL statement for fetching candidate logIds :" + sql));
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            stmt = this._conn.prepareStatement(sql);
            stmt.setShort(1, srcId);
            stmt.setLong(2, windowSCN);
            stmt.setShort(3, srcId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                BootstrapLogInfo logInfo = new BootstrapLogInfo();
                logInfo.setSrcId(srcId);
                logInfo.setLogId(rs.getInt(1));
                logInfo.setMinWindowSCN(rs.getLong(2));
                logInfo.setMaxWindowSCN(rs.getLong(3));
                logsInfo.add(logInfo);
            }
        }
        catch (Throwable throwable) {
            DBHelper.close(rs, (Statement)stmt, null);
            throw throwable;
        }
        DBHelper.close((ResultSet)rs, (Statement)stmt, null);
        return logsInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSource(BootstrapLogInfo logInfo) throws SQLException {
        this.LOG.info((Object)("Updating logStartSCN to " + logInfo.getMinWindowSCN() + " for srcid :" + logInfo.getSrcId()));
        String sql = this._bootstrapDBCleanerQueryHelper.getUpdateLogStartSCNStmt();
        PreparedStatement stmt = null;
        try {
            stmt = this._conn.prepareStatement(sql);
            stmt.setLong(1, logInfo.getMinWindowSCN());
            stmt.setShort(2, logInfo.getSrcId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBHelper.close(stmt);
            throw throwable;
        }
        DBHelper.close((Statement)stmt);
    }

    public List<BootstrapLogInfo> dropTables(List<BootstrapLogInfo> logsInfo) {
        ArrayList<BootstrapLogInfo> deletedLogsInfo = new ArrayList<BootstrapLogInfo>();
        for (BootstrapLogInfo logInfo : logsInfo) {
            try {
                this.dropTable(logInfo);
                deletedLogsInfo.add(logInfo);
            }
            catch (SQLException ex) {
                this.LOG.error((Object)("Unable to delete log table :" + logInfo.getLogTable()), (Throwable)ex);
            }
        }
        return deletedLogsInfo;
    }

    /*
     * Exception decompiling
     */
    public List<BootstrapLogInfo> markDeleted(List<BootstrapLogInfo> logsInfo) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long getNanoTimestampOfLastEventinLog(BootstrapLogInfo logInfo, DbusEventFactory eventFactory) throws SQLException {
        long nanoTimestamp = Long.MAX_VALUE;
        BootstrapDBRow r = this.getLastEventinLog(logInfo, eventFactory);
        if (null != r && null != r.getEvent()) {
            nanoTimestamp = r.getEvent().timestampInNanos();
        }
        return nanoTimestamp;
    }

    public long getSCNOfLastEventinLog(BootstrapLogInfo logInfo, DbusEventFactory eventFactory) throws SQLException {
        long scn = -1L;
        BootstrapDBRow r = this.getLastEventinLog(logInfo, eventFactory);
        if (null != r) {
            scn = r.getScn();
        }
        return scn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BootstrapDBRow getLastEventinLog(BootstrapLogInfo logInfo, DbusEventFactory eventFactory) throws SQLException {
        DbusEventInternalReadable event;
        String key;
        long scn;
        long id;
        ResultSet rs;
        Statement stmt;
        block3: {
            stmt = null;
            rs = null;
            id = -1L;
            scn = -1L;
            key = null;
            event = null;
            try {
                String tableName = logInfo.getLogTable();
                StringBuilder sql = new StringBuilder();
                sql.append("select id, srckey, scn, val from ");
                sql.append(tableName);
                sql.append(" where id = ( select max(id) from ");
                sql.append(tableName);
                sql.append(" )");
                stmt = this._conn.createStatement();
                rs = stmt.executeQuery(sql.toString());
                if (rs.next()) {
                    int i = 1;
                    id = rs.getLong(i++);
                    String srcKey = rs.getString(i++);
                    scn = rs.getLong(i++);
                    ByteBuffer tmpBuffer = ByteBuffer.wrap(rs.getBytes(i));
                    this.LOG.info((Object)("BUFFER SIZE:" + tmpBuffer.limit()));
                    event = eventFactory.createReadOnlyDbusEventFromBuffer(tmpBuffer, tmpBuffer.position());
                    this.LOG.info((Object)("Last Row for log (" + logInfo + ") - ID :" + id + ", srcKey :" + srcKey + ", SCN :" + scn + ", Event :" + event.toString()));
                    break block3;
                }
                this.LOG.error((Object)("No ResultSet for query :" + sql.toString()));
            }
            catch (Throwable throwable) {
                DBHelper.close(rs, stmt, null);
                throw throwable;
            }
        }
        DBHelper.close((ResultSet)rs, (Statement)stmt, null);
        return new BootstrapDBRow(id, key, scn, (DbusEvent)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTable(BootstrapLogInfo logInfo) throws SQLException {
        String tableName = logInfo.getLogTable();
        String cmd = "drop table if exists " + tableName;
        Statement stmt = null;
        try {
            this.LOG.info((Object)("Dropping table :" + tableName));
            stmt = this._conn.createStatement();
            stmt.executeUpdate(cmd);
        }
        catch (Throwable throwable) {
            DBHelper.close(stmt);
            throw throwable;
        }
        DBHelper.close((Statement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int optimizeTable(String tableName) throws SQLException {
        String cmd = "optimize table " + tableName;
        PreparedStatement stmt = null;
        int ret = -1;
        try {
            this.LOG.info((Object)("Optimizing table :" + tableName + ", CMD :(" + cmd + ")"));
            stmt = this._conn.prepareStatement(cmd);
            ret = stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBHelper.close(stmt);
            throw throwable;
        }
        DBHelper.close((Statement)stmt);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteTable(String tableName, long scn) throws SQLException {
        String cmd = "delete from " + tableName + " where scn <= ?";
        int ret = -1;
        if (scn <= 0L) {
            this.LOG.info((Object)("Trying to delete rows whose scn <=" + scn + ", skipping !!"));
            return ret;
        }
        PreparedStatement stmt = null;
        try {
            this.LOG.info((Object)("Deleting events from table :" + tableName + ", CMD :(" + cmd + "), SCN :" + scn));
            stmt = this._conn.prepareStatement(cmd);
            stmt.setLong(1, scn);
            ret = stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBHelper.close(stmt);
            throw throwable;
        }
        DBHelper.close((Statement)stmt);
        return ret;
    }

    private String getMinApplierSCNLogStmt(int srcId) {
        StringBuilder sql = new StringBuilder();
        sql.append("select logid,srcid,windowscn from bootstrap_applier_state ");
        sql.append("where srcid=");
        sql.append(srcId);
        sql.append(" order by windowscn asc limit 1");
        return sql.toString();
    }

    private String getMinProducerSCNLogStmt(int srcId) {
        StringBuilder sql = new StringBuilder();
        sql.append("select logid,srcid,windowscn from bootstrap_producer_state ");
        sql.append("where srcid=");
        sql.append(srcId);
        sql.append(" order by windowscn asc limit 1");
        return sql.toString();
    }
}

