/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.common;

import com.linkedin.databus2.util.DBHelper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class BootstrapConn {
    private Connection _bootstrapConn = null;
    private String _url;
    private boolean _autoCommit;
    private int _isolationLevel;
    private PreparedStatement _maxridStmt;
    public static final String MODULE = BootstrapConn.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private static final String MAXRID_QUERY = "select maxrid from bootstrap_loginfo where srcid = ? and logid = ?";

    public Connection getDBConn() throws SQLException {
        if (null == this._bootstrapConn || this._bootstrapConn.isClosed()) {
            this.createNewBootstrapConnection();
        }
        return this._bootstrapConn;
    }

    public String getSrcTableName(int srcId) {
        return "tab_" + srcId;
    }

    public String getLogTableNameToProduce(int srcId) throws SQLException {
        return "log_" + srcId + "_" + this.getProducerLogId(srcId);
    }

    public String getLogTableNameToApply(int srcId) throws SQLException {
        return "log_" + srcId + "_" + this.getApplyLogId(srcId);
    }

    public String getLogTableName(int logId, int srcId) {
        return "log_" + srcId + "_" + logId;
    }

    private int getLogId(int srcId, String tab) throws SQLException {
        int logid = -1;
        Connection conn = this.getDBConn();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT logid from " + tab + " where srcid = ?");
            stmt.setInt(1, srcId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                logid = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                LOG.error((Object)("Error encountered while selecting logid from " + tab), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                DBHelper.close(rs, stmt, null);
                throw throwable;
            }
        }
        DBHelper.close((ResultSet)rs, (Statement)stmt, null);
        return logid;
    }

    private int getProducerLogId(int srcId) throws SQLException {
        return this.getLogId(srcId, "bootstrap_producer_state");
    }

    private int getApplyLogId(int srcId) throws SQLException {
        return this.getLogId(srcId, "bootstrap_applier_state");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long executeQueryAndGetLong(String query, long defaultVal) throws SQLException {
        Statement stmt = null;
        Connection conn = this.getDBConn();
        ResultSet rs = null;
        long res = defaultVal;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(query);
            if (rs.next()) {
                res = rs.getLong(1);
            }
        }
        catch (Throwable throwable) {
            DBHelper.close(rs, (Statement)stmt, null);
            throw throwable;
        }
        DBHelper.close((ResultSet)rs, (Statement)stmt, null);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long executeQuerySafe(String query, long defaultVal, int timeoutSeconds) throws SQLException {
        long res;
        ResultSet rs;
        Statement stmt;
        block5: {
            stmt = null;
            Connection conn = this.getDBConn();
            rs = null;
            res = defaultVal;
            try {
                stmt = conn.createStatement();
                if (timeoutSeconds > 0) {
                    stmt.setQueryTimeout(timeoutSeconds);
                }
                if (!(rs = stmt.executeQuery(query)).next()) break block5;
                res = rs.getLong(1);
                if (!rs.wasNull()) break block5;
                res = defaultVal;
            }
            catch (SQLException e) {
                try {
                    LOG.warn((Object)("Error executing query : " + query + " Exception=" + e.getMessage()));
                    LOG.warn((Object)("Returning default value: " + defaultVal));
                }
                catch (Throwable throwable) {
                    DBHelper.close(rs, (Statement)stmt, null);
                    throw throwable;
                }
                DBHelper.close((ResultSet)rs, (Statement)stmt, null);
            }
        }
        DBHelper.close((ResultSet)rs, (Statement)stmt, null);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeDDL(String sql) throws SQLException {
        Statement stmt = null;
        LOG.info((Object)("Executing DDL command :" + sql));
        try {
            stmt = this._bootstrapConn.createStatement();
            int rs = stmt.executeUpdate(sql);
            DBHelper.commit((Connection)this._bootstrapConn);
            LOG.info((Object)("Executed Commmand (" + sql + ") with result " + rs));
        }
        catch (SQLException s) {
            DBHelper.rollback((Connection)this._bootstrapConn);
        }
        finally {
            DBHelper.close((Statement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(String sql) throws SQLException {
        Statement stmt = null;
        LOG.info((Object)("Executing update command :" + sql));
        try {
            stmt = this._bootstrapConn.createStatement();
            int rs = stmt.executeUpdate(sql);
            DBHelper.commit((Connection)this._bootstrapConn);
            LOG.info((Object)("Executed Commmand (" + sql + ") with result " + rs));
        }
        catch (SQLException s) {
            DBHelper.rollback((Connection)this._bootstrapConn);
        }
        finally {
            DBHelper.close((Statement)stmt);
        }
    }

    public void initBootstrapConn(boolean autoCommit, int isolationLevel, String userName, String password, String hostName, String dbName) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        StringBuilder urlStr = new StringBuilder();
        urlStr.append("jdbc:mysql://" + hostName);
        if (null != dbName) {
            urlStr.append("/" + dbName);
        }
        urlStr.append("?user=").append(userName).append("&password=").append(password);
        this._url = urlStr.toString();
        this._autoCommit = autoCommit;
        this._isolationLevel = isolationLevel;
        Class.forName("com.mysql.jdbc.Driver").newInstance();
        this.createNewBootstrapConnection();
    }

    private void createNewBootstrapConnection() throws SQLException {
        this._bootstrapConn = DriverManager.getConnection(this._url);
        this._bootstrapConn.setAutoCommit(this._autoCommit);
        this._bootstrapConn.setTransactionIsolation(this._isolationLevel);
    }

    public void initBootstrapConn(boolean autoCommit, String userName, String password, String hostName, String dbName) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        this.initBootstrapConn(autoCommit, 4, userName, password, hostName, dbName);
    }

    public void recreateConnection() throws SQLException {
        this.close();
        this.createNewBootstrapConnection();
    }

    public void close() {
        DBHelper.close((Connection)this._bootstrapConn);
        this._bootstrapConn = null;
    }

    public void executeDummyBootstrapDBQuery() throws SQLException {
        ResultSet rs = null;
        Statement stmt = null;
        String query = "select * from bootstrap_sources";
        try {
            stmt = this._bootstrapConn.createStatement();
            rs = stmt.executeQuery(query);
            while (rs.next()) {
            }
        }
        catch (SQLException ex) {
            try {
                LOG.error((Object)("Got Exception when executing dummy Query :" + query), (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                DBHelper.close(rs, (Statement)stmt, null);
                throw throwable;
            }
        }
        DBHelper.close((ResultSet)rs, (Statement)stmt, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxRowIdForLog(int logid, int srcid) throws SQLException {
        long maxrid = 0L;
        if (null == this._maxridStmt) {
            this._maxridStmt = this.getDBConn().prepareStatement(MAXRID_QUERY);
        }
        this._maxridStmt.setInt(1, srcid);
        this._maxridStmt.setInt(2, logid);
        ResultSet rs = null;
        try {
            rs = this._maxridStmt.executeQuery();
            if (rs.next()) {
                maxrid = rs.getLong(1);
            }
        }
        finally {
            DBHelper.close((ResultSet)rs);
        }
        return maxrid;
    }
}

