/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.common;

import com.linkedin.databus.bootstrap.common.BootstrapCleanerStaticConfig;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import java.util.HashMap;
import java.util.Map;

public class BootstrapCleanerConfig
implements ConfigBuilder<BootstrapCleanerStaticConfig> {
    private boolean enable = true;
    private Map<String, RetentionConfig> retentionOverride = new HashMap<String, RetentionConfig>();
    private RetentionConfig retentionDefault = new RetentionConfig();
    private Map<String, String> bootstrapTypeOverride = new HashMap<String, String>();
    private String bootstrapTypeDefault = BootstrapCleanerStaticConfig.BootstrapDBType.BOOTSTRAP_FULL.toString();
    private Map<String, Boolean> enableOptimizeTable = new HashMap<String, Boolean>();
    private Boolean enableOptimizeTableDefault = Boolean.FALSE;
    private Map<String, Boolean> enableForceTabTableCleanup = new HashMap<String, Boolean>();
    private Boolean enableForceTabTableCleanupDefault = Boolean.FALSE;
    private DiskSpaceTriggerConfigBuilder diskSpaceTrigger = new DiskSpaceTriggerConfigBuilder();
    private PeriodicTriggerConfigBuilder periodicTrigger = new PeriodicTriggerConfigBuilder();

    public BootstrapCleanerStaticConfig build() throws InvalidConfigException {
        HashMap<String, BootstrapCleanerStaticConfig.RetentionStaticConfig> retOverrides = new HashMap<String, BootstrapCleanerStaticConfig.RetentionStaticConfig>();
        for (Map.Entry<String, RetentionConfig> e : this.retentionOverride.entrySet()) {
            retOverrides.put(e.getKey(), e.getValue().build());
        }
        HashMap<String, BootstrapCleanerStaticConfig.BootstrapDBType> bsTypeOverrides = new HashMap<String, BootstrapCleanerStaticConfig.BootstrapDBType>();
        for (Map.Entry<String, String> e : this.bootstrapTypeOverride.entrySet()) {
            bsTypeOverrides.put(e.getKey(), BootstrapCleanerStaticConfig.BootstrapDBType.valueOf(e.getValue()));
        }
        return new BootstrapCleanerStaticConfig(retOverrides, this.retentionDefault.build(), bsTypeOverrides, BootstrapCleanerStaticConfig.BootstrapDBType.valueOf(this.bootstrapTypeDefault), this.enableOptimizeTable, this.enableOptimizeTableDefault, this.enableForceTabTableCleanup, this.enableForceTabTableCleanupDefault, this.enable, this.diskSpaceTrigger.build(), this.periodicTrigger.build());
    }

    public RetentionConfig getRetentionOverride(String source) {
        RetentionConfig r = this.retentionOverride.get(source);
        if (null == r) {
            r = new RetentionConfig();
            this.retentionOverride.put(source, r);
        }
        return r;
    }

    public Boolean getEnableOptimizeTable(String source) {
        return this.enableOptimizeTable.get(source);
    }

    public void setEnableOptimizeTable(String source, Boolean enable) {
        this.enableOptimizeTable.put(source, enable);
    }

    public Boolean getEnableOptimizeTableDefault() {
        return this.enableOptimizeTableDefault;
    }

    public void setEnableOptimizeTableDefault(Boolean enable) {
        this.enableOptimizeTableDefault = enable;
    }

    public Boolean getEnableForceTabTableCleanup(String source) {
        return this.enableForceTabTableCleanup.get(source);
    }

    public void setEnableForceTabTableCleanup(String source, Boolean enable) {
        this.enableForceTabTableCleanup.put(source, enable);
    }

    public Boolean getEnableForceTabTableCleanupDefault() {
        return this.enableForceTabTableCleanupDefault;
    }

    public void setEnableForceTabTableCleanupDefault(Boolean enable) {
        this.enableForceTabTableCleanupDefault = enable;
    }

    public String getBootstrapTypeOverride(String source) {
        return this.bootstrapTypeOverride.get(source);
    }

    public void setBootstrapTypeOverride(String source, String bootstrapTypeOverride) {
        this.bootstrapTypeOverride.put(source, bootstrapTypeOverride);
    }

    public void setRetentionOverride(String source, RetentionConfig retentionOverride) {
        this.retentionOverride.put(source, retentionOverride);
    }

    public RetentionConfig getRetentionDefault() {
        return this.retentionDefault;
    }

    public void setRetentionDefault(RetentionConfig retentionDefault) {
        this.retentionDefault = retentionDefault;
    }

    public String getBootstrapTypeDefault() {
        return this.bootstrapTypeDefault;
    }

    public void setBootstrapTypeDefault(String bootstrapTypeDefault) {
        this.bootstrapTypeDefault = bootstrapTypeDefault;
    }

    public boolean getEnable() {
        return this.enable;
    }

    public void setEnable(boolean e) {
        this.enable = e;
    }

    public PeriodicTriggerConfigBuilder getPeriodicTrigger() {
        return this.periodicTrigger;
    }

    public void setPeriodicTrigger(PeriodicTriggerConfigBuilder periodicTrigger) {
        this.periodicTrigger = periodicTrigger;
    }

    public DiskSpaceTriggerConfigBuilder getDiskSpaceTrigger() {
        return this.diskSpaceTrigger;
    }

    public void setDiskSpaceTrigger(DiskSpaceTriggerConfigBuilder diskSpaceTrigger) {
        this.diskSpaceTrigger = diskSpaceTrigger;
    }

    public static class PeriodicTriggerConfigBuilder
    implements ConfigBuilder<BootstrapCleanerStaticConfig.PeriodicTriggerConfig> {
        public static final long DEFAULT_RUN_INTERVAL_SECONDS = 21600L;
        private long runIntervalSeconds = 21600L;
        private boolean enable = true;
        private boolean runOnStart = false;

        public long getRunIntervalSeconds() {
            return this.runIntervalSeconds;
        }

        public void setRunIntervalSeconds(long runIntervalSeconds) {
            this.runIntervalSeconds = runIntervalSeconds;
        }

        public boolean getEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public boolean isRunOnStart() {
            return this.runOnStart;
        }

        public void setRunOnStart(boolean runOnStart) {
            this.runOnStart = runOnStart;
        }

        public BootstrapCleanerStaticConfig.PeriodicTriggerConfig build() throws InvalidConfigException {
            return new BootstrapCleanerStaticConfig.PeriodicTriggerConfig(this.runIntervalSeconds, this.enable, this.runOnStart);
        }
    }

    public static class DiskSpaceTriggerConfigBuilder
    implements ConfigBuilder<BootstrapCleanerStaticConfig.DiskSpaceTriggerConfig> {
        public static final double DEFAULT_AVAILABLE_THRESHOLD_PERCENT = 25.0;
        public static final boolean DEFAULT_ENABLE = true;
        public static final long DEFAULT_RUN_INTERVAL_SECONDS = 3600L;
        public static final String DEFAULT_BOOTSTRAP_DB_DRIVE = "/mnt/u001";
        private boolean enable = true;
        private long runIntervalSeconds = 3600L;
        private double availableThresholdPercent = 25.0;
        private String bootstrapDBDrive = "/mnt/u001";

        public boolean getEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public long getRunIntervalSeconds() {
            return this.runIntervalSeconds;
        }

        public void setRunIntervalSeconds(long runIntervalSeconds) {
            this.runIntervalSeconds = runIntervalSeconds;
        }

        public double getAvailableThresholdPercent() {
            return this.availableThresholdPercent;
        }

        public void setAvailableThresholdPercent(double availableThresholdPercent) {
            this.availableThresholdPercent = availableThresholdPercent;
        }

        public BootstrapCleanerStaticConfig.DiskSpaceTriggerConfig build() throws InvalidConfigException {
            if (this.availableThresholdPercent > 100.0 || this.availableThresholdPercent < 0.0) {
                throw new InvalidConfigException("availableThresholdPercent must be between 0-100");
            }
            return new BootstrapCleanerStaticConfig.DiskSpaceTriggerConfig(this.enable, this.runIntervalSeconds, this.availableThresholdPercent, this.bootstrapDBDrive);
        }

        public String getBootstrapDBDrive() {
            return this.bootstrapDBDrive;
        }

        public void setBootstrapDBDrive(String bootstrapDBDrive) {
            this.bootstrapDBDrive = bootstrapDBDrive;
        }
    }

    public static class RetentionConfig
    implements ConfigBuilder<BootstrapCleanerStaticConfig.RetentionStaticConfig> {
        private static final String DEFAULT_RETENTION_TYPE = BootstrapCleanerStaticConfig.RetentionType.RETENTION_SECONDS.toString();
        private static final long DEFAULT_RETENTION_QTY = 1209600L;
        private String retentionType = DEFAULT_RETENTION_TYPE;
        private long retentionQuantity = 1209600L;

        public String getRetentionType() {
            return this.retentionType;
        }

        public void setRetentionType(String retentionType) {
            this.retentionType = retentionType;
        }

        public long getRetentionQuantity() {
            return this.retentionQuantity;
        }

        public void setRetentionQuantity(long retentionQuantity) {
            this.retentionQuantity = retentionQuantity;
        }

        public BootstrapCleanerStaticConfig.RetentionStaticConfig build() throws InvalidConfigException {
            try {
                BootstrapCleanerStaticConfig.RetentionType type = BootstrapCleanerStaticConfig.RetentionType.valueOf(this.retentionType);
                return new BootstrapCleanerStaticConfig.RetentionStaticConfig(type, this.retentionQuantity);
            }
            catch (Exception ex) {
                throw new InvalidConfigException((Throwable)ex);
            }
        }
    }
}

