/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.bootstrap;

import com.linkedin.databus.client.consumer.AbstractDatabusBootstrapConsumer;
import com.linkedin.databus.client.pub.ConsumerCallbackResult;
import com.linkedin.databus.client.pub.DbusEventDecoder;
import com.linkedin.databus.client.pub.SCN;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusEventBuffer;
import com.linkedin.databus.core.util.InvalidConfigException;
import org.apache.avro.Schema;
import org.apache.log4j.Logger;

public class DatabusBootstrapDummyConsumer
extends AbstractDatabusBootstrapConsumer {
    public static final String MODULE = DatabusBootstrapDummyConsumer.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);

    static DbusEventBuffer.StaticConfig getConfig(long maxEventBufferSize, int maxIndividualBufferSize, int maxIndexSize, int maxReadBufferSize, DbusEventBuffer.AllocationPolicy allocationPolicy, DbusEventBuffer.QueuePolicy policy) throws InvalidConfigException {
        DbusEventBuffer.Config config = new DbusEventBuffer.Config();
        config.setMaxSize(maxEventBufferSize);
        config.setMaxIndividualBufferSize(maxIndividualBufferSize);
        config.setScnIndexSize(maxIndexSize);
        config.setAverageEventSize(maxReadBufferSize);
        config.setAllocationPolicy(allocationPolicy.name());
        config.setQueuePolicy(policy.toString());
        return config.build();
    }

    public ConsumerCallbackResult onStartBootstrapSequence(SCN startScn) {
        this.printBootstrapEventInfo(BootstrapStage.StartBootstrapSequence, startScn.toString());
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onEndBootstrapSequence(SCN endScn) {
        this.printBootstrapEventInfo(BootstrapStage.EndBootstrapSequence, endScn.toString());
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onStartBootstrapSource(String name, Schema sourceSchema) {
        this.printBootstrapEventInfo(BootstrapStage.StartBootstrapSource, name);
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onEndBootstrapSource(String name, Schema sourceSchema) {
        this.printBootstrapEventInfo(BootstrapStage.EndBootstrapSource, name);
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onBootstrapEvent(DbusEvent e, DbusEventDecoder eventDecoder) {
        this.printBootstrapEventInfo(BootstrapStage.OnBootstrapEvent, e.toString());
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onBootstrapCheckpoint(SCN batchCheckpointScn) {
        this.printBootstrapEventInfo(BootstrapStage.OnCheckpointEvent, batchCheckpointScn.toString());
        return ConsumerCallbackResult.SUCCESS;
    }

    protected void printBootstrapEventInfo(BootstrapStage stage, String info) {
        LOG.info((Object)((Object)((Object)stage) + ": " + info));
    }

    public static void main(String[] args) throws Exception {
    }

    static enum BootstrapStage {
        StartBootstrapSequence,
        EndBootstrapSequence,
        OnBootstrapEvent,
        OnCheckpointEvent,
        StartBootstrapSource,
        EndBootstrapSource;

    }
}

