/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaschmiede.camunda.clojure;

import clojure.java.api.Clojure;
import clojure.lang.IFn;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.impl.el.CommandContextFunctionMapper;
import org.camunda.bpm.engine.impl.javax.el.FunctionMapper;
import org.camunda.bpm.engine.impl.util.ReflectUtil;

public class ClojureFunctionMapper
extends FunctionMapper {
    private static Map<String, Method> FUNCTION_MAP = new HashMap<String, Method>();
    private static final IFn REQUIRE = Clojure.var((Object)"clojure.core", (Object)"require");
    private static final String KEY_DELEGATE = "delegate";
    private static final String KEY_FUNCTION = "function";
    private static final String KEY_PREFIX = "clj";
    private static final String NS_SEPARATOR = "/";

    public Method resolveFunction(String prefix, String localName) {
        if (!KEY_PREFIX.equals(prefix)) {
            return null;
        }
        this.initializeFunctionMapIfEmpty();
        return FUNCTION_MAP.get(localName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeFunctionMapIfEmpty() {
        if (!FUNCTION_MAP.isEmpty()) return;
        Class<CommandContextFunctionMapper> clazz = CommandContextFunctionMapper.class;
        synchronized (CommandContextFunctionMapper.class) {
            if (!FUNCTION_MAP.isEmpty()) return;
            FUNCTION_MAP.put(KEY_DELEGATE, ReflectUtil.getMethod(ClojureFunctionMapper.class, (String)KEY_DELEGATE, (Class[])new Class[]{String.class}));
            FUNCTION_MAP.put(KEY_FUNCTION, ReflectUtil.getMethod(ClojureFunctionMapper.class, (String)KEY_FUNCTION, (Class[])new Class[]{String.class, Object[].class}));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static JavaDelegate delegate(String expression) {
        return execution -> ClojureFunctionMapper.invokeClojureFunction(expression, execution);
    }

    public static Object function(String expression, Object ... params) {
        return ClojureFunctionMapper.invokeClojureFunction(expression, params);
    }

    private static Object invokeClojureFunction(String expression, Object ... params) {
        int paramSize = params.length;
        String[] expressionParts = expression.split(NS_SEPARATOR);
        String ns = expressionParts[0];
        String name = expressionParts[1];
        REQUIRE.invoke(Clojure.read((String)ns));
        IFn fun = Clojure.var((Object)ns, (Object)name);
        switch (paramSize) {
            case 0: {
                return fun.invoke();
            }
            case 1: {
                return fun.invoke(params[0]);
            }
            case 2: {
                return fun.invoke(params[0], params[1]);
            }
            case 3: {
                return fun.invoke(params[0], params[1], params[2]);
            }
            case 4: {
                return fun.invoke(params[0], params[1], params[2], params[3]);
            }
            case 5: {
                return fun.invoke(params[0], params[1], params[2], params[3], params[4]);
            }
            case 6: {
                return fun.invoke(params[0], params[1], params[2], params[3], params[4], params[5]);
            }
        }
        throw new IllegalArgumentException(String.format("Parameter size of %s is not allowed for a Clojure expression", paramSize));
    }
}

