/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaschmiede.camunda.clojure;

import clojure.java.api.Clojure;
import clojure.lang.IFn;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.impl.el.CommandContextFunctionMapper;
import org.camunda.bpm.engine.impl.javax.el.FunctionMapper;
import org.camunda.bpm.engine.impl.util.ReflectUtil;

public class ClojureFunctionMapper
extends FunctionMapper {
    public static Map<String, Method> FUNCTION_MAP = new HashMap<String, Method>();

    public Method resolveFunction(String prefix, String localName) {
        if (!"clj".equals(prefix)) {
            return null;
        }
        this.initializeFunctionMapIfEmpty();
        return FUNCTION_MAP.get(localName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeFunctionMapIfEmpty() {
        if (!FUNCTION_MAP.isEmpty()) return;
        Class<CommandContextFunctionMapper> clazz = CommandContextFunctionMapper.class;
        synchronized (CommandContextFunctionMapper.class) {
            if (!FUNCTION_MAP.isEmpty()) return;
            FUNCTION_MAP.put("delegate", ReflectUtil.getMethod(ClojureFunctionMapper.class, (String)"delegate", (Class[])new Class[]{String.class}));
            FUNCTION_MAP.put("function", ReflectUtil.getMethod(ClojureFunctionMapper.class, (String)"function", (Class[])new Class[]{String.class, Object[].class}));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static JavaDelegate delegate(String expression) {
        return execution -> Clojure.var((Object)expression).invoke((Object)execution);
    }

    public static Object function(String expression, Object ... params) {
        int paramSize = params.length;
        IFn fun = Clojure.var((Object)expression);
        switch (paramSize) {
            case 0: {
                return fun.invoke();
            }
            case 1: {
                return fun.invoke(params[0]);
            }
            case 2: {
                return fun.invoke(params[0], params[1]);
            }
            case 3: {
                return fun.invoke(params[0], params[1], params[2]);
            }
        }
        throw new IllegalArgumentException(String.format("Parameter size of %s is not allowed for a Clojure expression", paramSize));
    }
}

