(ns com.kurogitsune.wavy
  (:import (javax.sound.sampled AudioSystem AudioInputStream AudioFileFormat$Type)
           (java.nio ByteBuffer ByteOrder)
           (java.io ByteArrayInputStream)))

(defn load-sample-bytes [file-path]
  (let [file (java.io.File. file-path)
        ais (AudioSystem/getAudioInputStream file)
        wav-format (.getFormat ais)
        data (byte-array (.available ais))]
    (.read ais data)
    (.close ais)
    {:format wav-format :data data}))

(defn save-sample-bytes [file-path source]
  (let [file (java.io.File. file-path)
        ais (AudioInputStream. (ByteArrayInputStream. (:data source)) (:format source) (count (:data source)))]
    (AudioSystem/write ais AudioFileFormat$Type/WAVE file)))

(defn bytes-to-shorts [data]
  (let [times (/ java.lang.Short/SIZE java.lang.Byte/SIZE)
        buffer (short-array (/ (count data) times))] 
    (.get (.asShortBuffer (.order (ByteBuffer/wrap data) ByteOrder/LITTLE_ENDIAN)) buffer)
    buffer))

(defn shorts-to-bytes [data]
  (let [times (/ java.lang.Short/SIZE java.lang.Byte/SIZE)
        buffer-size (* (count data) times)
        buffer (.order (ByteBuffer/allocate buffer-size) ByteOrder/LITTLE_ENDIAN)] 
    (.put (.asShortBuffer buffer) data)
    (.array buffer)))

(defn shorts-to-doubles [data]
    (->> data
      (map (fn [x] (/ x 32768.0)))
      (double-array)))

(defn doubles-to-shorts [data]
    (->> data
      (map (fn [x] (* x 32768.0)))
      (short-array)))

(defn bytes-to-doubles [data]
  (shorts-to-doubles (bytes-to-shorts data)))

(defn doubles-to-bytes [data]
  (shorts-to-bytes (doubles-to-shorts data)))

(defn load-sample [file-path]
  (let [source (load-sample-bytes file-path)]
    {:format (:format source) :data (bytes-to-doubles (:data source))}))

(defn save-sample [file-path source]
  (save-sample-bytes file-path {:format (:format source) :data (doubles-to-bytes (:data source))}))

(defn frame-rate [source] (.getFrameRate (:format source)))