(ns com.kurogitsune.unbrace)

(defn even-odd [text left right]
	(let [splitted (clojure.string/split text (re-pattern (str"[" left right "]")))]
		(let [indices (range (count splitted))]
			[(map (fn [i] (nth splitted i)) (filter even? indices))
			 (map (fn [i] (nth splitted i)) (filter odd? indices))])))

(defn num-to-replace [text left right]
	(count (second (even-odd text left right))))

(defn pattern-replaced [text left right f]
	(let [patterns (map (fn [x] (re-pattern (str left x right))) (second (even-odd text left right)))]
		(second (reduce (fn [l r] [(+ 1 (first l)) (clojure.string/replace (second l) r (f r (first l)))]) [0 text] patterns))))

(defn pattern-replaced-with [text left right xs]
	(pattern-replaced text left right (fn [_ i] (nth xs i))))