(ns com.kurogitsune.salt
  (:require [com.kurogitsune.avm-clj :as avm]
            [clojure.core.match :refer [match]]
            [clojure.set :as cs]))

(defn merge-phone-base [phone head k non-head]
  ;; {:PHONE {:HEAD eats}} + {:PHONE keats} => {:PHONE {:HEAD eats :SUBJ keats}}
  (if (map? (get head phone))
    (merge (get head phone) {k (vec (concat (get (get head phone) k) [(get non-head phone)]))})))

(defn merge-phone [head k non-head]
  (merge-phone-base :PHONE head k non-head))

(defn merge-v-phone [head k non-head]
  (merge-phone-base :VPHONE head k non-head))

(defn pairs-compatible? [a b]
  (let [a-set (into {} (map (fn [x] [(first x) #{(second x)}]) a))
        b-set (into {} (map (fn [x] [(first x) #{(second x)}]) b))
        merged (not-empty (filter (fn [x] (= 2 (count (second x)))) (merge-with cs/union a-set b-set)))]
    (and (some? merged)
         (every? (fn [x] (let [a (first (second x)) b (second (second x))] (and (not-empty a) (not-empty b) (or (avm/is-compatible a b) (avm/is-compatible b a))))) merged))))

;; avm/deep-mergeはholderの内容をマージしないのでマージする版  
(defn deep-merge-for-holders [a b]
  (if (= a b) a
    (match [a b]
      [(_ :guard map?) (_ :guard map?)] (merge-with deep-merge-for-holders a b)
      [_ nil] a
      [nil _] b
      [a :_] a
      [:_ b] b
      [(ea :guard set?) (eb :guard set?)] (clojure.set/union ea eb)  
      [(ea :guard set?) _] (clojure.set/union ea #{b}) 
      [_ (eb :guard set?)] (clojure.set/union #{a} eb)
      [(_ :guard sequential?) (_ :guard sequential?)]
        ;; [head rest] for holders. ex.[a b c] [{1 :_} {2 :_}] => [#{a {1 :_}} #{[b c] {2 :_}}] 
        (if (some? (not-empty (rest b)))
          [#{(first a) (first b)} (into #{} (map (fn [x] (if (= (count x) 1) (first x) (vec x))) #{(rest a) (rest b)}))]
          [#{(first a) (first b)} (vec (rest a))])
      [a b] #{a b}
  )))

(defn head-non-head-common [head-base non-head-base merged-base head non-head k]
  (if (and (avm/is-compatible head head-base)
           (avm/is-compatible non-head non-head-base))
    (let [head-extracted (avm/extract-replace-map-with head head-base)
          non-head-extracted (avm/extract-replace-map-with non-head non-head-base)]
      (if (pairs-compatible? head-extracted non-head-extracted)
        (let [pairs (deep-merge-for-holders head-extracted non-head-extracted)
              merged (avm/deep-input-holders pairs merged-base)
              head-replace-pairs
                (apply merge (filter some? (map (fn [x] 
                  (let [instance (get non-head-extracted (first x)) holder (second x)]
                    (not-empty (avm/extract-replace-map-with instance holder))) 
                  ) head-extracted)))
              head-replaced (avm/deep-input-holders head-replace-pairs head)
              merged-replaced (avm/deep-input-holders head-replace-pairs merged)
              phone (merge-phone head-replaced k non-head) 
              vphone (merge-v-phone head-replaced k non-head)
              final (merge (avm/deep-replace head-replaced merged-replaced) {:PHONE phone} (if (:VPHONE head-replaced) {:VPHONE vphone}))]
          final)))))

(def head-subj-head-base {:PHONE {1 :_} :HEAD {2 :_} :VAL {:SUBJ [{3 :_} {4 :_}] :COMPS {5 :_} :SPR {6 :_}}})
(def subj-base {3 :_})
(def merged-head-subj-base {:PHONE {1 :_} :HEAD {2 :_} :VAL {:SUBJ {4 :_} :COMPS {5 :_} :SPR {6 :_}}})
  
(defn head-subj [head subj] (head-non-head-common head-subj-head-base subj-base merged-head-subj-base head subj :SUBJ))

(def head-comp-head-base {:PHONE {1 :_} :HEAD {2 :_} :VAL {:SUBJ {3 :_} :COMPS [{4 :_} {5 :_}] :SPR {6 :_}}})
(def comp-base {4 :_})
(def merged-head-comp-base {:PHONE {1 :_} :HEAD {2 :_} :VAL {:SUBJ {3 :_} :COMPS {5 :_} :SPR {6 :_}}})

(defn head-comp [head compl] (head-non-head-common head-comp-head-base comp-base merged-head-comp-base head compl :COMPS))

(def head-mod-head-base {6 :_})
(def mod-r-base {:PHONE {1 :_} :HEAD {2 :_} :VAL {:SUBJ {3 :_} :COMPS {4 :_} :SPR {5 :_} :MODR [{6 :_} {7 :_}]}})
(def merged-head-mod-r-base {6 :_ :VAL {:MODR {7 :_}}})
(def mod-l-base {:PHONE {1 :_} :HEAD {2 :_} :VAL {:SUBJ {3 :_} :COMPS {4 :_} :SPR {5 :_} :MODL [{6 :_} {7 :_}]}})
(def merged-head-mod-l-base {6 :_ :VAL {:MODL {7 :_}}})
(def mod-base {:PHONE {1 :_} :HEAD {2 :_} :VAL {:SUBJ {3 :_} :COMPS {4 :_} :SPR {5 :_} :MOD [{6 :_} {7 :_}]}})
(def merged-head-mod-base  {6 :_ :VAL {:MOD {7 :_}}})
 
(defn head-mod-rl [head m] (head-non-head-common head-mod-head-base mod-r-base merged-head-mod-r-base head m :MOD))
(defn head-mod-lr [head m] (head-non-head-common head-mod-head-base mod-l-base merged-head-mod-l-base head m :MOD))
(defn head-mod [head m] (head-non-head-common head-mod-head-base mod-base merged-head-mod-base head m :MOD))

(defn build-tree-impl [acc f]
  (let [next-acc 
    (apply clojure.set/union (filter some? (map (fn [xs] xs
      (let [pairs (map f (map vector xs (rest xs)))
            result (if (some true? (map nil? pairs)) nil (into #{} (map-indexed (fn [i p] (vec (concat (take i xs) [p] (drop (+ 2 i) xs)))) pairs)))]
      result
    )) acc)))]
    (if (or (nil? next-acc) (<= (count (first next-acc)) 2)) next-acc (build-tree-impl next-acc f))
    ))

(defn build-tree 
  ([xs f] (build-tree-impl #{xs} f))
  ([xs] (build-tree identity)))

(defn with-vphone [tokens]
  (vec (map-indexed (fn [i t] (if (nil? (get t :VPHONE)) (assoc t :VPHONE {:VAR i}) t)) tokens)))

(defn without-vphone [vtokens]
  (vec (map (fn [vtoken] (dissoc vtoken :VPHONE)) vtokens)))

(defn re-vphone [vtokens]
  (with-vphone (without-vphone vtokens)))

(defn variable-only [vtokens]
  (vec (map (fn [vtoken] (dissoc vtoken :PHONE)) vtokens)))

(defn input-phone-variable [vhpsg hpsgs]
  (defn input-variable-inner [x]
    (match [x]
      [[:VAR (i :guard integer?)]] (:PHONE (get hpsgs i))
      [(s :guard sequential?)] (vec (map input-variable-inner s))
      [(kv :guard map?)] (into {} (map (fn [x] (input-variable-inner x)) kv))
      [_] x
    ))
  (let [result (input-variable-inner vhpsg)]
    (dissoc (assoc result :PHONE (:VPHONE result)) :VPHONE))) ;; VPHONE => PHONE

(def tree-bank (atom {}))

(def rules-lr (atom [head-subj head-comp head-mod head-mod-lr]))
(def rules-rl (atom [head-subj head-comp head-mod head-mod-rl]))

(defn combine2 [a b]
  (let [candidates (concat (map (fn [f] (f a b)) @rules-lr) (map (fn [f] (f b a)) @rules-rl))]
    (not-empty (into #{} (filter some? candidates)))))

(defn combine 
  ([token] (combine token true))
  ([tokens use-vphone?]
    (let [vtokens (if use-vphone? (with-vphone tokens) tokens) pure-vtokens (variable-only vtokens)]
      (if (and use-vphone? (contains? @tree-bank pure-vtokens)) 
        (let [banked (get @tree-bank pure-vtokens)] #{(avm/deep-merge (input-phone-variable banked vtokens) banked)}) ;; re input VPHONE
        (condp = (count vtokens)
          1 (let [] (into #{} vtokens))
          2 (combine2 (first vtokens) (second vtokens))   
          (let [flatten-x  (fn [abs] (into #{} (mapcat cs/union (map (fn [a] (mapcat cs/union (map (fn [b] (combine2 a b)) (second abs)))) (first abs)))))
                banked
                (->>
                  (range (count vtokens))
                  (map (fn [x] 
                    (cs/union 
                      (let [left (re-vphone (drop-last x vtokens)) right (re-vphone (take-last x vtokens))]
                        (if (contains? @tree-bank left)
                          (let [left-banked (input-phone-variable (get @tree-bank left) left)]
                            (combine (without-vphone (cons left-banked right) use-vphone?)) nil)))
                      (let [left (re-vphone (take x vtokens)) right (re-vphone (drop x vtokens))]
                        (if (contains? @tree-bank right)
                          (let [right-banked (input-phone-variable (get @tree-bank right) right)]
                            (combine (without-vphone (conj left right-banked) use-vphone?)) nil))))
                  ))
                  (apply cs/union))]
            (if (not-empty banked) banked
              (not-empty (into #{} (mapcat cs/union (map flatten-x (build-tree (map (fn [t] #{t}) vtokens) flatten-x))))))))))))

