(ns com.kurogitsune.salt
  (:require [com.kurogitsune.avm-clj :as avm]
            [clojure.core.match :refer [match]]
            [clojure.set :as cs]))

(defn merge-phone [head k non-head]
  ;; {:PHONE {:HEAD eats}} + {:PHONE keats} => {:PHONE {:HEAD eats :SUBJ keats}}
  (if (map? (get head :PHONE))
    (merge (get head :PHONE) {k (vec (concat (get (get head :PHONE) k) [(get non-head :PHONE)]))})))

(defn pairs-compatible? [a b]
  (let [a-set (into {} (map (fn [x] [(first x) #{(second x)}]) a))
        b-set (into {} (map (fn [x] [(first x) #{(second x)}]) b))
        merged (not-empty (filter (fn [x] (= 2 (count (second x)))) (merge-with cs/union a-set b-set)))]
    (and (some? merged)
         (every? (fn [x] (let [a (first (second x)) b (second (second x))] (and (not-empty a) (not-empty b) (or (avm/is-compatible a b) (avm/is-compatible b a))))) merged))))

(defn head-non-head-common [head-base non-head-base merged-base head non-head k]
  (if (and (avm/is-compatible head head-base)
           (avm/is-compatible non-head non-head-base))
    (let [head-extracted (avm/extract-replace-map-with head head-base)
          non-head-extracted (avm/extract-replace-map-with non-head non-head-base)]
      (if (pairs-compatible? head-extracted non-head-extracted)
        (let [pairs (merge head-extracted non-head-extracted)
              merged (avm/deep-input-holders pairs merged-base)
              head-replace-pairs
                (apply merge (filter some? (map (fn [x] 
                  (let [instance (get non-head-extracted (first x)) holder (second x)]
                    (not-empty (avm/extract-replace-map-with instance holder))) 
                  ) head-extracted)))
              head-replaced (avm/deep-input-holders head-replace-pairs head)
              merged-replaced (avm/deep-input-holders head-replace-pairs merged)
              phone (merge-phone head-replaced k non-head) 
              final (merge (avm/deep-replace head-replaced merged-replaced) {:PHONE phone})]
          final)))))

(def head-subj-head-base {:PHONE {1 :_} :HEAD {2 :_} :VAL {:SUBJ [{3 :_} {4 :_}] :COMPS {5 :_} :SPR {6 :_}}})
(def subj-base {3 :_})
(def merged-head-subj-base {:PHONE {1 :_} :HEAD {2 :_} :VAL {:SUBJ {4 :_} :COMPS {5 :_} :SPR {6 :_}}})
  
(defn head-subj [head subj] (head-non-head-common head-subj-head-base subj-base merged-head-subj-base head subj :SUBJ))

(def head-comp-head-base {:PHONE {1 :_} :HEAD {2 :_} :VAL {:SUBJ {3 :_} :COMPS [{4 :_} {5 :_}] :SPR {6 :_}}})
(def comp-base {4 :_})
(def merged-head-comp-base {:PHONE {1 :_} :HEAD {2 :_} :VAL {:SUBJ {3 :_} :COMPS {5 :_} :SPR {6 :_}}})

(defn head-comp [head compl] (head-non-head-common head-comp-head-base comp-base merged-head-comp-base head compl :COMPS))

(def head-mod-head-base {6 :_})
(def mod-r-base {:PHONE {1 :_} :HEAD {2 :_} :VAL {:SUBJ {3 :_} :COMPS {4 :_} :SPR {5 :_} :MODR [{6 :_} {7 :_}]}})
(def merged-head-mod-r-base {6 :_ :VAL {:MODR {7 :_}}})
(def mod-l-base {:PHONE {1 :_} :HEAD {2 :_} :VAL {:SUBJ {3 :_} :COMPS {4 :_} :SPR {5 :_} :MODL [{6 :_} {7 :_}]}})
(def merged-head-mod-l-base {6 :_ :VAL {:MODL {7 :_}}})
(def mod-base {:PHONE {1 :_} :HEAD {2 :_} :VAL {:SUBJ {3 :_} :COMPS {4 :_} :SPR {5 :_} :MOD [{6 :_} {7 :_}]}})
(def merged-head-mod-base  {6 :_ :VAL {:MOD {7 :_}}})
 
(defn head-mod-rl [head m] (head-non-head-common head-mod-head-base mod-r-base merged-head-mod-r-base head m :MOD))
(defn head-mod-lr [head m] (head-non-head-common head-mod-head-base mod-l-base merged-head-mod-l-base head m :MOD))
(defn head-mod [head m] (head-non-head-common head-mod-head-base mod-base merged-head-mod-base head m :MOD))

(defn build-tree-impl [acc f]
  (let [next-acc 
    (apply clojure.set/union (filter some? (map (fn [xs] xs
      (let [pairs (map f (map vector xs (rest xs)))
            result (if (some true? (map nil? pairs)) nil (into #{} (map-indexed (fn [i p] (vec (concat (take i xs) [p] (drop (+ 2 i) xs)))) pairs)))]
      result
    )) acc)))]
    (if (or (nil? next-acc) (<= (count (first next-acc)) 2)) next-acc (build-tree-impl next-acc f))
    ))

(defn build-tree 
  ([xs f] (build-tree-impl #{xs} f))
  ([xs] (build-tree identity)))

(def rules-lr (atom [head-subj head-comp head-mod head-mod-lr]))
(def rules-rl (atom [head-subj head-comp head-mod head-mod-rl]))

(defn combine2 [a b]
  (let [candidates (concat (map (fn [f] (f a b)) @rules-lr) (map (fn [f] (f b a)) @rules-rl))]
    (not-empty (into #{} (filter some? candidates)))))

(defn combine [tokens]
  (condp = (count tokens)
    1 (let [] (into #{} tokens))
    2 (combine2 (first tokens) (second tokens))   
    (let [flatten-x  (fn [abs] (into #{} (mapcat cs/union (map (fn [a] (mapcat cs/union (map (fn [b] (combine2 a b)) (second abs)))) (first abs)))))]
      (not-empty (into #{} (mapcat cs/union (map flatten-x (build-tree (map (fn [t] #{t}) tokens) flatten-x))))))))

