(ns com.kurogitsune.salt
  (:require [com.kurogitsune.avm-clj :as avm]
            [clojure.core.match :refer [match]]
            [clojure.set :as cs]))

(defn merge-phone [head k non-head]
  ;; {:PHONE {:HEAD eats}} + {:PHONE keats} => {:PHONE {:HEAD eats :SUBJ keats}}
  (if (map? (get head :PHONE))
    (merge (get head :PHONE) {k (vec (concat (get (get head :PHONE) k) [(get non-head :PHONE)]))})))

(def head-base (atom {:PHONE {1 :_} :HEAD {2 :_} :VAL {:SUBJ {3 :_} :COMPS {4 :_} :SPR {5 :_}}}))

;; @todo 一般化
(defn head-subj [head subj]
  (let [phone (merge-phone head :SUBJ subj) 
    current-subj
    (-> head 
      (get :VAL)
      (get :SUBJ))]
    (if (and (not (empty? current-subj)) 
             (avm/is-compatible head @head-base) 
             (avm/is-compatible subj (first current-subj)))
      (let [pairs (avm/extract-replace-map-with (first current-subj) subj) ;; replace holders to instances
            next-head (avm/deep-input-holders pairs head)
            next-subj (vec (map (partial avm/deep-input-holders pairs) current-subj))]
        (avm/deep-replace next-head {:PHONE phone :VAL {:SUBJ (vec (rest next-subj))}})))))

(defn head-comp [head compl]
  (let [phone (merge-phone head :COMPS compl) 
    current-compl
    (-> head 
      (get :VAL)
      (get :COMPS))]
    (if (and (not (empty? current-compl)) 
             (avm/is-compatible head @head-base) 
             (avm/is-compatible compl (first current-compl))) 
       (let [pairs (avm/extract-replace-map-with (first current-compl) compl)
            next-head (avm/deep-input-holders pairs head)
            next-compl (vec (map (partial avm/deep-input-holders pairs) current-compl))]
        (avm/deep-replace next-head {:PHONE phone :VAL {:COMPS (vec (rest next-compl))}})))))

(defn build-tree-impl [acc f]
  (let [next-acc 
    (apply clojure.set/union (filter some? (map (fn [xs] xs
      (let [pairs (map f (map vector xs (rest xs)))
            result (if (some true? (map nil? pairs)) nil (into #{} (map-indexed (fn [i p] (vec (concat (take i xs) [p] (drop (+ 2 i) xs)))) pairs)))]
      result
    )) acc)))]
    (if (or (nil? next-acc) (<= (count (first next-acc)) 2)) next-acc (build-tree-impl next-acc f))
    ))

(defn build-tree 
  ([xs f] (build-tree-impl #{xs} f))
  ([xs] (build-tree identity)))

(def rules-lr (atom [head-subj head-comp]))
(def rules-rl (atom [head-subj head-comp]))

(defn combine2 [a b]
  (let [candidates (concat (map (fn [f] (f a b)) @rules-lr) (map (fn [f] (f b a)) @rules-rl))]
    (not-empty (into #{} (filter some? candidates)))))

(defn combine [tokens]
  (condp = (count tokens)
    1 (let [] (into #{} tokens))
    2 (combine2 (first tokens) (second tokens))   
    (let [flatten-x  (fn [abs] (into #{} (mapcat cs/union (map (fn [a] (mapcat cs/union (map (fn [b] (combine2 a b)) (second abs)))) (first abs)))))]
      (not-empty (into #{} (mapcat cs/union (map flatten-x (build-tree (map (fn [t] #{t}) tokens) flatten-x))))))))

