(ns com.kurogitsune.lafi
	(:require [clojure.core.match :refer [match]]))

(defn boolean? [x]
  (instance? Boolean x))

(defn defl [context table names body]
	(swap! context assoc table (assoc (get @context table) names body))
	(let [r-key (keyword (str "r-" (name table)))]
		(swap! context assoc r-key (assoc (get @context r-key) (clojure.string/join "" names) names))))

(defn call [context table names]
	(get (get @context table) names))

(defn consts [p]
	(match [p]
		[[a "∧" b]] (merge (consts a) (consts b))
		[[pn pb]]
		(let [args 
					(->> (get p 1)
						(filter (fn [x] (not (keyword? (second x)))))
						(into {}))]
			(reduce (fn [l a] (merge l (match [(second a)] [(x :guard string?)] {(first a) x} [x] (consts x)))) args args))))

(defn is-const [a]
	(match [a]
		[(k :guard keyword?)] false
		[[pn pb]] (is-const pb)
		[(args :guard map?)] (every? (fn [x] (is-const x)) args)
		[_] true
	))

(defn is-name-compatible [pn qn]
	(= (take-nth 2 (rest pn)) (take-nth 2 (rest qn))))

(defn is-const-ver-of [a b]
	(match [a b]
		[pc [q "∧" r]] (or (is-const-ver-of pc q) (is-const-ver-of pc r)) 
		[[(pnc :guard vector?) pbc] [(pn :guard vector?) pb]] 
		(and (is-name-compatible pnc pn) (is-const-ver-of pbc pb))
		[[pnc pbc] [pn pb]] 
		(is-const-ver-of pbc pb)
		[(args-a :guard map?) (args-b :guard map?)] 
		(every? (fn [x] (is-const-ver-of (first x) (second x))) (map vector args-a args-b))
		[a b] 
		(or (= a b) (and (is-const a) (keyword? b))
	)))

(defn replaced [a cs]
	(match [a]
		[[p "∧" q]] [(replaced p cs) "∧" (replaced q cs)]
		[[(pn :guard vector?) pb]] [pn (replaced pb cs)]
		[(args :guard map?)] (into {} (vec (map (fn [x] (replaced x cs)) args)))
		[[(k :guard keyword?) v]] (if (some? (get cs k)) [k (get cs k)] [k (replaced v cs)])
		[_] a
	))

(defn variable-version [p cs]
	(let [vs (into {} (map (fn [x] [(first x) (first x)]) cs))]
		(replaced p vs)))

(defn deducted 
	([imp pc xs]
		(match [imp]
			[["∀" x [ p "->" q ]]] 
			(let [cs (consts pc)]
				(if (is-const-ver-of pc p) (replaced q cs)))
			[["∀" y px]] (deducted px pc {(keyword y) y})
			[_] nil
		))
	([imp pc] (deducted imp pc #{})))

(defn inducted [pc qc]
	(let [sc (into {} (clojure.set/intersection (into #{} (consts pc)) (into #{} (consts qc))))]
		(if (some? (not-empty sc))
			(reduce (fn [l r] ["∀" (name (first r)) l]) [(variable-version pc sc) "->" (variable-version qc sc)] sc))))
	
(defn abducted 
	([qc imp xs]
		(match [imp]
			[["∀" x [ p "->" q ]]] 
			(let [cs (consts qc)]
				(if (is-const-ver-of qc q) (replaced p cs)))
			[["∀" y px]] (abducted qc px {(keyword y) y})
			[_] nil
		))
	([qc imp] (abducted qc imp #{})))
