(ns com.kurogitsune.crayman
	(require [clojure.set :as s]
					 [clojure.core.match :refer [match]]))

(def context (atom {}))
(def thing "`thing")
(defn execute! [x] (binding [*ns* (find-ns 'com.kurogitsune.crayman)] (load-string x)))
(defn e! [k] (if (get @context k) (execute! (get @context k))))
(defn e1! [k] (execute! (first (e! k))))
(defn is! [k c] 
	(swap! context assoc k (str (s/union (into #{} (e! k)) #{c})))
	(if (not (= k thing)) (is! thing c)))
(defn is-not! [k c] 
	(swap! context assoc k (str (s/difference (into #{} (e! k)) #{c})))
	(if (not (= k thing)) (is-not! thing c)))

(defn register-basics []
	(is! (str '["x" "は" "y" "である"]) (str '(fn [args] (some? (not-empty (some #{(first args)} (e! (second args))))))))
	(is! (str '["x" "は" "y"]) (str '(fn [args] (some? (not-empty (some #{(first args)} (e! (str (second args) "もの"))))))))
	(is! "and" (str '(fn [a b] (and a b))))
	(is! "or" (str '(fn [a b] (or a b))))
	(is! "not" (str '(fn [a] (not a))))
	(is! "imp" (str '(fn [a b] (or (not a) b))))
	(is! "all" (str '(fn [x px] (every? (fn [t] (f! (replaced px x t))) (e! thing)))))
	(is! "exists" (str '(fn [x px] (some (fn [t] (f! (replaced px x t))) (e! thing))))))

(defn n-args [f]
  (-> f class .getDeclaredMethods first .getParameterTypes alength))
	
(defn f! [k] 
	(let [kn (get k 0) kb (get k 1)]
			(->> (e! (first kn))
				(if (some? kb) (let [] ((e1! (str kn)) kb)))
				(if (and (= (count k) 3) (= "->" (second k)))
					(execute! (str "((e1! \"imp\") (f! " (first k) ") (f! " (get k 2) "))")))
				(if (and (= (count k) 3) (= "∀" (first k)))
					((e1! "all") (second k) (nth k 2)))
				(if (and (= (count k) 3) (= "∃" (first k)))
					((e1! "exists") (second k) (nth k 2)))
				(if (and (= (count k) 3) (= "∧" (second k)))
					((e1! "and") (f! (first k)) (f! (nth k 2))))
				(if (some? (e! (str k))) (e1! (str k)))
			)
		))

(defn force! [pc]
	"pcが真となるように集合を強制的に書き換える"
	(match [pc]
		[[["x" "は" "y" "である"] [c y]]] (is! y c)
		[[["x" "は" "y"] [c y]]] (is! (str y "もの") c)
		[_] nil
	))

(defn replaced [p x c]
	;; @todo other patterns 
	(match [p]
		[[kn kb]] [kn (vec (map (fn [a] (if (= a x) c a)) kb))]
		[[a "->" b]] [(replaced a x c) "->" (replaced b x c)]
		[_] p
	))

(defn const-with [p xs]
	(not-empty (filter (fn [x] (not (some #{x} xs))) (second p))))

(defn const [p]
	(let [xs #{"x" "y" "z" "s" "t" "u" "v"}]
		(const-with p xs)))

(defn is-variable [x]
	(let [xs #{"x" "y" "z" "s" "t" "u" "v"}] (some #{x} xs)))

(defn same-const [p q]
	(not-empty (clojure.set/intersection (into #{} (const p)) (into #{} (const q)))))

(defn diff-const [p q]
	(not-empty (clojure.set/difference (into #{} (const p)) (into #{} (const q)))))

(defn const-indices [p cs]
	(filter some? (map-indexed (fn [i x] (if (some #{x} cs) i)) (second p))))

(defn variable-version [p is]
	(let [xs ["x" "y" "z" "s" "t" "u" "v"]]
		[(first p) (vec (map-indexed (fn [i x] (if (some #{i} is) (get xs i) x)) (second p)))]))

(defn is-const-version-of [pc p]
	(every? (fn [c] (is-variable (get p (.indexOf (second pc) c)))) (diff-const p pc)))

(defn deducted [imp pc]
	(match [imp]
		[["∀" x [p  "->" q]]] 
		(let [c (first (const-with pc #{x}))]
			(if (and (is-const-version-of pc p) (f! [imp "∧" pc])) (replaced q x c)))))

(defn inducted [pc qc]
	(let [sc (same-const pc qc) 
				pcv (variable-version pc (const-indices pc sc))
				qcv (variable-version qc (const-indices qc sc))]
		(if (some? sc) ["∀" "x" [pcv "->" qcv]])))

(defn abducted [qc imp]
	(match [imp]
		[["∀" x [p "->" q]]] 
		(let [c (first (const-with qc #{x}))]
			(if (and (is-const-version-of qc q) (f! [qc "∧" imp])) (replaced p x c)))))

(defn ps-from-kv [kv]
	(let [result (->> (read-string (second kv))
		(map (fn [e] 
			(if (not (= (first kv) thing))
				(match [(first kv)]
					[(n :guard (fn [x] (.endsWith x "もの")))] [["x" "は" "y"] [e (second (re-matches #"(.+)もの" n))]]
					[n] [["x" "は" "y" "である"] [e n]]
					[_] nil
		))))
		(filter some?)
	)] result))

(defn find-const-versions [table p]
	(->>
		(reduce clojure.set/union (map (fn [kv] (ps-from-kv kv)) @context))
		(filter (fn [t] (and (vector? t) (is-const-version-of t p))))))

(defn deducted-all []
	(let [imps (filter some? (map (fn [t] (match [t] [(["∀" x [p "->" q]] :as imp)] imp [_] nil)) (e! thing)))]
		(let [ps (map (fn [i] (match [i] [["∀" x [p "->" q]]] p [_] nil)) imps)]
			(let [pcs (map (fn [p] (find-const-versions thing p)) ps)]
				(reduce clojure.set/union (map (fn [v] (into #{} (map (fn [p] (deducted (first v) p)) (second v)))) (map vector imps pcs)))))))

(defn inducted-all []
	(let [cs (filter const (reduce clojure.set/union (map (fn [kv] (ps-from-kv kv)) @context)))] ;; 一部にでもconstがあればok	
		(reduce clojure.set/union (map (fn [pc] (into #{} (filter some? (map (fn [qc] (if (not (= pc qc)) (inducted pc qc))) cs)))) cs))))

(defn abducted-all []
	(let [imps (filter some? (map (fn [t] (match [t] [(["∀" x [p "->" q]] :as imp)] imp [_] nil)) (e! thing)))]
		(let [qs (map (fn [i] (match [i] [["∀" x [p "->" q]]] q [_] nil)) imps)]
			(let [qcs (map (fn [q] (find-const-versions thing q)) qs)]
				(reduce clojure.set/union (map (fn [v] (into #{} (map (fn [q] (abducted q (first v))) (second v)))) (map vector imps qcs)))))))