(ns com.kurogitsune.ccgjp
	(:require [clojure.core.match :refer [match]]))

(defn is-compatible [a b]
	(let [result (match [a b]
		[[a (spec-a :guard set?)] [b (spec-b :guard set?)]] (and (is-compatible a b) (clojure.set/subset? spec-a spec-b))
		[[a (spec-a :guard set?)] [b]] (is-compatible a b)
		[(va :guard vector?) (vb :guard vector?)] (every? (fn [x] (is-compatible (first x) (second x))) (map vector va vb))
		[_ (_ :guard (fn [x] (= a b)))] true
		[_ (_ :guard (fn [x] (and (map? a) (contains? a "T"))))] true
		[_ (_ :guard (fn [x] (and (map? b) (contains? b "T"))))] true
		[_ _] false
		)]
		result))

(defn extract-t [typed a]
	(match [typed a]
		[(vt :guard vector?) (va :guard vector?)] (apply merge (filter some? (map (fn [x] (extract-t (first x) (second x))) (map vector vt va))))
		[et ea] (if (and (map? et) (contains? et "T")) (let [] {et ea}))))

(defn count-t [typed]
	(match [typed]
		[(v :guard vector?)] (apply max (map (fn [x] (count-t x)) v))
		[e] (if (and (map? e) (contains? e "T")) (get e "T") 0)))

(defn replaced-t [t n]
	(match [t]
		[{"T" c}] (if (<= c n) {"T" (+ n c)} t)
		[(m :guard map?)] (into {} (map (fn [x] [(first x) (replaced-t (second x) n)]) m))
		[(v :guard vector?)] (vec (map (fn [x] (replaced-t x n)) v))
		[_] t
	))

(defn complete-t [typed t]
	(let [t2 (replaced-t t (count-t typed))] ;; 代入先が被らないようにカウントアップ
		(match [typed]
			[(v :guard vector?)] (vec (map (fn [x] (complete-t x t2)) v))
			[e] (if (and (map? e) (contains? e "T") (some? (get t2 e))) (get t2 e) e))))

(defn type-lifted-normal [a] (let [t {"T" (+ 1 (count-t a))}] [t "/" [t "\\" a]]))
(defn type-lifted-reversed [a] (let [t {"T" (+ 1 (count-t a))}] [t "\\" [t "/" a]]))
															
(defn is-apply-func [s]
	(match [s]
		[[[p1 [a "/" b]] [p2 c]]] (is-compatible c b) ;; 関数適用規則
		[[[p1 a] [p2 [b "\\" c]]]] (is-compatible a c)
		:else false))

(defn is-merge-func [s]
	(match [s]
		[[[p1 [a "/" b]] [p2 args]]] ;; 一般化関数合成規則
		(and 
			(let [seps (take-nth 2 (rest args))] (apply = "/" seps))
			(is-compatible b (first args)))
		[[[p1 args] [p2 [a "\\" b]]]]
		(and 
			(let [seps (take-nth 2 (rest args))] (apply = "\\" seps))
			(is-compatible b (first args)))
		:else false))

(defn is-cross-func [s]
	(match [s]
		[[[p1 [[a "/" b] "\\" c] [p2 [d "\\" e]]]]] (and (is-compatible b d) (is-compatible c e)) ;; 関数交差置換規則
		[[[p1 [a "/" b]] [p2 [[c "\\" d] "/" e]]]] (and (is-compatible a d) (is-compatible b e))
		:else false))

(defn mix-normal [a] 
	(let [t {"T" (+ 1 (count-t a))}] 
		[[t "/" (get a 2)] "/" [t "/" (get a 0)]]))
(defn mix-reversed [a] 
	(let [t {"T" (+ 1 (count-t a))}] 
		[[t "\\" (get a 2)] "\\" [t "\\" (get a 0)]]))

(defn is-mix-func [s]
	(match [s]
		[[[p1 [a "/" args]] p2]]
		(and 
			(let [seps (take-nth 2 (rest args))] (apply = "\\" seps))
			(is-compatible a (first args)))
		[[[p1 [a "\\" args]] p2]]
		(and 
			(let [seps (take-nth 2 (rest args))] (apply = "/" seps))
			(is-compatible a (first args)))
		[[p1 [p2 [b "/" args]]]] 
		(and 
			(let [seps (take-nth 2 (rest args))] (apply = "\\" seps))
			(is-compatible b (first args)))
		[[p1 [p2 [b "\\" args]]]] 
		(and 
			(let [seps (take-nth 2 (rest args))] (apply = "/" seps))
			(is-compatible b (first args)))
		:else false
	))

(defn is-not-type-complex [depth a] (and (< depth 3) (< (count-t a) 10)))

(defn combine
	([s] (combine s " " 0))
	([s span depth]
		(match [s]
			[([[p1 [a "/" b]] [p2 c]] :guard is-apply-func)] ;; 関数適用規則
			#{[(str p1 span p2) (complete-t a (extract-t b c))]} 
			[([[p1 a] [p2 [b "\\" c]]] :guard is-apply-func)] 
			#{[(str p1 span p2) (complete-t b (extract-t c a))]}
			[([[p1 [a "/" b]] [p2 args]] :guard is-merge-func)] ;; 一般化関数合成規則
			#{[(str p1 span p2) 
				(let [e (extract-t b (first args))] (vec (concat [(complete-t a e) "/"] (vec (map (fn [x] (complete-t x e)) (rest (rest args)))))))]}
			[([[p1 args] [p2 [a "\\" b]]] :guard is-merge-func)]
			#{[(str p1 span p2) 
				(let [e (extract-t b (first args))] (vec (concat [(complete-t a e) "\\"] (vec (map (fn [x] (complete-t x e)) (rest (rest args)))))))]}
			[([[p1 [[a "/" b] "\\" c] [p2 [d "\\" e]]]] :guard is-cross-func)] ;; 関数交差置換規則
			#{[(str p1 span p2) [a "/" e]]}
			[([[p1 [a "/" b]] [p2 [[c "\\" d] "/" e]]] :guard is-cross-func)]
			#{[(str p1 span p2) [c "/" b]]}
			[(ps :guard 
				(fn [x] (let [rels (take-nth 2 (rest x))] 
					(and 
						(every? (fn [r] (= (second r) "CONJ")) rels) 
						(apply = (map first rels))))))] 
			#{[(clojure.string/join " " (map first ps)) (second (first ps))]}
			[(full :guard empty?)] nil
			[(full :guard (fn [x] (and (vector? x) (> (count x) 2))))]
			(let [heads (combine [(get full 0) (get full 1)] span (+ depth 1)) tails (combine (vec (rest full)) span (+ depth 1))]
				(clojure.set/union
					 (reduce clojure.set/union (map (fn [h] (combine (vec (concat [h] (vec (rest (rest full))))) span (+ depth 1))) heads)) 
					 (reduce clojure.set/union (map (fn [t] (combine [(get full 0) t] span (+ depth 1))) tails))))
					 
			;; 一致しない場合、型繰り上げ規則を適用
			[[[p1 (a :guard (partial is-not-type-complex depth))] [p2 (b :guard (partial is-not-type-complex depth))]]] 
			(let [an (type-lifted-normal a) ar (type-lifted-reversed a) bn (type-lifted-normal b) br (type-lifted-reversed b)]
				(clojure.set/union
					(combine [[p1 an] [p2 b]] span (+ depth 1))
					(combine [[p1 ar] [p2 b]] span (+ depth 1))
					(combine [[p1 a] [p2 bn]] span (+ depth 1))
					(combine [[p1 a] [p2 br]] span (+ depth 1))
					(match [a]
						[[ap "/" args-a]] 
							(let [an (mix-normal a)] 
								(clojure.set/union
									(combine [[p1 an] [p2 b]] span (+ depth 1))
									(combine [[p1 an] [p2 bn]] span (+ depth 1))
									(combine [[p1 an] [p2 br]] span (+ depth 1))))
						[[ap "\\" args-a]] 
							(let [ar (mix-reversed a)] 
								(clojure.set/union
									(combine [[p1 ar] [p2 b]] span (+ depth 1))
									(combine [[p1 ar] [p2 bn]] span (+ depth 1))
									(combine [[p1 ar] [p2 br]] span (+ depth 1))))
						[_] nil
					)
					(match [b]
						[[bp "/" args-b]] 
							(let [bn (mix-normal b)] 
								(clojure.set/union
									(combine [[p1 a] [p2 bn]] span (+ depth 1))
									(combine [[p1 an] [p2 bn]] span (+ depth 1))
									(combine [[p1 ar] [p2 bn]] span (+ depth 1))))
						[[bp "\\" args-b]] 
							(let [br (mix-reversed b)]
								(clojure.set/union
									(combine [[p1 a] [p2 br]] span (+ depth 1))
									(combine [[p1 an] [p2 br]] span (+ depth 1))
									(combine [[p1 ar] [p2 br]] span (+ depth 1))))
						[_] nil
					))
				)
			[_] nil
	)))

(defn -main []
	(def NPga_ ["NP" #{:ga}])
	(def 太郎が_ ["太郎が" NPga_])
	(def 走る_ ["走る" ["S" "\\" NPga_]])
	
	(def NPni_ ["NP" #{:ni}])
	(def 花子に_ ["花子に" NPni_])
	(def 会った_ ["会った" [["S" "\\" NPga_] "\\" NPni_]])
	(def 花子に太郎が会った_ [ 花子に_ 太郎が_ 会った_ ])
	(doall (for [i (range 100)] (combine 花子に太郎が会った_)))
	)