(ns k16.kid
  (:require
   [clojure.string :as str])
  (:import
   [com.fasterxml.uuid Generators]
   [com.fasterxml.uuid NoArgGenerator]
   [com.fasterxml.uuid.impl UUIDUtil]
   com.kepler16.kid.Base58
   [java.time Instant]
   [java.util Random UUID]))

(set! *warn-on-reflection* true)

(defn- v7-generator
  ^NoArgGenerator
  ([]
   (v7-generator (Random.)))
  ([^Random random]
   (Generators/timeBasedEpochGenerator random)))

(defonce ^:private GENERATOR
  (delay (v7-generator)))

(defn- v7
  ([]
   (v7 @GENERATOR))
  ([^NoArgGenerator generator]
   (.generate generator)))

(defn uuid->kid [^UUID uuid]
  (-> uuid
      UUIDUtil/asByteArray
      Base58/encode))

(defn kid->uuid [^String kid]
  (let [kid_id (if (<= (.length kid) 22)
                 kid
                 (second (str/split kid #"_")))]
    (-> kid_id
        Base58/decode
        UUIDUtil/uuid)))

(defn- uuid->instant [^UUID uuid]
  (-> (.getMostSignificantBits uuid)
      (bit-shift-right 16)
      (Instant/ofEpochMilli)))

(defn generate-kid
  ([]
   (uuid->kid (v7)))
  ([prefix]
   (->> (v7)
        uuid->kid
        (str prefix "_"))))

(defn kid->instant [kid]
  (-> kid kid->uuid uuid->instant))
