package com.kepler16.kid;

import java.math.BigInteger;
import java.util.Arrays;

public class Base58 {
    public static final char[] ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".toCharArray();
    private static final char ENCODED_ZERO = ALPHABET[0];
    private static final int[] INDEXES = new int[128];

    public static String encode(byte[] input) {
        int zeros;
        if (input.length == 0) {
            return "";
        }
        for (zeros = 0; zeros < input.length && input[zeros] == 0; ++zeros) {
        }
        input = Arrays.copyOf((byte[])input, (int)input.length);
        char[] encoded = new char[input.length * 2];
        int outputStart = encoded.length;
        int inputStart = zeros;
        while (inputStart < input.length) {
            encoded[--outputStart] = ALPHABET[Base58.divmod(input, inputStart, 256, 58)];
            if (input[inputStart] != 0) continue;
            ++inputStart;
        }
        while (outputStart < encoded.length && encoded[outputStart] == ENCODED_ZERO) {
            ++outputStart;
        }
        while (--zeros >= 0) {
            encoded[--outputStart] = ENCODED_ZERO;
        }
        return new String(encoded, outputStart, encoded.length - outputStart);
    }

    public static byte[] decode(String input) throws Exception {
        int zeros;
        if (input.length() == 0) {
            return new byte[0];
        }
        byte[] input58 = new byte[input.length()];
        for (int i = 0; i < input.length(); ++i) {
            int digit;
            char c = input.charAt(i);
            int n = digit = c < '\u0080' ? INDEXES[c] : -1;
            if (digit < 0) {
                throw new Exception("Invalid address");
            }
            input58[i] = (byte)digit;
        }
        for (zeros = 0; zeros < input58.length && input58[zeros] == 0; ++zeros) {
        }
        byte[] decoded = new byte[input.length()];
        int outputStart = decoded.length;
        int inputStart = zeros;
        while (inputStart < input58.length) {
            decoded[--outputStart] = Base58.divmod(input58, inputStart, 58, 256);
            if (input58[inputStart] != 0) continue;
            ++inputStart;
        }
        while (outputStart < decoded.length && decoded[outputStart] == 0) {
            ++outputStart;
        }
        return Arrays.copyOfRange((byte[])decoded, (int)(outputStart - zeros), (int)decoded.length);
    }

    public static BigInteger decodeToBigInteger(String input) throws Exception {
        return new BigInteger(1, Base58.decode(input));
    }

    private static byte divmod(byte[] number, int firstDigit, int base, int divisor) {
        int remainder = 0;
        for (int i = firstDigit; i < number.length; ++i) {
            int digit = number[i] & 0xFF;
            int temp = remainder * base + digit;
            number[i] = (byte)(temp / divisor);
            remainder = temp % divisor;
        }
        return (byte)remainder;
    }

    static {
        Arrays.fill((int[])INDEXES, (int)-1);
        for (int i = 0; i < ALPHABET.length; ++i) {
            Base58.INDEXES[Base58.ALPHABET[i]] = i;
        }
    }
}
