(ns k16.glitch.impl
  (:import
   [k16.glitch Glitch]))

(set! *warn-on-reflection* true)

(defmacro ->glitch*
  ([glitch]
   `(->glitch* ~glitch nil))
  ([glitch cause]
   `(when-not (:message ~glitch)
      (throw (Glitch. {:code :glitch/incorrect-usage
                       :message "No :message provided for glitch"})))
   `(when-not (:code ~glitch)
      (throw (Glitch. {:code :glitch/incorrect-usage
                       :message "No :code provided for glitch"})))

   `(if ~cause
      (Glitch. ~glitch ~cause)
      (Glitch. ~glitch))))

(defn get-state [^Glitch glitch]
  (.state glitch))
