(ns k16.glitch.impl.glitch-exception
  (:gen-class
   :name k16.glitch.Glitch
   :extends java.lang.RuntimeException
   :implements [clojure.lang.ILookup clojure.lang.IExceptionInfo]
   :state state
   :init init
   :constructors {[clojure.lang.IPersistentMap] []
                  [clojure.lang.IPersistentMap Throwable] []}))

(set! *warn-on-reflection* true)

(defn -init
  ([data] (-init data nil))
  ([data cause]
   [[] (merge {:data {}} data {:cause cause})]))

(defn -getMessage [^k16.glitch.Glitch this]
  (:message (.state this)))

(defn -getCause [^k16.glitch.Glitch this]
  (:cause (.state this)))

(defn -getData [^k16.glitch.Glitch this]
  (select-keys (.state this) [:code :message :data]))

(defn -valAt [^k16.glitch.Glitch this k]
  (get (.state this) k))
