(ns keorn.persistent-memoizer
  (:require [taoensso.carmine :as car :refer [wcar]]))

(def memoizer-server {:pool {} :spec {}})

(defn redis-memoize-fn
  "Memoize to default Redis server. Numbers returned as strings."
  [f f-name]
  (fn [& args]
    (let [key-hash (hash [f-name args])]
      (or (car/wcar memoizer-server (car/get key-hash))
          (let [ret (apply f args)]
            (car/wcar memoizer-server (car/set key-hash ret))
            ret)))))

(defmacro redis-memoize
  "Find the name of function and memoize."
  [f]
  `(->> ~f var meta :name str (redis-memoize-fn f)))
