(ns keorn.persistent-memoizer
  (:require [taoensso.carmine :as car :refer [wcar]]))

(def memoizer-server {:pool {} :spec {}})

(defn redis-memoize
  "Memoize to default Redis server. Numbers returned as strings."
  [f]
  (fn [& args]
    (let [key-hash (hash [f args])]
      (or (car/wcar memoizer-server (car/get key-hash))
          (let [ret (apply f args)]
            (car/wcar memoizer-server (car/set key-hash ret))
            ret)))))
