var get_tag, p, sb;

goog.provide("com.keminglabs.SlicedBananas");

goog.require("goog.structs.Map");

p = function(x) {
  console.log(x);
  return x;
};

get_tag = function(literal_prefix, x) {
  var ks;

  if (x instanceof Object) {
    ks = Object.keys(x);
    if (ks.length === 1 && ks[0][0] === literal_prefix) {
      return Object.keys(x)[0].substring(1);
    }
  }
};

sb = null;

goog.scope(function() {
  sb = com.keminglabs.SlicedBananas;
  sb.LiteralPrefix = "#";
  sb.DefaultReader = function(tag, x) {
    throw "Tag '" + tag + "' not recognized";
  };
  sb.deserialize = function(tag_table, x) {
    var tag, tag_reader, val;

    tag = get_tag(sb.LiteralPrefix, x);
    if (tag) {
      tag_reader = tag_table[tag];
      val = x[Object.keys(x)[0]];
      if (tag_reader) {
        return tag_reader(val);
      } else {
        return sb.DefaultReader(tag, val);
      }
    } else if (goog.isArray(x)) {
      return x.map(function(v) {
        return sb.deserialize(tag_table, v);
      });
    } else if (goog.isObject(x)) {
      return goog.object.map(x, function(v, k) {
        return sb.deserialize(tag_table, v);
      });
    } else {
      return x;
    }
  };
  sb.DefaultTagTable = {
    "inst": function(x) {
      return new Date(Date.parse(x));
    }
  };
  sb.serialize = function(constructor_table, x) {
    var klass, res, serializer, tag, val, _ref;

    klass = x != null ? x.constructor : null;
    serializer = constructor_table.get(klass);
    if (serializer) {
      _ref = serializer(x), tag = _ref[0], val = _ref[1];
      res = {};
      res[sb.LiteralPrefix + tag] = val;
      return res;
    } else if (goog.isArray(x)) {
      return x.map(function(v) {
        return sb.serialize(constructor_table, v);
      });
    } else if (goog.isObject(x)) {
      return goog.object.map(x, function(v, k) {
        return sb.serialize(constructor_table, v);
      });
    } else {
      return x;
    }
  };
  sb.DefaultConstructorTable = new goog.structs.Map(Date, function(d) {
    return ["inst", d.toISOString()];
  });
  ;
});
