// Generated by CoffeeScript 1.6.1
var array_p, dom_p, explode_p, ignore_p, key_prefix, map_p, namespace_tag, number_p, p, re_namespace_sep, re_svg_tags, re_tag, re_whitespace, string_p, unify_p, whitespace_node_p, xmlns,
  __hasProp = {}.hasOwnProperty;

goog.require("goog.string");

goog.provide("singult.coffee");

goog.provide("singult.coffee.Unify");

goog.provide("singult.coffee.Ignore");

p = function(x) {
  console.log(x);
  return x;
};

re_tag = /([^\s\.#]+)(?:#([^\s\.#]+))?(?:\.([^\s#]+))?/;

re_svg_tags = /^(svg|g|rect|circle|clipPath|path|line|polygon|polyline|text|textPath)$/;

re_whitespace = /^\s+$/;

re_namespace_sep = /:(.+)/;

key_prefix = "\0";

xmlns = {
  xhtml: "http://www.w3.org/1999/xhtml",
  xlink: "http://www.w3.org/1999/xlink",
  svg: "http://www.w3.org/2000/svg",
  xml: "http://www.w3.org/XML/1998/namespace",
  xmlns: "http://www.w3.org/2000/xmlns"
};

namespace_tag = function(tag_str) {
  var nsp, tag, _ref;
  _ref = tag_str.split(":"), nsp = _ref[0], tag = _ref[1];
  if (tag != null) {
    return [xmlns[nsp] || nsp, tag];
  } else {
    if (tag_str.match(re_svg_tags)) {
      return [xmlns.svg, tag_str];
    } else {
      return [xmlns.xhtml, tag_str];
    }
  }
};

explode_p = function(v) {
  return v[0] === ":*:";
};

unify_p = function(x) {
  return (x != null) && (x instanceof singult.coffee.Unify);
};

ignore_p = function(x) {
  return (x != null) && (x instanceof singult.coffee.Ignore);
};

array_p = function(x) {
  return (x != null) && (x.forEach != null);
};

map_p = function(x) {
  return (x != null) && (!array_p(x)) && (!unify_p(x)) && (!ignore_p(x)) && (x instanceof Object);
};

dom_p = function(x) {
  return (x != null) && (x.nodeType != null);
};

string_p = function(x) {
  return (x != null) && (x.substring != null);
};

number_p = function(x) {
  return (x != null) && (x.toFixed != null);
};

whitespace_node_p = function($n) {
  return $n.nodeType === 8 || ($n.nodeType === 3 && $n.textContent.match(re_whitespace));
};

singult.coffee.style = function($e, m) {
  var k, v, _results;
  _results = [];
  for (k in m) {
    if (!__hasProp.call(m, k)) continue;
    v = m[k];
    _results.push($e.style[goog.string.toCamelCase(k)] = v);
  }
  return _results;
};

singult.coffee.properties = function($e, m) {
  var prop, v, _results;
  _results = [];
  for (prop in m) {
    if (!__hasProp.call(m, prop)) continue;
    v = m[prop];
    _results.push($e[prop] = v);
  }
  return _results;
};

singult.coffee.attr = function($e, attr_map) {
  var attr, k, ns, v, _ref, _results;
  if (attr_map["style"] != null) {
    singult.coffee.style($e, attr_map["style"]);
    delete attr_map["style"];
  }
  if (attr_map["properties"] != null) {
    singult.coffee.properties($e, attr_map["properties"]);
    delete attr_map["properties"];
  }
  if (array_p(attr_map["class"])) {
    $e.setAttribute("class", attr_map["class"].join(" "));
    delete attr_map["class"];
  }
  _results = [];
  for (k in attr_map) {
    if (!__hasProp.call(attr_map, k)) continue;
    v = attr_map[k];
    if (v != null) {
      _ref = k.split(re_namespace_sep), ns = _ref[0], attr = _ref[1];
      if (attr != null) {
        _results.push($e.setAttributeNS(xmlns[ns] || ns, attr, v));
      } else {
        _results.push($e.setAttribute(k, v));
      }
    } else {
      _results.push($e.removeAttribute(k));
    }
  }
  return _results;
};

singult.coffee.node_data = function($e, d) {
  if (d != null) {
    return $e["__singult_data__"] = d;
  } else {
    return $e["__singult_data__"];
  }
};

singult.coffee.canonicalize = function(x) {
  if (number_p(x)) {
    return x.toString();
  } else if (array_p(x)) {
    return singult.coffee.canonicalize_hiccup(x);
  } else {
    return x;
  }
};

singult.coffee.canonicalize_hiccup = function(v) {
  var abbreviated_classes, attr, canonical, canonical_children, children, cls_str, id, nsp, tag, tag_str, _, _ref, _ref1, _ref2;
  tag = v[0];
  _ref = map_p(v[1]) ? [v[1], v.slice(2)] : [{}, v.slice(1)], attr = _ref[0], children = _ref[1];
  _ref1 = tag.match(re_tag), _ = _ref1[0], tag_str = _ref1[1], id = _ref1[2], cls_str = _ref1[3];
  if (id != null) {
    attr["id"] = id;
  }
  if (cls_str != null) {
    abbreviated_classes = cls_str.split(".");
    if (array_p(attr["class"])) {
      attr["class"] = attr["class"].concat(abbreviated_classes);
    } else if (string_p(attr["class"])) {
      attr["class"] = abbreviated_classes.concat([attr["class"]]);
    } else if (attr["class"] == null) {
      attr["class"] = abbreviated_classes;
    }
  }
  _ref2 = namespace_tag(tag_str), nsp = _ref2[0], tag = _ref2[1];
  canonical_children = [];
  children.forEach(function(v) {
    if (v != null) {
      if (explode_p(v)) {
        return v.slice(1).forEach(function(v) {
          return canonical_children.push(singult.coffee.canonicalize(v));
        });
      } else {
        return canonical_children.push(singult.coffee.canonicalize(v));
      }
    }
  });
  canonical = {
    nsp: nsp,
    tag: tag,
    attr: attr,
    children: canonical_children
  };
  return canonical;
};

singult.coffee.render = function(m) {
  var $e, c;
  if (unify_p(m)) {
    throw new Error("Unify must be the first and only child of its parent.");
  } else if (ignore_p(m)) {
    return null;
  } else if (string_p(m)) {
    return document.createTextNode(m);
  } else if (dom_p(m)) {
    return m;
  } else {
    $e = document.createElementNS(m.nsp, m.tag);
    singult.coffee.attr($e, m.attr);
    if (unify_p((c = m.children[0]))) {
      if (c.enter != null) {
        c.data.forEach(function(d) {
          var $el;
          $el = c.enter(d);
          singult.coffee.node_data($el, d);
          return $e.appendChild($el);
        });
      } else {
        c.data.forEach(function(d) {
          var $el;
          $el = singult.coffee.render(singult.coffee.canonicalize(c.mapping(d)));
          singult.coffee.node_data($el, d);
          return $e.appendChild($el);
        });
      }
    } else {
      m.children.forEach(function(c) {
        var $c;
        $c = singult.coffee.render(c);
        if ($c != null) {
          return $e.appendChild($c);
        }
      });
    }
    return $e;
  }
};

/**
 * @constructor
 */;

singult.coffee.Unify = function(data, mapping, key_fn, enter, update, exit, force_update_p) {
  this.data = data;
  this.mapping = mapping;
  this.key_fn = key_fn;
  this.enter = enter;
  this.update = update;
  this.exit = exit;
  this.force_update_p = force_update_p;
  return this;
};

/**
 * @constructor
 */;

singult.coffee.Ignore = function() {
  return this;
};

singult.coffee.unify_ = function($container, u) {
  var $nodes, data_len, data_map, data_to_key, enter, exit, i, insert_at, key, key_fn, maybe_do_update, node_to_key, nodes_to_keep, update;
  enter = u.enter || function(d) {
    var $el;
    $el = singult.coffee.render(singult.coffee.canonicalize(u.mapping(d)));
    $container.appendChild($el);
    return $el;
  };
  update = u.update || function($n, d) {
    return singult.coffee.merge($n, singult.coffee.canonicalize(u.mapping(d)));
  };
  exit = u.exit || function($n) {
    return $container.removeChild($n);
  };
  key_fn = u.key_fn || function(d, idx) {
    return idx;
  };
  $nodes = $container.childNodes;
  data_to_key = function(d, i) {
    return key_prefix + key_fn(d, i);
  };
  node_to_key = function($n, i) {
    return data_to_key(singult.coffee.node_data($n), i);
  };
  maybe_do_update = function($n, d) {
    var $el, identical_data_p, old_data;
    if (u.force_update_p) {
      $el = update($n, d);
      return singult.coffee.node_data($el, d);
    } else {
      old_data = singult.coffee.node_data($n);
      identical_data_p = old_data.cljs$core$IEquiv$_equiv$arity$2 != null ? old_data.cljs$core$IEquiv$_equiv$arity$2(old_data, d) : old_data === d;
      if (!identical_data_p) {
        $el = update($n, d);
        return singult.coffee.node_data($el, d);
      }
    }
  };
  insert_at = function($n, i) {
    if (i < $nodes.length) {
      return $container.insertBefore($n, $nodes[i]);
    } else {
      return $container.appendChild($n);
    }
  };
  data_map = {};
  u.data.forEach(function(d, i) {
    var key;
    key = data_to_key(d, i);
    return data_map[key] = d;
  });
  nodes_to_keep = {};
  i = 0;
  while (i < $nodes.length) {
    key = node_to_key($nodes[i], i);
    if (data_map[key]) {
      nodes_to_keep[key] = $nodes[i];
    }
    i += 1;
  }
  u.data.forEach(function(d, i) {
    var $el, $n, d_key, n_key;
    $n = i < $nodes.length ? $nodes[i] : void 0;
    n_key = $n ? node_to_key($n, i) : void 0;
    d_key = data_to_key(d, i);
    if ($n == null) {
      $el = enter(d);
      return singult.coffee.node_data($el, d);
    } else if (n_key === d_key) {
      return maybe_do_update($nodes[i], d);
    } else {
      if (!nodes_to_keep[n_key]) {
        exit($n);
      }
      if (nodes_to_keep[d_key]) {
        $el = nodes_to_keep[d_key];
        insert_at($el, i);
        return maybe_do_update($el, d);
      } else {
        $el = enter(d);
        insert_at($el, i);
        return singult.coffee.node_data($el, d);
      }
    }
  });
  data_len = u.data.length;
  while (data_len < $nodes.length) {
    exit($nodes[data_len]);
  }
  return null;
};

singult.coffee.merge = function($e, m) {
  var $c, c, i, _i, _j, _ref, _ref1;
  if (unify_p(m)) {
    singult.coffee.unify_($e, m);
  } else if (ignore_p(m)) {

  } else {
    if ($e.nodeName.toLowerCase() !== m.tag.toLowerCase()) {
      p($e);
      p(m);
      throw new Error("Cannot merge $e into node of different type");
    }
    singult.coffee.attr($e, m.attr);
    if ($e.hasChildNodes()) {
      for (i = _i = _ref = $e.childNodes.length - 1; _ref <= 0 ? _i <= 0 : _i >= 0; i = _ref <= 0 ? ++_i : --_i) {
        $c = $e.childNodes[i];
        if (whitespace_node_p($c)) {
          $e.removeChild($c);
        }
      }
    }
    if (unify_p(m.children[0])) {
      singult.coffee.merge($e, m.children[0]);
    } else {
      if ($e.childNodes.length > m.children.length) {
        for (i = _j = _ref1 = $e.childNodes.length - 1; _ref1 <= 0 ? _j <= 0 : _j >= 0; i = _ref1 <= 0 ? ++_j : --_j) {
          $e.removeChild($e.childNodes[i]);
        }
      }
      i = 0;
      while (i < m.children.length) {
        c = m.children[i] || "";
        $c = $e.childNodes[i];
        if (string_p(c)) {
          if ($c != null) {
            $c.textContent = c;
          } else {
            $e.appendChild(document.createTextNode(c));
          }
        } else if (ignore_p(c)) {

        } else if (map_p(c)) {
          if ($c != null) {
            singult.coffee.merge($c, c);
          } else {
            $e.appendChild(singult.coffee.render(c));
          }
        } else {
          p($c);
          p(c);
          throw new Error("Cannot merge children");
        }
        i += 1;
      }
    }
  }
  return $e;
};
