(ns com.keminglabs.util.async
  (:require [clojure.core.async :refer [go >! >!! <! close! alt!! timeout]]
            [cheshire.core :as json]))


(defn <!!
  "Like <!!, but with an optional timeout.
Why is this not in core.async, yo?"
  ([port]
     (clojure.core.async/<!! port))
  ([port timeout-ms timeout-val]
     (alt!!
       (timeout timeout-ms) ([_] timeout-val)
       port ([val] val))))

(defn >!!x
  "Blocking send `msg` on `channel` and then close it."
  [channel msg]
  (>!! channel msg)
  (close! channel))

(defn >!x
  "Send `msg` on `channel` and then close it."
  [channel msg]
  (>! channel msg)
  (close! channel))

(defn chan->seq
  "Consumes a channel (thread-blocking), returning the results in a lazy seq."
  [c]
  (lazy-seq
    (let [x (<!! c 100 nil)]
        (if (nil? x)
          x
          (cons x (chan->seq c))))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;TODO: these are copy/pasted from fox util; put them somewhere useful.
(defn map-into
  "Forwards `(f (<! recv))` to `send`; returns `send` for convenience."
  [send f recv]
  (go (loop []
        (let [val (<! recv)]
          (when-not (nil? val)
            (>! send (f val))
            (recur)))))
  send)

(defn json-deserialization-chan
  [send recv]
  (map-into send #(json/parse-string % true) recv))

(defn json-serialization-chan
  [send recv]
  (map-into send #(json/generate-string %) recv))


(defn recv-router-chan
  [send recv]
  (map-into send (fn [[id _ msg]]
                   {:id id :msg (json/parse-string (String. msg) true)})
            recv))

(defn send-router-chan
  [send recv]
  (map-into send (fn [{:keys [id msg]}]
                   [id (byte-array 0)
                    (if (string? msg)
                      msg (json/generate-string msg))])
            recv))