(ns com.keminglabs.util.zmq
  (:require [clojure.core.async :refer [>!! <!! chan close!]]
            [com.keminglabs.zmq-async.core :refer [register-socket!]]
            [cheshire.core :as json]))

(defn zmq-json-request
  "Serializes `msg` as JSON and makes a request to `addr`, returning a future of the (json deserialized) reply."
  [addr msg]
  (let [in (chan) out (chan)]
    (register-socket! {:in in :out out :socket-type :req
                       :configurator #(.connect % addr)})

    (>!! in (json/generate-string msg))
    (future
      (let [res (String. (<!! out))]
        (close! in)
        (try
          (json/parse-string res true)
          (catch Throwable e
            res))))))