goog.provide('Cl.Strength');

goog.require('Cl');
goog.require('Cl.SymbolicWeight');

goog.scope(function() {

;
;
/**
 * @constructor
 */
Cl.Strength = function(_name, symbolicWeight, w2, w3) {
  this._name = _name;
  if (symbolicWeight instanceof Cl.SymbolicWeight) {
    this._symbolicWeight = symbolicWeight;
  } else {
    this._symbolicWeight = new Cl.SymbolicWeight(symbolicWeight, w2, w3);
  }
};

Cl.Strength.prototype.isRequired = function() {
  return this === Cl.Strength.required;
};
Cl.Strength.prototype.toString = function() {
  return this._name + (!this.isRequired() ? ":" + this.symbolicWeight() : "");
};
Cl.Strength.prototype.symbolicWeight = function() {
  return this._symbolicWeight;
};
Cl.Strength.prototype.name = function() {
  return this._name;
};
Cl.Strength.prototype.set_name = function(_name) {
  this._name = _name;
};
Cl.Strength.prototype.set_symbolicWeight = function(_symbolicWeight) {
  this._symbolicWeight = _symbolicWeight;
};;
Cl.Strength.required = new Cl.Strength("<Required>", 1000, 1000, 1000);
Cl.Strength.strong = new Cl.Strength("strong", 1.0, 0.0, 0.0);
Cl.Strength.medium = new Cl.Strength("medium", 0.0, 1.0, 0.0);
Cl.Strength.weak = new Cl.Strength("weak", 0.0, 0.0, 1.0);

}); // close goog.scope()
