goog.provide('Cl.HashTable');

goog.require('Cl');

goog.scope(function() {

;
/**
 * @constructor
 */
Cl.HashTable = function() {
  this._size = 0;
  this._store = {};
  this._keyStrMap = {};
  this._keyList = [];
};

Cl.HashTable.prototype.put = function(key, value) {
  var hash, old;
  hash = this._keyCode(key);
  old = this._store.hasOwnProperty(hash) ? this._store[hash] : this._size++;
  this._store[hash] = value;
  this._keyStrMap[hash] = key;
  if (this._keyList.indexOf(hash) === -1) {
    this._keyList.push(hash);
  }
  return old;
};
Cl.HashTable.prototype.get = function(key) {
  if (!(this._size > 0)) {
    return null;
  }
  key = this._keyCode(key);
  if (this._store.hasOwnProperty(key)) {
    return this._store[key];
  }
  return null;
};
Cl.HashTable.prototype.clear = function() {
  this._size = 0;
  this._store = {};
  this._keyStrMap = {};
  return this._keyList = [];
};
Cl.HashTable.prototype.remove = function(key) {
  var old;
  key = this._keyCode(key);
  if (!this._store.hasOwnProperty(key)) {
    return null;
  }
  old = this._store[key];
  delete this._store[key];
  if (this._size > 0) {
    this._size--;
  }
  return old;
};
Cl.HashTable.prototype.size = function() {
  return this._size;
};
Cl.HashTable.prototype.keys = function() {
  return this._keyList.map(goog.bind(function(x) {
    return this._keyStrMap[x];
  }, this));
};
Cl.HashTable.prototype.each = function(callback, scope) {
  if (!this._size) {
    return;
  }
  return this._keyList.forEach((function(k) {
    if (this._store.hasOwnProperty(k)) {
      return callback.call(scope || null, this._keyStrMap[k], this._store[k]);
    }
  }), this);
};
Cl.HashTable.prototype._escapingEachCallback = function(callback, scope, key, value) {
  var hash;
  hash = this._keyCode(key);
  if (this._store.hasOwnProperty(hash)) {
    return callback.call(scope || null, hash, value);
  }
};
Cl.HashTable.prototype.escapingEach = function(callback, scope) {
  var context, kl, x, _results;
  if (!(this._size > 0)) {
    return;
  }
  context = {};
  kl = this._keyList.slice();
  x = 0;
  _results = [];
  while (x < kl.length) {
    (goog.bind(function(v) {
      if (this._store.hasOwnProperty(v)) {
        return context = callback.call(scope || null, this._keyStrMap[v], this._store[v]);
      }
    }, this))(kl[x]);
    if (context) {
      if (context.retval !== undefined) {
        return context;
      }
      if (context.brk) {
        break;
      }
    }
    _results.push(x++);
  }
  return _results;
};
Cl.HashTable.prototype.clone = function() {
  var n;
  n = new Cl.HashTable();
  if (this._size > 0) {
    n._size = this._size;
    n._keyList = this._keyList.slice();
    this._copyOwn(this._store, n._store);
    this._copyOwn(this._keyStrMap, n._keyStrMap);
  }
  return n;
};
Cl.HashTable.prototype._keyCode = function(key) {
  if (typeof key.hashCode === "function") {
    return key.hashCode();
  } else {
    return key.toString();
  }
};
Cl.HashTable.prototype._copyOwn = function(src, dest) {
  var x, _results;
  _results = [];
  for (x in src) {
    _results.push(src.hasOwnProperty(x) ? dest[x] = src[x] : void 0);
  }
  return _results;
};;

}); // close goog.scope()
