;;This file autogenerated from 
;;
;;  src/cljx/c2/geo/core.cljx
;;
(ns c2.geo.core (:use [c2.maths :only [rad sq sqrt sin asin cos radians-per-degree]] [clojure.core.match :only [match]] [clojure.string :only [join]]))
(defn geo->svg "Convert geoJSON to SVG path data.\n\n   Kwargs:\n   > *:projection* fn applied to each coordinate, defaults to identity" [geo & {:keys [projection], :or {projection identity}}] (let [project (fn [coordinate] (join "," (projection coordinate))) coords->path (fn [coordinates] (str "M" (join "L" (map project coordinates)) "Z"))] (match [geo] [{:type "FeatureCollection", :features xs}] (join (map (fn* [p1__3906#] (geo->svg p1__3906# :projection projection)) xs)) [{:type "Feature", :geometry g}] (geo->svg g :projection projection) [{:type "Polygon", :coordinates xs}] (join (map coords->path xs)) [{:type "MultiPolygon", :coordinates xs}] (join (map (fn [subpoly] (join (map coords->path subpoly))) xs)))))
(defn ->latlon "Convert coordinates (potentially map of `{:lat :lon}`) to 2-vector." [coordinates] (match [coordinates] [[lat lon]] [lat lon] [{:lat lat, :lon lon}] [lat lon]))
(def radius-of-earth "Radius of OUR AWESOME PLANET, in kilometers" 6378.1)
(defn haversine "Calculate the great-circle distance between two lat/lon coordinates on a sphere with radius `r` (defaults to Earth radius)." ([co1 co2] (haversine co1 co2 radius-of-earth)) ([co1 co2 r] (let [[lat1 lon1] (->latlon co1) [lat2 lon2] (->latlon co2) square-half-chord (+ (sq (sin (/ (rad (- lat2 lat1)) 2))) (* (cos (rad lat1)) (cos (rad lat2)) (sq (sin (/ (rad (- lon2 lon1)) 2))))) angular-distance (* (asin (sqrt square-half-chord)) 2)] (* angular-distance r))))