;;This file autogenerated from 
;;
;;  src/cljx/c2/ticks.cljx
;;
(ns c2.ticks (:use [c2.maths :only [sq ceil floor log10 expt irange within?]] [iterate :only [iter]]))
(def Q "Preference-ordered list of nice step sizes" [1 5 2 2.5 4 3])
(defn index-of "Index of x in coll" [x coll] (first (for [[idx y] (map-indexed vector coll) :when (= y x)] idx)))
(defn label-range-contains-zero? [l-min l-max l-step] (and (> l-max 0) (< l-min 0) (zero? (mod l-min l-step))))
(defn simplicity "Objective function modeling niceness of step sizes and whether a range includes zero" [q j label-range-contains-zero] (let [v (if label-range-contains-zero 1 0)] (if (<= (count Q) 1) (+ (- 1 j) v) (+ (- 1 (/ (index-of q Q) (dec (count Q))) j) v))))
(defn max-simplicity [q j] (simplicity q j true))
(defn coverage "Objective function based on distances between extreme data and extreme labels" [d-min d-max l-min l-max] (- 1 (* 0.5 (/ (+ (sq (- d-max l-max)) (sq (- d-min l-min))) (sq (* 0.1 (- d-max d-min)))))))
(defn max-coverage "When the label range is centered on the data range" [d-min d-max span] (let [d-range (- d-max d-min)] (if (> span d-range) (- 1 (sq (/ (- span d-range) (* 0.2 d-range)))) 1)))
(defn density "Objective function for a candidate density `r` and desired density `rt` (e.g. labels-per-cm)" [r rt] (- 2 (max (/ r rt) (/ rt r))))
(defn max-density [r rt] (if (>= r rt) (- 2 (/ r rt)) 1))
(defn- w "Balance the relative merits of different metrics" [[simplicity coverage density legibility]] (let [w [0.2 0.25 0.5 0.05]] (+ (* simplicity (w 0)) (* coverage (w 1)) (* density (w 2)) (* legibility (w 3)))))
(defn search "Find best ticks for the data range `[d-min, d-max]`.\n   Returns a map with `{:min :max :step :extent :ticks}` of optimal labeling (if one is found).\n   Returns an empty map if no labelings can be found.\n\n   Kwargs:\n\n   > *:target-density* labels per length, defaults to 0.01 (one label per 100 units)\n\n   > *:length* available label spacing\n\n   > *:clamp?* don't return ticks outside of data range, defaults to false.\n\n  Since there are no test input/output datasets for the labeling algorithm, I played it safe and copied the imperative algorithm from the paper.\n  If you rewrite it in an understandable and performant functional style, I'll accept a pull request and buy you a bottle of whiskey." [[d-min d-max] & {:keys [target-density length clamp?], :or {target-density 0.01, length 500, clamp? false}}] (let [best-score (atom -2) label (atom {})] (iter {for q, in Q} (iter {for j, from 1} {for ms, = (max-simplicity q j)} {return-if (< (w [ms 1 1 1]) (clojure.core/deref best-score))} (iter {for k, from 2} {for md, = (max-density (/ k length) target-density)} {return-if (< (w [ms 1 md 1]) (clojure.core/deref best-score))} (let [delta (/ (- d-max d-min) (* (inc k) j k))] (iter {for z, from (ceil (log10 delta))} {for l-step, = (* q j (expt 10 z))} {for mc, = (max-coverage d-min d-max (* (dec k) l-step))} {return-if (< (w [ms mc md 1]) (clojure.core/deref best-score))} (iter {for start, from (- (floor (/ d-max l-step)) (dec k)), to (/ d-min l-step), by (/ 1 j)} {for l-min, = (* start l-step)} {for l-max, = (+ l-min (* (dec k) l-step))} {for s, = (simplicity q j (label-range-contains-zero? l-min l-max l-step))} {for c, = (coverage d-min d-max l-min l-max)} {for d, = (density (/ k length) target-density)} {for score, = (w [s c d 1])} {return-if (< score (clojure.core/deref best-score))} (reset! best-score score) (reset! label {:min l-min, :max l-max, :step l-step}))))))) (let [l (clojure.core/deref label) extent [(if clamp? d-min (min (:min l) d-min)) (if clamp? d-max (max (:max l) d-max))]] {:extent extent, :min (first extent), :max (second extent), :ticks (filter (fn* [p1__54494#] (within? p1__54494# extent)) (irange (:min l) (:max l) (:step l)))})))