;;This file autogenerated from 
;;
;;  src/cljx/c2/svg.cljx
;;
(ns c2.svg (:use-macros [clojure.core.match.js :only [match]]) (:use [c2.maths :only [Pi Tau radians-per-degree sin cos]]) (:require [c2.dom :as dom]))
(defn translate [coordinates] (match [coordinates] [[x y]] (str "translate(" x "," y ")") [{:x x, :y y}] (recur [x y])))
(defn scale [coordinates] (match [coordinates] [[x y]] (str "scale(" x "," y ")") [{:x x, :y y}] (recur [x y]) [s] (str "scale(" s ")")))
(defn get-bounds "Returns map of {:x :y :width :height} containing SVG element bounding box.\n   All coordinates are in userspace. See: http://www.w3.org/TR/SVG/types.html#InterfaceSVGLocatable" [$svg-el] (let [b (.getBBox $svg-el)] {:x (.-x b), :y (.-y b), :width (.-width b), :height (.-height b)}))
(defn transform-to-center "Returns a transform string that will scale and center provided element {:width :height :x :y} within container {:width :height}." [element container] (let [{ew :width, eh :height, x :x, y :y} element {w :width, h :height} container s (min (/ h eh) (/ w ew))] (str (translate [(- (/ w 2) (* s (/ ew 2))) (- (/ h 2) (* s (/ eh 2)))]) " " (scale s) " " (translate [(- x) (- y)]))))
(defn transform-to-center! "Scales and centers $svg-el within its parent SVG container.\n   Uses parent's width and height attributes only." [$svg-el] (let [$svg (.-ownerSVGElement $svg-el) t (transform-to-center (get-bounds $svg-el) {:width (js/parseFloat (dom/attr $svg :width)), :height (js/parseFloat (dom/attr $svg :height))})] (dom/attr $svg-el :transform t)))
(defn axis "Returns axis <g> for input scale with ticks.\nDirection away from the data frame is defined to be positive; use negative margins and widths for the axis to render inside of the data frame" [scale ticks & {:keys [orientation formatter major-tick-width text-margin], :or {orientation :left, formatter str, major-tick-width 6, text-margin 9}}] (let [[x y x1 x2 y1 y2] (match [orientation] [(:or :left :right)] [:x :y :x1 :x2 :y1 :y2] [(:or :top :bottom)] [:y :x :y1 :y2 :x1 :x2]) parity (match [orientation] [(:or :left :top)] -1 [(:or :right :bottom)] 1)] (into [:g.axis {:class (name orientation)} [:line.rule (apply hash-map (interleave [y1 y2] (:range scale)))]] (map (fn [d] [:g.major-tick {:transform (translate {x 0, y (scale d)})} [:text {x (* parity text-margin)} (formatter d)] [:line {x1 0, x2 (* parity major-tick-width)}]]) ticks))))
(def ArcMax (- Tau 1.0E-7))
(defn circle "Returns svg path data for a circle starting at 3 o'clock and sweeping in positive y." ([radius] (circle [0 0] radius)) ([[x y] radius] (str "M" (+ x radius) "," y "A" (+ x radius) "," (+ y radius) " 0 1,1" (- (+ x radius)) "," y "A" (+ x radius) "," (+ y radius) " 0 1,1" (+ x radius) "," y)))
(defn arc [& {:keys [inner-radius outer-radius start-angle end-angle angle-offset], :or {inner-radius 0, outer-radius 1, start-angle 0, end-angle Pi, angle-offset 0}}] (let [r0 inner-radius r1 outer-radius [a0 a1] (sort [(+ angle-offset start-angle) (+ angle-offset end-angle)]) da (- a1 a0) large-arc-flag (if (< da Pi) "0" "1") s0 (sin a0) c0 (cos a0) s1 (sin a1) c1 (cos a1)] (if (>= da ArcMax) (str "M0," r1 "A" r1 "," r1 " 0 1,1 0," (- r1) "A" r1 "," r1 " 0 1,1 0," r1 (if (not= 0 r0) (str "M0," r0 "A" r0 "," r0 " 0 1,0 0," (- r0) "A" r0 "," r0 " 0 1,0 0," r0)) "Z") (str "M" (* r1 c0) "," (* r1 s0) "A" r1 "," r1 " 0 " large-arc-flag ",1 " (* r1 c1) "," (* r1 s1) (if (not= 0 r0) (str "L" (* r0 c1) "," (* r0 s1) "A" r0 "," r0 " 0 " large-arc-flag ",0 " (* r0 c0) "," (* r0 s0)) "L0,0") "Z"))))