;;This file autogenerated from 
;;
;;  src/cljx/c2/maths.cljx
;;
(ns c2.maths (:use-util [c2.macros :only [combine-with]]))
(def Pi 3.141592653589793)
(def Tau (* 2 Pi))
(def radians-per-degree (/ Pi 180))
(defn sin [x] (Math/sin x))
(defn cos [x] (Math/cos x))
(defn tan [x] (Math/tan x))
(defn expt ([x] (Math/exp x)) ([x y] (Math/pow x y)))
(defn sq [x] (expt x 2))
(defn sqrt [x] (Math/sqrt x))
(defn floor [x] (Math/floor x))
(defn ceil [x] (Math/ceil x))
(defn abs [x] (Math/abs x))
(defn log ([x] (Math/log x)) ([base x] (/ (Math/log x) (Math/log base))))
(defn log10 [x] (/ (.log js/Math x) (.-LN10 js/Math)))
(defn extent "Returns 2-vector of min and max elements in xs." [xs] [(apply min xs) (apply max xs)])
(defn irange "Inclusive range; same as core/range, but includes the end." ([start] (range start)) ([start end] (concat (range start end) [end])) ([start end step] (concat (range start end step) [end])))
(defn add ([& args] (reduce (fn [A B] (combine-with A B clojure.core/+ add)) args)))
(defn sub ([& args] (if (= (count args) 1) (combine-with 0 (first args) clojure.core/- sub) (reduce (fn [A B] (combine-with A B clojure.core/- sub)) args))))
(defn mul ([& args] (reduce (fn [A B] (combine-with A B clojure.core/* mul)) args)))
(defn div ([& args] (if (= (count args) 1) (combine-with 1 (first args) clojure.core// div) (reduce (fn [A B] (combine-with A B clojure.core// div)) args))))