(ns snmp4clj.pdu
  (:import [org.snmp4j Snmp PDUv1 PDU ScopedPDU]
           [org.snmp4j.smi OID VariableBinding]))

(defn init-pdu [pdu type oids]
  (doto pdu
    (.setType type)
    (.addAll
     (into-array VariableBinding
                 (map #(VariableBinding. (OID. %)) oids)))))

(defmulti create-pdu
  (fn [v & _]
    (if (contains? #{:v1 :v2c :v3} v) v :v2c)))

(defmethod create-pdu :v1
  [_ type oids]
  (init-pdu (PDUv1.) type oids))

(defmethod create-pdu :default
  [_ type oids]
  (init-pdu (PDU.) type oids))

(defmethod create-pdu :v3
  [_ type oids]
  (init-pdu (ScopedPDU.) type oids))
