(ns shannon.type-registration
  (:require [shannon.coding-primitives :refer [Codeable encode decode]]
            [shannon.compatibility :refer [is-boolean? is-date? is-float?]]
            [shannon.polymorphic-coders :refer [default-coder register-type!
                                                list-coder vec-coder map-coder
                                                set-coder]]
            [shannon.base-coders :refer [nil-coder booleancoder symbol-coder
                                         date-coder adaptive-string-coder
                                         keyword-coder int64coder doublecoder]])
  (      :use                        [shannon.register-type :as m]))

(def atom-pr 1.)
(def coll-pr 1.)

;; Standard atoms
(m/register-polymorphic-type! :nil, nil, :pr atom-pr, :coder nil-coder, :test nil?)

(m/register-polymorphic-type! :boolean,
                                    java.lang.Boolean
                                            ,
                              :pr atom-pr, :coder booleancoder, :test is-boolean?)

(m/register-polymorphic-type! :symbol,
                                    clojure.lang.Symbol
                                                     ,
                              :pr atom-pr, :coder symbol-coder, :test symbol?)

(m/register-polymorphic-type! :date,
                                    [org.joda.time.DateTime java.util.Date]
                                                                                ,
                              :pr atom-pr, :coder date-coder, :test is-date?)

(m/register-polymorphic-type! :string,
                                    java.lang.String,
                                           ,
                              :pr atom-pr, :coder adaptive-string-coder, :test string?)

(m/register-polymorphic-type! :keyword,
                                    clojure.lang.Keyword,
                                                      ,
                              :pr atom-pr, :coder keyword-coder, :test keyword?)

     
(do
  (m/register-polymorphic-type! :integer,
                                java.lang.Long,
                                :pr atom-pr, :coder int64coder, :test integer?)
  (m/register-polymorphic-type! :float,
                                java.lang.Double,
                                :pr atom-pr, :coder doublecoder, :test float?))

      
                                                                                     
                                          
                                                                  
                                        
                                                                   
                           
          
                                                                               
                                             

;; Standard collections
(m/register-polymorphic-type! :list,
                                    [clojure.lang.PersistentList,
                                     clojure.lang.PersistentList$EmptyList,
                                     clojure.lang.LazySeq],
                                                     
                                                          
                                                        ,
                              :pr coll-pr, :coder list-coder, :test list?)

(m/register-polymorphic-type! :vector,
                                    clojure.lang.PersistentVector,
                                                               ,
                              :pr coll-pr, :coder vec-coder, :test vector?)

(m/register-polymorphic-type! :map,
                                    [clojure.lang.PersistentArrayMap,
                                     clojure.lang.PersistentHashMap,
                                     clojure.lang.PersistentHashMap$TransientHashMap,
                                     clojure.lang.PersistentTreeMap],
                                                                   
                                                                  
                                                                 
                                                                  ,
                              :pr coll-pr, :coder map-coder, :test map?)

(m/register-polymorphic-type! :set,
                                    [clojure.lang.PersistentHashSet,
                                     clojure.lang.PersistentHashSet$TransientHashSet,
                                     clojure.lang.PersistentTreeSet],
                                                                  
                                                                 
                                                                  ,
                              :pr coll-pr, :coder set-coder, :test set?)

;;;;;;;;;;;; This file autogenerated from src/cljx/shannon/type_registration.cljx
