(ns shannon.io
       
  (import [com.github.jinahya.io.bit BitInput BitOutput StreamInput StreamOutput
           BufferInput BufferOutput ChannelInput ChannelOutput]
          [java.io Closeable InputStream OutputStream ByteArrayInputStream
           ByteArrayOutputStream EOFException]
          [java.nio ByteBuffer]
          [java.nio.channels Channel ReadableByteChannel WritableByteChannel]))

(defprotocol EmitsBits
  (read! [o])
  (source [o]))

(defprotocol ConsumesBits
  (write! [o bit])
  (target [o]))

(defprotocol BitCoder
  (with-bits! [c bits])
  (finalize! [c]))

(defprotocol AsBits
  (bit-source [o])
  (bit-sink [o]))

     
(deftype JavaBitSource [^BitInput input]
  EmitsBits
  (read! [_]
    (try
      (.readBoolean input)
      (catch EOFException e
        nil)))
  (source [_] (.getSource (.getInput input)))

  Closeable
  (close [o] (.close input)))

     
(deftype JavaBitSink [^BitOutput output]
  ConsumesBits
  (write! [o bit] (.writeBoolean output bit))
  (target [o] (.getTarget (.getOutput output)))

  BitCoder
  (finalize! [c] (.align output 1))

  Closeable
  (close [o] (.close output)))

      
                                           
           
                            
                     

      
                                          
              
                                     
                     

          
                         

      
                                                                                 
           
            
                      
                                            
                       
             
                                                    
                               
                                     
              
                     

      
                            
                                             

      
                                                                                  
              
                 
                         
                                                   
                                                                  
                     
         
                                   
                            
                                    
                                     
           
                     

          
                
                     
                                 
                                 
                           
            

      
                          
                                

     
(extend-protocol AsBits
  InputStream
  (bit-source [o] (JavaBitSource. (BitInput. (StreamInput. o))))

  OutputStream
  (bit-sink [o] (JavaBitSink. (BitOutput. (StreamOutput. o))))

  ByteBuffer
  (bit-source [o] (JavaBitSource. (BitInput. (BufferInput. o))))
  (bit-sink [o] (JavaBitSink. (BitOutput. (BufferOutput. o))))

  ReadableByteChannel
  (bit-source [o] (JavaBitSource. (BitInput. (ChannelInput. o nil))))

  WritableByteChannel
  (bit-sink [o] (JavaBitSink. (BitOutput. (ChannelOutput. o nil))))

  #=(java.lang.Class/forName "[B") ;; byte array
  (bit-source [o] (bit-source (ByteArrayInputStream. o))))

      
                       
       
                                       
                                    

(defn default-bit-sink []
        (bit-sink (ByteArrayOutputStream.))
                           )

;;;;;;;;;;;; This file autogenerated from src/cljx/shannon/io.cljx
