(ns shannon.compatibility
  (:require        [clj-time.core :as time]
                   [clj-time.coerce :refer [to-date from-date]]
                                       
                                          )
  (      :use                        [shannon.math-macros :as m])
        (import [java.util Date]))

      (set! *unchecked-math* true)

;; Exceptions
(def exception
        Exception
                 )

;; Characters (characters are strings of length one for compatibility with javascript)
(defn char->int [s]
        (int (first (str s)))
                          )

(defn int->char [i]
        (str (char i))
                                    )

;; Tests
(def is-float?
        float?
                                                 )
(def is-string?
        string?
                                                 )

      (defn is-date? [d]
        (let [t (type d)]
          (or (= t java.util.Date)
              (= t org.joda.time.DateTime))))
                                               

(defn is-boolean? [x]
  (= (boolean x) x))

;; Math

      (defn is-nan? [^double x] (Double/isNaN x))
                                              

      (defn is-infinite? [^double x] (Double/isInfinite x))
                                                            

(def fNaN
        (/ 0.0 0.0)
               )

(def fInfinity
        (/ 1.0 0.0)
                    )

(def pi
        Math/PI
                       )

      (defn pow [n m] (Math/pow n m))
                                          

      (defn atan [^double x] (Math/atan x))
                                                

      (defn ln [^double x] (Math/log x))
                                             

      (defn sin [^double x] (Math/sin x))
                                              

      (defn abs [^double x] (Math/abs x))
                                              

      (defn floor [^double x] (Math/floor x))
                                                  

      (defn round [^double x] (Math/round x))
                                                  

(defn roundd [^double x]
  (double (round x)))

      (defn ceiling [^double x] (Math/ceil x))
                                                   

;; working with longs
     
(defn num->arr [^long n]
  [(bit-and n 0xffffffff) (bit-shift-right n 32)])

      
                          
                        
                                     

     
(defn arr->num [[^long low ^long high]]
  (bit-or (bit-shift-left high 32) low))

      
                                           
                               

;; float processing
     
(defn get-float-parts [^double x]
  (let [bits (Double/doubleToLongBits x)
        exp (bit-and (bit-shift-right bits 52) 0x7ff)
        man (bit-and bits 0xfffffffffffff)]
    (if (zero? exp)
      [man -1074]
      [man (- exp 1074)])))

      
                                 
        
                      
                                                                           
                  
                                                                                        
                                           
                                     
                        
                                                        
                                                   
                                                    
                                       
                                     
                                          
                            
                                 
                     

;; Dates
(defn now []
        (Date.)
                   )

     
(defn decompose-date [d]
  (let [d (if (= (type d) org.joda.time.DateTime) d (from-date d))
        utcd (time/from-time-zone d time/utc)]
    ((juxt time/year
           time/month
           time/day
           time/hour
           time/minute
           time/second
           time/milli) utcd)))

      
                        
                                
                     
                           
                    
                     
                       
                       
                               

(defn recompose-date [year month day hours minutes seconds millisec]
       
  (to-date (time/date-time year month day hours minutes seconds millisec))

        
                                                                                               )

;;;;;;;;;;;; This file autogenerated from src/cljx/shannon/compatibility.cljx
