// Compiled by ClojureScript 0.0-2138
goog.provide('wagjo.data.array');
goog.require('cljs.core');
/**
* Returns an empty array.
*/
wagjo.data.array.empty = (function empty(){return [];
});
/**
* Returns true if a is an array.
*/
wagjo.data.array.array_QMARK_ = (function array_QMARK_(a){return (a instanceof Array);
});
/**
* Returns true if a is empty array or nil.
* Faster variant of clojure.core/empty?.
*/
wagjo.data.array.empty_QMARK_ = (function empty_QMARK_(a){return ((a == null)) || ((a.length === 0));
});
/**
* Returns the number of items in the array.
* (count nil) returns 0. Faster variant of clojure.core/count.
*/
wagjo.data.array.count = (function count(a){if((a == null))
{return 0;
} else
{return a.length;
}
});
/**
* Returns the value at the index. nth throws an exception if index
* out of bounds. Faster variant of clojure.core/nth
*/
wagjo.data.array.nth = (function nth(a,index){if((a == null))
{return null;
} else
{if(((index < 0)) || ((a.length <= index)))
{throw "nth: Index out of bounds!";
} else
{return (a[index]);
}
}
});
/**
* Returns the value at the index or not-found, if index
* out of bounds. Faster variant of clojure.core/nth
*/
wagjo.data.array.nth_STAR_ = (function nth_STAR_(a,index,not_found){if(((a == null)) || ((index < 0)) || ((a.length <= index)))
{return not_found;
} else
{return (a[index]);
}
});
/**
* Returns the value at the index. Does not check for boundaries.
* Faster variant of clojure.core/nth.
*/
wagjo.data.array.nth_unchecked = (function nth_unchecked(a,index){return (a[index]);
});
/**
* Same as, but much more efficient than, first.
* If the array is empty, returns nil.
*/
wagjo.data.array.peekl = (function peekl(a){if(wagjo.data.array.empty_QMARK_.call(null,a))
{return null;
} else
{return (a[0]);
}
});
/**
* Same as, but much more efficient than, last.
* If the array is empty, returns nil.
*/
wagjo.data.array.peekr = (function peekr(a){if(wagjo.data.array.empty_QMARK_.call(null,a))
{return null;
} else
{return (a[(a.length - 1)]);
}
});
wagjo.data.array.peek = wagjo.data.array.peekr;
/**
* Same as, but much more efficient than, first.
* Undefined behavior if the array is empty.
*/
wagjo.data.array.peekl_unchecked = (function peekl_unchecked(a){return (a[0]);
});
/**
* Same as, but much more efficient than, last.
* Undefined behavior if the array is empty.
*/
wagjo.data.array.peekr_unchecked = (function peekr_unchecked(a){return (a[(a.length - 1)]);
});
wagjo.data.array.peek_unchecked = wagjo.data.array.peekr_unchecked;
/**
* Returns cloned copy of array.
*/
wagjo.data.array.clone = (function clone(a){return a.slice();
});
/**
* Removes the last item from a. If the array is empty,
* throws an exception. Mutates input array. Returns nil.
*/
wagjo.data.array.pop_BANG_ = (function pop_BANG_(a){if(wagjo.data.array.empty_QMARK_.call(null,a))
{throw "Cannot pop empty array or nil!";
} else
{a.pop();
return null;
}
});
/**
* Sets the val at index. Mutates input array.
* Note - index must be <= (count a). Returns nil.
*/
wagjo.data.array.assoc_BANG_ = (function assoc_BANG_(a,index,val){(a[index] = val);
return null;
});
/**
* Sets the val at index. Mutates input array. f is a function that
* will take the old value and return the new value.
* Note - index must be < (count a). Returns nil.
*/
wagjo.data.array.update_BANG_ = (function update_BANG_(a,index,f){(a[index] = f.call(null,(a[index])));
return null;
});
/**
* Appends x at array a. Mutates input array. Returns nil.
*/
wagjo.data.array.conj_BANG_ = (function conj_BANG_(a,x){a.push(x);
return null;
});
/**
* Less clever array splice. Removes n elements after index
* (including index) before inserting. Inserts just one element
* x at index. Mutates input array. Returns array of removed items.
*/
wagjo.data.array.splice_BANG_ = (function splice_BANG_(a,index,n,x){return a.splice(index,n,x);
});
/**
* Clever array splice. Works just like Array.splice()
* (Changes the content of an array, adding new elements while removing
* old elements). Inserts elements from xs into a at index
* after removing n elements from that position.
* Mutates input array. Returns array of removed items.
*/
wagjo.data.array.splice_seq_BANG_ = (function splice_seq_BANG_(a,index,n,xs){var sfn = a.splice;var ar = [index,n];return sfn.apply(a,ar.concat(cljs.core.to_array.call(null,xs)));
});
/**
* Clever array splice. Works just like Array.splice()
* (Changes the content of an array, adding new elements while removing
* old elements). Inserts elements from axs into a at index
* after removing n elements from that position.
* Mutates input array. Returns array of removed items.
*/
wagjo.data.array.splice_arr_BANG_ = (function splice_arr_BANG_(a,index,n,axs){var sfn = a.splice;var ar = [index,n];return sfn.apply(a,ar.concat((function (){var or__3409__auto__ = axs;if(cljs.core.truth_(or__3409__auto__))
{return or__3409__auto__;
} else
{return [];
}
})()));
});
/**
* Inserts x into array a at index.
* Mutates input array. Returns nil.
*/
wagjo.data.array.insert_before_BANG_ = (function insert_before_BANG_(a,index,x){a.splice(index,0,x);
return null;
});
/**
* Inserts xs into array a at index.
* Mutates input array. Returns nil.
*/
wagjo.data.array.insert_before_seq_BANG_ = (function insert_before_seq_BANG_(a,index,xs){wagjo.data.array.splice_seq_BANG_.call(null,a,index,0,xs);
return null;
});
/**
* Inserts axs represented as array into array a at index.
* Mutates input array. Returns nil.
*/
wagjo.data.array.insert_before_arr_BANG_ = (function insert_before_arr_BANG_(a,index,axs){wagjo.data.array.splice_arr_BANG_.call(null,a,index,0,axs);
return null;
});
/**
* Removes one item from array a at index.
* Mutates input array. Returns the array of removed items.
*/
wagjo.data.array.remove_at_BANG_ = (function remove_at_BANG_(a,index){return a.splice(index,1);
});
/**
* Removes n items from array a starting at index.
* Mutates input array. Returns the array of removed items.
*/
wagjo.data.array.remove_n_BANG_ = (function remove_n_BANG_(a,index,n){return a.splice(index,n);
});
/**
* Removes all items from array a after index (including index).
* Mutates input array. Returns the array of removed items.
*/
wagjo.data.array.remove_after_BANG_ = (function remove_after_BANG_(a,index){return a.splice(index);
});
/**
* Removes all items from array a after index (including index).
* Mutates input array. Returns the array of removed items.
*/
wagjo.data.array.remove_before_BANG_ = (function remove_before_BANG_(a,index){return a.splice(0,index);
});
/**
* Returns the subarray of a beginning at start inclusive, and ending
* at end, exclusive.
*/
wagjo.data.array.slice = (function slice(a,start,end){return a.slice(start,end);
});
/**
* Returns the subarray of a beginning at start inclusive, until the
* end of array.
*/
wagjo.data.array.slice_from = (function slice_from(a,start){return a.slice(start);
});
/**
* Returns the subarray of a from its start, and ending
* at end, exclusive.
*/
wagjo.data.array.slice_to = (function slice_to(a,end){return a.slice(0,end);
});
/**
* Returns vector of arrays produced by splitting a at index pos.
*/
wagjo.data.array.split_at = (function split_at(a,index){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [wagjo.data.array.slice_to.call(null,a,index),wagjo.data.array.slice_from.call(null,a,index)], null);
});
/**
* Returns new array which is a concatenation of a1 and a2.
* Eager version of clojure.core/concat.
*/
wagjo.data.array.cat = (function cat(a1,a2){return a1.concat((function (){var or__3409__auto__ = a2;if(cljs.core.truth_(or__3409__auto__))
{return or__3409__auto__;
} else
{return [];
}
})());
});
/**
* Returns new array without first item. If the array is empty,
* throws an exception.
*/
wagjo.data.array.popl = (function popl(a){if(wagjo.data.array.empty_QMARK_.call(null,a))
{throw "Cannot pop empty or nil array.";
} else
{return a.slice(1);
}
});
/**
* Returns new array without last item. If the array is empty,
* throws an exception.
*/
wagjo.data.array.popr = (function popr(a){if(wagjo.data.array.empty_QMARK_.call(null,a))
{throw "Cannot pop empty or nil array.";
} else
{return a.slice(0,-1);
}
});
wagjo.data.array.pop = wagjo.data.array.popr;
/**
* Returns new array without first item.
* Undefined behavior if the array is empty.
*/
wagjo.data.array.popl_unchecked = (function popl_unchecked(a){return a.slice(1);
});
/**
* Returns new array without last item.
* Undefined behavior if the array is empty.
*/
wagjo.data.array.popr_unchecked = (function popr_unchecked(a){return a.slice(0,-1);
});
wagjo.data.array.pop_unchecked = wagjo.data.array.popr_unchecked;
/**
* Assoc[iate]. Returns a new array that contains val at index.
* Note - index must be <= (count array).
*/
wagjo.data.array.assoc = (function assoc(a,index,val){var newa = wagjo.data.array.clone.call(null,a);wagjo.data.array.assoc_BANG_.call(null,newa,index,val);
return newa;
});
/**
* Returns a new array that contains updated val at index.
* Note - index must be < (count array).
*/
wagjo.data.array.update = (function update(a,index,f){var newa = wagjo.data.array.clone.call(null,a);wagjo.data.array.update_BANG_.call(null,newa,index,f);
return newa;
});
/**
* conj[oin]. Returns a new array with var added to the left.
*/
wagjo.data.array.conjl = (function conjl(a,val){var newa = wagjo.data.array.clone.call(null,a);wagjo.data.array.insert_before_BANG_.call(null,newa,0,val);
return newa;
});
/**
* conj[oin]. Returns a new array with var added to the right.
*/
wagjo.data.array.conjr = (function conjr(a,val){var newa = wagjo.data.array.clone.call(null,a);wagjo.data.array.conj_BANG_.call(null,newa,val);
return newa;
});
wagjo.data.array.conj = wagjo.data.array.conjr;
/**
* conj[oin]. Returns a new array with var-arr added to the left.
* Order of elements is retained.
*/
wagjo.data.array.conjl_arr = (function conjl_arr(a,val_arr){return wagjo.data.array.cat.call(null,val_arr,a);
});
/**
* conj[oin]. Returns a new array with var-arr added to the right.
*/
wagjo.data.array.conjr_arr = (function conjr_arr(a,val_arr){return wagjo.data.array.cat.call(null,a,val_arr);
});
wagjo.data.array.conj_arr = wagjo.data.array.conjr_arr;
/**
* Returns new array with n items starting at index pos
* replaced with val.
*/
wagjo.data.array.splice = (function splice(a,index,n,val){var newa = wagjo.data.array.clone.call(null,a);wagjo.data.array.splice_BANG_.call(null,newa,index,n,val);
return newa;
});
/**
* Returns new array with n items starting at index pos
* replaced with items in val-arr.
*/
wagjo.data.array.splice_arr = (function splice_arr(a,index,n,val_arr){var newa = wagjo.data.array.clone.call(null,a);wagjo.data.array.splice_arr_BANG_.call(null,newa,index,n,val_arr);
return newa;
});
/**
* Returns a new array with val inserted before index.
*/
wagjo.data.array.insert_before = (function insert_before(a,index,val){var newa = wagjo.data.array.clone.call(null,a);wagjo.data.array.insert_before_BANG_.call(null,newa,index,val);
return newa;
});
/**
* Returns a new array with val-arr inserted before index.
*/
wagjo.data.array.insert_before_arr = (function insert_before_arr(a,index,val_arr){var newa = wagjo.data.array.clone.call(null,a);wagjo.data.array.insert_before_arr_BANG_.call(null,newa,index,val_arr);
return newa;
});
/**
* Returns new array with item at index position removed.
*/
wagjo.data.array.remove_at = (function remove_at(a,index){var newa = wagjo.data.array.clone.call(null,a);wagjo.data.array.remove_at_BANG_.call(null,newa,index);
return newa;
});
/**
* Returns new array with n items starting at index position
* (index position included) removed.
*/
wagjo.data.array.remove_n = (function remove_n(a,index,n){var newa = wagjo.data.array.clone.call(null,a);wagjo.data.array.remove_n_BANG_.call(null,newa,index,n);
return newa;
});
/**
* Returns result of ripping array at index pos.
* Returns [pre-arr item suf-arr]. Throws exception for empty array.
*/
wagjo.data.array.rip = (function rip(a,index){if(wagjo.data.array.empty_QMARK_.call(null,a))
{throw "Cannot rip empty or nil array!";
} else
{if((a.length === 1))
{return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [wagjo.data.array.empty.call(null),(a[0]),wagjo.data.array.empty.call(null)], null);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [wagjo.data.array.slice_to.call(null,a,index),(a[index]),wagjo.data.array.slice_from.call(null,a,(index + 1))], null);
} else
{return null;
}
}
}
});
/**
* Returns sewed array. Kinda opposite of rip.
*/
wagjo.data.array.sew = (function sew(pre_arr,item_arr,suf_arr){return pre_arr.concat((function (){var or__3409__auto__ = item_arr;if(cljs.core.truth_(or__3409__auto__))
{return or__3409__auto__;
} else
{return [];
}
})(),(function (){var or__3409__auto__ = suf_arr;if(cljs.core.truth_(or__3409__auto__))
{return or__3409__auto__;
} else
{return [];
}
})());
});
/**
* Returns new array with n items trimmed from left.
*/
wagjo.data.array.triml = (function triml(a,n){return a.slice(n);
});
/**
* Returns new array with n items trimmed from right.
*/
wagjo.data.array.trimr = (function trimr(a,n){return a.slice(0,(- n));
});
/**
* Returns new array with nl items trimmed from left and nr items
* trimmed from right.
*/
wagjo.data.array.trim = (function trim(a,nl,nr){return a.slice(nl,(- nr));
});
/**
* Eager array map. Returns new array.
* f takes element as an argument.
* Eager version of clojure.core/map.
*/
wagjo.data.array.mape = (function mape(f,a){if((a == null))
{return null;
} else
{var a__$1 = cljs.core.aclone.call(null,a);var i = 0;while(true){
if((i < a__$1.length))
{var nval = f.call(null,(a__$1[i]));(a__$1[i] = nval);
{
var G__5298 = (i + 1);
i = G__5298;
continue;
}
} else
{return a__$1;
}
break;
}
}
});
/**
* Eager array map-indexed. Returns new array.
* f takes two arguments, index and element.
* Eager version of clojure.core/map-indexed.
*/
wagjo.data.array.mape_indexed = (function mape_indexed(f,a){if((a == null))
{return null;
} else
{var a__$1 = cljs.core.aclone.call(null,a);var i = 0;while(true){
if((i < a__$1.length))
{var nval = f.call(null,i,(a__$1[i]));(a__$1[i] = nval);
{
var G__5299 = (i + 1);
i = G__5299;
continue;
}
} else
{return a__$1;
}
break;
}
}
});
/**
* Array reduce. Faster variant of clojure.core/reduce.
*/
wagjo.data.array.reduce = (function reduce(f,init,a){if((a == null))
{return init;
} else
{var val = init;var i = 0;while(true){
if((i < a.length))
{var nval = f.call(null,val,(a[i]));if(cljs.core.reduced_QMARK_.call(null,nval))
{return cljs.core.deref.call(null,nval);
} else
{{
var G__5300 = nval;
var G__5301 = (i + 1);
val = G__5300;
i = G__5301;
continue;
}
}
} else
{return val;
}
break;
}
}
});
/**
* Array reduce without starting value.
* Faster variant of clojure.core/reduce.
*/
wagjo.data.array.reduce2 = (function reduce2(f,a){if(wagjo.data.array.empty_QMARK_.call(null,a))
{var r = f.call(null);if(cljs.core.reduced_QMARK_.call(null,r))
{return cljs.core.deref.call(null,r);
} else
{return r;
}
} else
{var val = (a[0]);var i = 1;while(true){
if((i < a.length))
{var nval = f.call(null,val,(a[i]));if(cljs.core.reduced_QMARK_.call(null,nval))
{return cljs.core.deref.call(null,nval);
} else
{{
var G__5302 = nval;
var G__5303 = (i + 1);
val = G__5302;
i = G__5303;
continue;
}
}
} else
{return val;
}
break;
}
}
});
/**
* Reverse array reduce. Very fast.
*/
wagjo.data.array.reduce_reverse = (function reduce_reverse(f,init,a){var val = init;var i = (((a == null))?0:a.length);while(true){
if((i > 0))
{var i__$1 = (i - 1);var nval = f.call(null,val,(a[i__$1]));if(cljs.core.reduced_QMARK_.call(null,nval))
{return cljs.core.deref.call(null,nval);
} else
{{
var G__5304 = nval;
var G__5305 = i__$1;
val = G__5304;
i = G__5305;
continue;
}
}
} else
{return val;
}
break;
}
});
/**
* Reverse array reduce without starting value.
* Very fast.
*/
wagjo.data.array.reduce2_reverse = (function reduce2_reverse(f,a){if(wagjo.data.array.empty_QMARK_.call(null,a))
{var r = f.call(null);if(cljs.core.reduced_QMARK_.call(null,r))
{return cljs.core.deref.call(null,r);
} else
{return r;
}
} else
{var val = (a[(a.length - 1)]);var i = (a.length - 1);while(true){
if((i > 0))
{var i__$1 = (i - 1);var nval = f.call(null,val,(a[i__$1]));if(cljs.core.reduced_QMARK_.call(null,nval))
{return cljs.core.deref.call(null,nval);
} else
{{
var G__5306 = nval;
var G__5307 = i__$1;
val = G__5306;
i = G__5307;
continue;
}
}
} else
{return val;
}
break;
}
}
});
/**
* Array reduce-kv. Faster variant of clojure.core/reduce-kv.
*/
wagjo.data.array.reduce_kv = (function reduce_kv(f,init,a){if((a == null))
{return init;
} else
{var val = init;var i = 0;while(true){
if((i < a.length))
{var nval = f.call(null,val,i,(a[i]));if(cljs.core.reduced_QMARK_.call(null,nval))
{return cljs.core.deref.call(null,nval);
} else
{{
var G__5308 = nval;
var G__5309 = (i + 1);
val = G__5308;
i = G__5309;
continue;
}
}
} else
{return val;
}
break;
}
}
});
/**
* Array reduce-kv, without starting value.
* Faster variant of clojure.core/reduce-kv.
*/
wagjo.data.array.reduce2_kv = (function reduce2_kv(f,a){if(wagjo.data.array.empty_QMARK_.call(null,a))
{var r = f.call(null);if(cljs.core.reduced_QMARK_.call(null,r))
{return cljs.core.deref.call(null,r);
} else
{return r;
}
} else
{var val = (a[0]);var i = 1;while(true){
if((i < a.length))
{var nval = f.call(null,val,i,(a[i]));if(cljs.core.reduced_QMARK_.call(null,nval))
{return cljs.core.deref.call(null,nval);
} else
{{
var G__5310 = nval;
var G__5311 = (i + 1);
val = G__5310;
i = G__5311;
continue;
}
}
} else
{return val;
}
break;
}
}
});
/**
* Reverse array reduce. Very fast.
*/
wagjo.data.array.reduce_kv_reverse = (function reduce_kv_reverse(f,init,a){var val = init;var i = (((a == null))?0:a.length);while(true){
if((i > 0))
{var i__$1 = (i - 1);var nval = f.call(null,val,i__$1,(a[i__$1]));if(cljs.core.reduced_QMARK_.call(null,nval))
{return cljs.core.deref.call(null,nval);
} else
{{
var G__5312 = nval;
var G__5313 = i__$1;
val = G__5312;
i = G__5313;
continue;
}
}
} else
{return val;
}
break;
}
});
/**
* Reverse array reduce. Very fast.
*/
wagjo.data.array.reduce2_kv_reverse = (function reduce2_kv_reverse(f,a){if(wagjo.data.array.empty_QMARK_.call(null,a))
{var r = f.call(null);if(cljs.core.reduced_QMARK_.call(null,r))
{return cljs.core.deref.call(null,r);
} else
{return r;
}
} else
{var val = (a[(a.length - 1)]);var i = (a.length - 1);while(true){
if((i > 0))
{var i__$1 = (i - 1);var nval = f.call(null,val,i__$1,(a[i__$1]));if(cljs.core.reduced_QMARK_.call(null,nval))
{return cljs.core.deref.call(null,nval);
} else
{{
var G__5314 = nval;
var G__5315 = i__$1;
val = G__5314;
i = G__5315;
continue;
}
}
} else
{return val;
}
break;
}
}
});
/**
* Returns index of val inside a.
* Returns -1 if val was not found.
*/
wagjo.data.array.index_of = (function index_of(a,val){return a.indexOf(val);
});
/**
* Returns index of val inside a, starting at
* index-from. Returns -1 if val was not found.
*/
wagjo.data.array.index_of_from = (function index_of_from(a,val,index_from){return a.indexOf(val,index_from);
});
